<?php

if (!function_exists('generateStarRating')) {
    /**
     * Generate HTML for a star rating display.
     *
     * @param float|null $rating The rating value (e.g., 4.5).
     * @param int $maxRating The maximum rating (usually 5).
     * @return string The HTML for the star rating.
     */
    function generateStarRating($rating, $maxRating = 5)
    {
        $rating = (float) $rating;
        $fullStars = floor($rating);
        $halfStar = ceil($rating) > $fullStars;
        $emptyStars = $maxRating - ceil($rating);

        $html = '';

        for ($i = 0; $i < $fullStars; $i++) {
            $html .= '<i class="fas fa-star text-yellow-400 text-xs"></i>';
        }

        if ($halfStar) {
            $html .= '<i class="fas fa-star-half-alt text-yellow-400 text-xs"></i>';
        }

        for ($i = 0; $i < $emptyStars; $i++) {
            $html .= '<i class="far fa-star text-yellow-400 text-xs"></i>';
        }

        return $html;
    }
}
