<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Scan;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function dashboard()
    {
        $user = Auth::user();

        // Check if the user is an admin
        if ($user->isAdmin()) {
            // Data for Admin Dashboard
            $data = [
                'totalProducts' => Product::count(),
                'totalUsers' => User::count(),
                'todayScans' => Scan::whereDate('created_at', today())->count(),
                'weeklyScans' => Scan::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])->count(),
            ];
            return view('admin.dashboard', compact('data'));
        }

        // Data for regular User Dashboard
        $totalProducts = Product::count();
        $totalUsers = User::count();
        $todayScans = Scan::whereDate('created_at', today())->count();
        $weeklyScans = Scan::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])->count();

        return view('profile.dashboard', compact(
            'totalProducts', 'totalUsers', 'todayScans', 'weeklyScans'
        ));
    }
}
