<?php
namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Product;

class HomeController extends Controller
{
    public function index()
    {

        // Eager load all nested children and their product counts efficiently.
        $categories = Category::whereNull('parent_id')
            ->withCount('products')
            ->with('childrenRecursive') // This loads all descendants and their respective product counts.
            ->get();

        $featuredProducts = Product::where('featured', true)->where('in_stock', true)->latest()->take(8)->get();


        return view('frontend.pages.home', compact('categories', 'featuredProducts'));
    }
}
