<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // For MySQL - alter the ENUM column
        if (config('database.default') === 'mysql') {
            DB::statement("ALTER TABLE products MODIFY COLUMN status ENUM('In Warehouse', 'Shipped', 'Delivered', 'Returned', 'Sold') DEFAULT 'In Warehouse'");
        }
    }

    public function down()
    {
        // Revert back if needed
        if (config('database.default') === 'mysql') {
            // Before changing the ENUM, update existing 'Returned' values to a valid old status.
            DB::table('products')->where('status', 'Returned')->update(['status' => 'In Warehouse']);

            // Now, safely revert the ENUM definition.
            DB::statement("ALTER TABLE products MODIFY COLUMN status ENUM('In Warehouse', 'Shipped', 'Delivered', 'Sold', 'Damaged') DEFAULT 'In Warehouse'");
        }
    }
};