<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->boolean('featured')->default(false)->after('notes');
            $table->boolean('in_stock')->default(true)->after('featured');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Make the down method safe by checking if columns exist before dropping.
            if (Schema::hasColumns('products', ['featured', 'in_stock'])) {
                $table->dropColumn(['featured', 'in_stock']);
            }
        });
    }
};
