<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // 'image' column was likely missed from a previous migration
            if (!Schema::hasColumn('products', 'image')) {
                $table->string('image')->nullable()->after('product_name');
            }

            if (!Schema::hasColumn('products', 'description')) {
                $table->text('description')->nullable()->after('product_name');
            }
            if (!Schema::hasColumn('products', 'price')) {
                $table->decimal('price', 10, 2)->nullable();
            }
            if (!Schema::hasColumn('products', 'cost')) {
                $table->decimal('cost', 10, 2)->nullable();
            }
            if (!Schema::hasColumn('products', 'warranty_period')) {
                $table->string('warranty_period')->nullable();
            }
            if (!Schema::hasColumn('products', 'manufacture_date')) {
                $table->date('manufacture_date')->nullable();
            }
            if (!Schema::hasColumn('products', 'expiry_date')) {
                $table->date('expiry_date')->nullable();
            }
            if (!Schema::hasColumn('products', 'batch_number')) {
                $table->string('batch_number')->nullable();
            }
            if (!Schema::hasColumn('products', 'supplier_name')) {
                $table->string('supplier_name')->nullable();
            }
            if (!Schema::hasColumn('products', 'location')) {
                $table->string('location')->nullable();
            }
            if (!Schema::hasColumn('products', 'notes')) {
                $table->text('notes')->nullable();
            }
            if (!Schema::hasColumn('products', 'distributor_contact')) {
                $table->string('distributor_contact')->nullable()->after('distributor_code');
            }
            if (!Schema::hasColumn('products', 'distributor_address')) {
                $table->string('distributor_address')->nullable()->after('distributor_contact');
            }
            if (!Schema::hasColumn('products', 'featured')) {
                $table->boolean('featured')->default(false)->after('notes');
            }
            if (!Schema::hasColumn('products', 'in_stock')) {
                $table->boolean('in_stock')->default(true)->after('featured');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // The down method should reverse all columns this migration *might* have created.
            // We check for existence before dropping to make it safe and idempotent.
            $columnsToDrop = [
                'image',
                'description',
                'price',
                'cost',
                'warranty_period',
                'manufacture_date',
                'expiry_date',
                'batch_number',
                'supplier_name',
                'location',
                'notes',
                'distributor_contact',
                'distributor_address',
                'featured',
                'in_stock',
            ];

            // Drop only the columns that actually exist on the table.
            $existingColumns = Schema::getColumnListing('products');
            $columns = array_intersect($columnsToDrop, $existingColumns);

            if (!empty($columns)) {
                $table->dropColumn($columns);
            }
        });
    }
};
