<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration // Consider renaming the class to CreateWishlistsTable
{
    public function up(): void
    {
        Schema::create('wishlists', function (Blueprint $table) {
            $table->id();

            // Define and constrain the user_id column
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // Define and constrain the product_id column
            $table->foreignId('product_id')->constrained()->onDelete('cascade');

            $table->timestamps();

            // Ensure a user can only add a product to their wishlist once
            $table->unique(['user_id', 'product_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wishlists');
    }
};