<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Mobile Phones',
                'slug' => 'mobile-phones',
                'icon' => 'fas fa-mobile-alt',
            ],
            [
                'name' => 'Accessories',
                'slug' => 'accessories',
                'icon' => 'fas fa-headphones',
            ],
            [
                'name' => 'Tablets',
                'slug' => 'tablets',
                'icon' => 'fas fa-tablet-alt',
            ],
        ];

        foreach ($categories as $category) {
            $parent = Category::firstOrCreate(
                ['slug' => $category['slug']],
                ['name' => $category['name'], 'icon' => $category['icon']]
            );
        }

        // Add sub-categories for Mobile Phones
        $mobileCategory = Category::where('slug', 'mobile-phones')->first();
        if ($mobileCategory) {
            Category::firstOrCreate(['slug' => 'smart-phones'], ['name' => 'Smart Phones', 'parent_id' => $mobileCategory->id, 'icon' => 'fas fa-mobile']);
            Category::firstOrCreate(['slug' => 'feature-phones'], ['name' => 'Feature Phones', 'parent_id' => $mobileCategory->id, 'icon' => 'fas fa-mobile-alt']);
        }

        // Re-run seeder command: php artisan db:seed --class=CategorySeeder
    }
}
