<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    public function run()
    {
        $products = [
            [
                'serial_no' => 'INT-2301-199783',
                'imei' => '358879107414709',
                'barcode' => '800501123456789',
                'product_name' => 'Nokia 105 (2023)',
                'quality' => 'Authentic',
                'description' => 'Basic feature phone with long battery life',
                'image' => 'products/nokia-105-2023.jpg',
                'distributor_name' => 'Warehouse A',
                'distributor_code' => 'DIST-WHA',
                'color' => 'Black',
                'status' => 'In Warehouse',
                'scanned_by' => 'System',
                'scanned_at' => now()
            ],
            [
                'serial_no' => 'INT-2301-199784',
                'imei' => '358879107414710',
                'barcode' => '800501123456790',
                'product_name' => 'Nokia 5310',
                'quality' => 'Authentic',
                'description' => 'Music phone with dedicated buttons',
                'image' => 'products/nokia-5310.jpg',
                'distributor_name' => 'Warehouse B',
                'distributor_code' => 'DIST-WHB',
                'color' => 'Red',
                'status' => 'In Warehouse',
                'scanned_by' => 'Scanner 001',
                'scanned_at' => now()->subHours(2)
            ]
        ];

        foreach ($products as $product) {
            Product::create($product);
        }

        // Generate some random scanned products
        for ($i = 0; $i < 20; $i++) {
            $productNames = [
                'Nokia 105' => 'products/nokia-105.jpg',
                'Nokia 5310' => 'products/nokia-5310.jpg',
                'Nokia 210' => 'products/nokia-210.jpg',
                'Nokia 1100' => 'products/nokia-1100.jpg'
            ];
            $productName = array_rand($productNames);
            $image = $productNames[$productName];

            Product::create([
                'serial_no' => 'AUTO-' . now()->format('Ymd') . '-' . sprintf('%06d', $i),
                'imei' => '35' . sprintf('%013d', rand(1000000000000, 9999999999999)),
                'barcode' => '84' . sprintf('%011d', rand(10000000000, 99999999999)),
                'product_name' => $productName,
                'image' => $image,
                'quality' => ['Authentic', 'Premium', 'Standard'][rand(0, 2)],
                'description' => 'Automatically generated product',
                'distributor_name' => 'System Generated',
                'distributor_code' => 'DIST-SYS',
                'color' => ['Black', 'White', 'Red', 'Blue'][rand(0, 3)],
                'status' => 'In Warehouse',
                'scanned_by' => 'Auto-Scanner',
                'scanned_at' => now()->subHours(rand(1, 48))
            ]);
        }
    }
}