@extends('layouts.app')
@section('content')
    @section('header', 'Admin Dashboard')
    @section('subheader', 'Welcome to admin panel')

    <!-- Welcome Message -->
    <div class="bg-gradient-to-r from-primary to-purple-600 overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-2xl font-bold mb-2">Welcome back, Admin {{ Auth::user()->name }}! 👋</h3>
                    <p class="opacity-90">Admin dashboard - Full system control</p>
                    @if(Auth::user()->last_login_at)
                    <div class="mt-2 text-sm">
                        <span class="bg-primary/30 px-2 py-1 rounded">Last login: {{ Auth::user()->last_login_at->format('M j, Y g:i A') }}</span>
                    </div>
                    @endif
                </div>
                <div class="hidden md:block">
                    <i class="fas fa-user-shield text-4xl opacity-20"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-primary/10 text-primary mr-4">
                        <i class="fas fa-box text-lg "></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Total Products</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $data['totalProducts'] ?? '0' }}</p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-green-600">
                    <i class="fas fa-database"></i> In system
                </div>
            </div>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-purple-100 text-purple-600 mr-4">
                        <i class="fas fa-users text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Total Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $data['totalUsers'] ?? '0' }}</p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-primary">
                    <i class="fas fa-user-check"></i> Registered users
                </div>
            </div>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4">
                        <i class="fas fa-barcode text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Today's Scans</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $data['todayScans'] ?? '0' }}</p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-green-600">
                    <i class="fas fa-sync-alt"></i> Scanned today
                </div>
            </div>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4">
                        <i class="fas fa-chart-bar text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Weekly Scans</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $data['weeklyScans'] ?? '0' }}</p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-yellow-600">
                    <i class="fas fa-calendar-week"></i> This week's activity
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Quick Actions -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-6">Admin Quick Actions</h3>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <a href="{{ route('admin.products') }}" class="bg-primary/10 hover:bg-primary/20 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-primary/30">
                    <i class="fas fa-boxes text-primary text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">Manage Products</p>
                    <p class="text-xs text-gray-500 mt-1">Full product control</p>
                </a>

                <a href="{{ route('admin.scanner.index') }}" class="bg-green-50 hover:bg-green-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-green-200">
                    <i class="fas fa-barcode text-green-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">Scan Items</p>
                    <p class="text-xs text-gray-500 mt-1">Quick inventory check</p>
                </a>

                <a href="{{ route('admin.products') }}" class="bg-purple-50 hover:bg-purple-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-purple-200">
                    <i class="fas fa-list-alt text-purple-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">View Products</p>
                    <p class="text-xs text-gray-500 mt-1">Browse all inventory</p>
                </a>

                <a href="{{ route('profile.edit') }}" class="bg-yellow-50 hover:bg-yellow-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-yellow-200">
                    <i class="fas fa-cog text-yellow-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">Admin Settings</p>
                    <p class="text-xs text-gray-500 mt-1">Profile settings</p>
                </a>
            </div>
        </div>
    </div>

    <!-- Admin Recent Activity -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Admin Panel</h3>
            <div class="space-y-4">
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-primary/10 text-primary mr-3">
                        <i class="fas fa-user-shield text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Administrator Access</p>
                        <p class="text-sm text-gray-500">Full system control privileges</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-green-100 text-green-600 mr-3">
                        <i class="fas fa-boxes text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Product Management</p>
                        <p class="text-sm text-gray-500">Add, edit, delete products</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-red-100 text-red-600 mr-3">
                        <i class="fas fa-trash-alt text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Delete Products</p>
                        <p class="text-sm text-gray-500">Remove products from system</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-purple-100 text-purple-600 mr-3">
                        <i class="fas fa-chart-bar text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Analytics & Reports</p>
                        <p class="text-sm text-gray-500">View system statistics</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
