@foreach($products as $product)
@php
    // Split product name into brand and model
    $nameParts = explode(' ', $product->product_name, 2);
    $brand = $nameParts[0] ?? 'N/A';
    $model = $nameParts[1] ?? 'N/A';

    // The 'gallery_images' attribute is already cast to an array by the model.
    $galleryImages = $product->gallery_images ?? [];

    // Determine the primary image
    $primaryImage = !empty($galleryImages) && isset($galleryImages[0]['image']) ? $galleryImages[0]['image'] : $product->image;

    // Fallback placeholder if nothing found
    $imageUrl = $primaryImage ? url('storage/' . $primaryImage) : 'https://via.placeholder.com/150';
@endphp

<tr class="hover:bg-gray-50 transition-shadow duration-200 hover:shadow-md" data-product-id="{{ $product->id }}">
    <td data-label="Image" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500">
        <img src="{{ $imageUrl }}"
             alt="{{ $product->product_name }}"
             class="h-12 w-12 sm:h-12 sm:w-12 object-cover rounded-md cursor-pointer hover:opacity-75"
             onclick="openImageViewModal('{{ $imageUrl }}', @js($product->product_name))">
    </td>

    <td data-label="Brand" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-semibold">{{ $brand }}</td>
    <td data-label="Model" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $model }}</td>

    <td data-label="Color" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500">
        <div class="flex items-center gap-2">
            @php
                $colors = $product->color ?? [];
            @endphp

            @foreach($colors as $color)
                @php $colorName = is_string($color) ? $color : ''; @endphp
                <span class="color-indicator"
                      style="background-color: {{ strtolower($colorName) }}; border: 1px solid #ccc;"
                      title="{{ $colorName }}"></span>
            @endforeach

            <span>{{ implode(', ', array_filter($colors, 'is_string')) }}</span>
        </div>
    </td>

    <td data-label="PP" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">{{ number_format($product->cost, 2) }}</td>
    <td data-label="RP" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">{{ number_format($product->retail_price, 2) }}</td>
    <td data-label="DP" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-green-700 font-semibold text-right">
        {{ $product->dealer_price ? number_format($product->dealer_price, 2) : 'N/A' }}
    </td>
    <td data-label="MRP" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">{{ number_format($product->price, 2) }}</td>

    <td data-label="Stock" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500">
        <div class="dropdown">
            <div id="status-btn-{{ $product->id }}" class="dropdown-btn" onclick="toggleDropdown('status-dropdown-{{ $product->id }}', event)">
                <span id="status-badge-{{ $product->id }}"
                      class="status-badge
                        @switch($product->status)
                            @case('In Warehouse') bg-blue-100 text-blue-800 @break
                            @case('Shipped') bg-amber-100 text-amber-800 @break
                            @case('Delivered') bg-green-100 text-green-800 @break
                            @case('Sold') bg-purple-100 text-purple-800 @break
                            @case('Returned') bg-red-100 text-red-800 @break
                            @default bg-gray-100 text-gray-800
                        @endswitch">
                    {{ $product->status }}
                </span>
                <i class="fas fa-chevron-down text-xs ml-1"></i>
            </div>

            <div id="status-dropdown-{{ $product->id }}" class="dropdown-content">
                <a class="dropdown-item" onclick="updateProductField('{{ $product->id }}', 'status', 'In Warehouse')">
                    <span class="status-badge bg-blue-100 text-blue-800">In Warehouse</span>
                </a>
                <a class="dropdown-item" onclick="updateProductField('{{ $product->id }}', 'status', 'Shipped')">
                    <span class="status-badge bg-amber-100 text-amber-800">Shipped</span>
                </a>
                <a class="dropdown-item" onclick="updateProductField('{{ $product->id }}', 'status', 'Delivered')">
                    <span class="status-badge bg-green-100 text-green-800">Delivered</span>
                </a>
                <a class="dropdown-item" onclick="updateProductField('{{ $product->id }}', 'status', 'Sold')">
                    <span class="status-badge bg-purple-100 text-purple-800">Sold</span>
                </a>
                <a class="dropdown-item" onclick="updateProductField('{{ $product->id }}', 'status', 'Returned')">
                    <span class="status-badge bg-red-100 text-red-800">Returned</span>
                </a>
            </div>
        </div>
    </td>

    <td data-label="Actions" class="px-2 sm:px-6 py-4 whitespace-nowrap text-sm font-medium">
        <div class="flex items-center space-x-2 sm:space-x-4">
            <a href="{{ route('admin.stock.edit', $product->id) }}"
               class="text-indigo-600 hover:text-indigo-900"
               title="Edit Product">
                <i class="fas fa-pencil-alt"></i>
            </a>

            <form action="{{ route('admin.products.delete', $product->id) }}"
                  method="POST"
                  onsubmit="return confirm('Are you sure you want to delete this product?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="text-red-600 hover:text-red-900" title="Delete Product">
                    <i class="fas fa-trash"></i>
                </button>
            </form>
        </div>
    </td>
</tr>
@endforeach
