@extends('frontend.layouts.app')

@section('title', 'About Us - NewTech Mobile')

@section('content')
    <!-- Page Title -->
    <div class="bg-gradient-to-r from-blue-50 to-indigo-100 py-16 px-4 border-b border-gray-200">
        <div class="container mx-auto max-w-7xl text-center">
            <nav class="mb-4" aria-label="breadcrumb">
                <ol class="flex items-center justify-center space-x-2 text-sm text-gray-600">
                    <li><a href="{{ route('home') }}" class="hover:text-blue-600 transition-colors duration-200">Home</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="font-semibold text-gray-800" aria-current="page">About Us</li>
                </ol>
            </nav>
            <h1 class="text-4xl md:text-5xl font-bold text-gray-900 mb-3">About NewTech Mobile</h1>
            <p class="text-gray-600 text-lg max-w-3xl mx-auto">Your trusted partner for authentic mobile technology, dedicated to quality and customer satisfaction.</p>
        </div>
    </div>

    <!-- Main Content -->
    <section class="py-16 lg:py-24 bg-white">
        <div class="container mx-auto max-w-7xl px-4">

            <!-- Our Story Section -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-16 lg:mb-24">
                <div class="order-2 lg:order-1">
                    <h2 class="text-3xl font-bold text-gray-800 mb-4">Our Story</h2>
                    <p class="text-gray-600 leading-relaxed mb-4">
                        Founded with a mission to combat counterfeit products in the electronics market, NewTech Mobile has grown into a leading destination for genuine smartphones and accessories. We believe that every customer deserves peace of mind, knowing their purchase is 100% authentic and backed by reliable service.
                    </p>
                    <p class="text-gray-600 leading-relaxed">
                        Our journey began with a simple idea: to create a trustworthy platform where technology enthusiasts can shop with confidence. Today, we are proud to offer a curated selection of the latest devices, all verifiable through our unique authenticity system.
                    </p>
                </div>
                <div class="order-1 lg:order-2">
                    <img src="https://images.unsplash.com/photo-1556740738-b6a63e27c4df?auto=format&fit=crop&w=1470&q=80" alt="Our Team" class="rounded-2xl shadow-lg w-full h-auto">
                </div>
            </div>

            <!-- Our Mission & Vision -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-16 lg:mb-24">
                <div class="bg-blue-50 p-8 rounded-2xl border border-blue-100">
                    <div class="w-12 h-12 bg-blue-600 text-white rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-rocket text-xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800 mb-3">Our Mission</h3>
                    <p class="text-gray-600 leading-relaxed">
                        To provide a secure and transparent shopping experience by integrating a robust product verification system. We are committed to offering the latest technology at competitive prices, ensuring authenticity, quality, and customer satisfaction are at the heart of everything we do.
                    </p>
                </div>
                <div class="bg-purple-50 p-8 rounded-2xl border border-purple-100">
                    <div class="w-12 h-12 bg-purple-600 text-white rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-eye text-xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800 mb-3">Our Vision</h3>
                    <p class="text-gray-600 leading-relaxed">
                        To be the most trusted and customer-centric electronics retailer in the region, pioneering innovative solutions that protect consumers and build lasting relationships based on trust and transparency.
                    </p>
                </div>
            </div>

            <!-- Why Choose Us Section -->
            <div class="text-center mb-16 lg:mb-24">
                <h2 class="text-3xl font-bold text-gray-800 mb-4">Why Choose NewTech?</h2>
                <p class="text-gray-600 max-w-3xl mx-auto">We are more than just a retailer. We are your partners in technology, committed to delivering excellence at every step.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center p-6 bg-gray-50 rounded-xl border border-gray-100 hover:shadow-lg hover:border-blue-200 transition-all duration-300">
                    <div class="w-16 h-16 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-shield-alt text-2xl"></i>
                    </div>
                    <h4 class="font-bold text-lg mb-2">Guaranteed Authenticity</h4>
                    <p class="text-gray-600 text-sm">Verify every product with our unique serial number system.</p>
                </div>
                <div class="text-center p-6 bg-gray-50 rounded-xl border border-gray-100 hover:shadow-lg hover:border-green-200 transition-all duration-300">
                    <div class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-headset text-2xl"></i>
                    </div>
                    <h4 class="font-bold text-lg mb-2">Exceptional Support</h4>
                    <p class="text-gray-600 text-sm">Our dedicated team is here to help you 24/7.</p>
                </div>
                <div class="text-center p-6 bg-gray-50 rounded-xl border border-gray-100 hover:shadow-lg hover:border-yellow-200 transition-all duration-300">
                    <div class="w-16 h-16 bg-yellow-100 text-yellow-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-shipping-fast text-2xl"></i>
                    </div>
                    <h4 class="font-bold text-lg mb-2">Fast & Secure Delivery</h4>
                    <p class="text-gray-600 text-sm">Get your products delivered to your doorstep quickly and safely.</p>
                </div>
                <div class="text-center p-6 bg-gray-50 rounded-xl border border-gray-100 hover:shadow-lg hover:border-purple-200 transition-all duration-300">
                    <div class="w-16 h-16 bg-purple-100 text-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-tags text-2xl"></i>
                    </div>
                    <h4 class="font-bold text-lg mb-2">Competitive Pricing</h4>
                    <p class="text-gray-600 text-sm">Enjoy the best deals on the latest technology.</p>
                </div>
            </div>
        </div>
    </section>
@endsection
