<a href="{{ route('products.index', ['category' => $category->slug]) }}"
    class="relative bg-white rounded-2xl p-6 text-center border border-gray-200 overflow-hidden group category-card-new">
    <div class="absolute inset-0 bg-gradient-to-br from-gray-500 to-indigo-600 opacity-0 group-hover:opacity-100 transition-opacity duration-300 rounded-2xl transform scale-105 category-bg-shape">
    </div>
    <div class="relative z-10 flex flex-col items-center">
        <div
            class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mb-4 transition-all duration-300 group-hover:bg-white group-hover:scale-110 group-hover:shadow-lg">
            <i
                class="{{ $category->icon }} text-4xl text-blue-600 transition-colors duration-300 group-hover:text-indigo-600"></i>
        </div>
        <h3
            class="font-bold text-lg text-gray-800 transition-colors duration-300 group-hover:text-blue-600 truncate">
            {{ $category->name }}
        </h3>
        @php
        $productCount = $category->products_count + $category->children->sum('products_count');
        @endphp
        <p class="text-gray-500 text-sm mt-1 transition-colors duration-300 group-hover:text-blue-600">
            {{ $productCount }} products
        </p>
    </div>
</a>
