@if($products->count() > 0)
    @foreach($products as $product)
        <div x-data="{
                inWishlist: {{ in_array($product->id, $wishlistProductIds ?? []) ? 'true' : 'false' }},
                inCompare: {{ in_array($product->id, session('compare', [])) ? 'true' : 'false' }},
                isAddingToCart: false,
                init() {
                    window.addEventListener('compare-updated', (event) => {
                        if (event.detail.productId == {{ $product->id }} && event.detail.status === 'removed') {
                            this.inCompare = false;
                        }
                    });
                },
                toggleWishlist(productId) {
                    // Optimistically update UI
                    this.inWishlist = !this.inWishlist;

                    fetch(`/wishlist/toggle/${productId}`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name=\'csrf-token\']').getAttribute('content'),
                            'Accept': 'application/json',
                        }
                    })
                    .then(response => {
                        if (response.status === 401) {
                            window.location.href = '{{ route('login') }}';
                            return Promise.reject('Unauthenticated');
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (data.success) {
                            // Update wishlist count in navbar
                            const wishlistCountEl = document.getElementById('wishlist-count');
                            if (wishlistCountEl) wishlistCountEl.textContent = data.wishlistCount;
                        } else {
                            // Revert on failure
                            this.inWishlist = !this.inWishlist;
                        }
                    })
                    .catch(error => { if (error !== 'Unauthenticated') this.inWishlist = !this.inWishlist; });
                },
                addToCart(productId, productName) {
                    this.isAddingToCart = true;

                    fetch(`/cart/add/${productId}`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name=\'csrf-token\']').getAttribute('content'),
                            'Accept': 'application/json',
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Dispatch a global event for the notification
                            window.dispatchEvent(new CustomEvent('show-notification', { detail: { message: `Added '${productName}' to cart!`, type: 'success' }}));

                            // Update cart count in navbar
                            const cartCountEl = document.getElementById('cart-count');
                            if (cartCountEl) cartCountEl.textContent = data.cartCount;
                        } else {
                            window.dispatchEvent(new CustomEvent('show-notification', { detail: { message: data.message || 'Could not add to cart.', type: 'error' }}));
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        window.dispatchEvent(new CustomEvent('show-notification', { detail: { message: 'An error occurred.', type: 'error' }}));
                    })
                    .finally(() => { this.isAddingToCart = false; });
                },
                addToCompare(productId) {
                    this.inCompare = true; // Optimistic update

                    fetch(`/compare/add/${productId}`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name=\'csrf-token\']').getAttribute('content'),
                            'Accept': 'application/json',
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            window.dispatchEvent(new CustomEvent('show-notification', { detail: { message: data.message, type: 'success' }}));
                            const compareCountEl = document.getElementById('compare-count');
                            if (compareCountEl) compareCountEl.textContent = data.compareCount;
                        } else {
                            this.inCompare = false; // Revert on failure
                            window.dispatchEvent(new CustomEvent('show-notification', { detail: { message: data.message, type: 'error' }}));
                        }
                    }).catch(() => { this.inCompare = false; });
                }
             }" class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-500 group border border-gray-100 product-card">
            <!-- Product Image -->
            <div class="h-52 bg-gradient-to-br from-blue-50 via-purple-50 to-pink-50 flex items-center justify-center relative overflow-hidden">
                @if($product->image)
                    <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->product_name }}"
                         class="h-full w-full object-contain p-4 group-hover:scale-110 transition-transform duration-700">
                @else
                    <div class="text-center">
                        <i class="fas fa-mobile-alt text-6xl text-gray-300 group-hover:text-blue-400 transition-colors duration-300"></i>
                        <p class="text-gray-400 text-sm mt-2">No Image</p>
                    </div>
                @endif

                <!-- Product Badges -->
                <div class="absolute top-4 left-4 flex flex-col gap-2">
                    @if($product->is_new)
                        <span class="product-badge-new">NEW</span>
                    @endif
                    @if($product->discount_price && $product->price > 0)
                        <span class="product-badge-sale">
                            SAVE {{ round((($product->price - $product->discount_price) / $product->price) * 100) }}%
                        </span>
                    @endif
                </div>

                <!-- Quick Actions -->
                <div class="absolute bottom-4 right-4 flex gap-2 lg:opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                    <button @click.prevent="toggleWishlist({{ $product->id }})"
                            class="w-8 h-8 bg-white rounded-full shadow-md flex items-center justify-center hover:bg-red-500 hover:text-white transition-colors duration-200"
                            :data-tooltip="inWishlist ? 'Remove from Wishlist' : 'Add to Wishlist'"
                            :class="{ 'text-red-500': inWishlist }">
                        <i class="fa-heart text-xs" :class="inWishlist ? 'fas' : 'far'"></i>
                    </button>
                    <button @click="$dispatch('open-quick-view', { id: {{ $product->id }} })"
                            class="w-8 h-8 bg-white rounded-full shadow-md flex items-center justify-center hover:bg-blue-500 hover:text-white transition-colors duration-200"
                            data-tooltip="Quick View" >
                        <i class="fas fa-eye text-xs"></i>
                    </button>
                    <button @click.prevent="addToCompare({{ $product->id }})"
                            class="w-8 h-8 bg-white rounded-full shadow-md flex items-center justify-center hover:bg-blue-500 hover:text-white transition-colors duration-200"
                            :data-tooltip="inCompare ? 'In Compare List' : 'Add to Compare'"
                            :class="{ 'text-blue-500': inCompare }">
                        <i class="fas fa-exchange-alt text-xs"></i>
                    </button>
                </div>
            </div>

            <!-- Product Info -->
            <div class="p-6">
                <div class="flex justify-between items-start mb-3">
                    <h3 class="font-bold text-lg text-gray-900 group-hover:text-blue-600 transition-colors duration-300 truncate flex-1 mr-3">
                        {{ $product->product_name }}
                    </h3>
                    <div class="flex-shrink-0">
                        @if($product->is_new)
                            <span class="status-badge-new">New Arrival</span>
                        @elseif($product->discount_price)
                            <span class="status-badge-sale">On Sale</span>
                        @endif
                    </div>
                </div>

                <p class="text-gray-600 text-sm mb-4 line-clamp-2 leading-relaxed">
                    {{ Str::limit($product->description, 80) }}
                </p>

                <!-- Rating and Reviews -->
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-2">
                        <div class="flex text-yellow-400">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= ($product->rating ?? 4))
                                    <i class="fas fa-star text-sm"></i>
                                @else
                                    <i class="far fa-star text-sm"></i>
                                @endif
                            @endfor
                        </div>
                        <span class="text-gray-500 text-sm">({{ $product->reviews_count ?? 0 }})</span>
                    </div>
                    <div @class([
                        'text-xs px-2 py-1 rounded',
                        'bg-green-100 text-green-800' => $product->in_stock,
                        'bg-red-100 text-red-800' => !$product->in_stock,
                    ])>
                        {{ $product->in_stock ? 'In Stock' : 'Out of Stock' }}
                    </div>
                </div>

                <!-- Price and Action -->
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center pt-4 border-t border-gray-100 gap-4">
                    <div class="flex flex-col">
                        @if($product->discount_price)
                            <span class="font-bold text-xl sm:text-2xl text-green-600">৳{{ number_format($product->discount_price) }}</span>
                            <span class="text-gray-400 line-through text-sm">৳{{ number_format($product->price) }}</span>
                        @else
                            <span class="font-bold text-2xl text-gray-900">৳{{ number_format($product->price) }}</span>
                        @endif
                    </div>
                    <button @click.prevent="addToCart({{ $product->id }}, '{{ e($product->product_name) }}')"
                            :disabled="isAddingToCart"
                            class="v-btn v-btn-primary add-to-cart-btn flex-shrink-0" type="button"
                            data-tooltip="Add to Cart">
                        <template x-if="!isAddingToCart">
                            <span><i class="fas fa-shopping-cart mr-2"></i> Add to Cart</span>
                        </template>
                        <template x-if="isAddingToCart">
                            <span><i class="fas fa-spinner fa-spin mr-2"></i> Adding...</span>
                        </template>
                    </button>
                </div>
            </div>
        </div>
    @endforeach
@else
    <div class="text-center py-16 bg-white rounded-2xl shadow-lg border border-gray-100 md:col-span-2 xl:col-span-3">
        <div class="max-w-md mx-auto">
            <div class="w-24 h-24 bg-gradient-to-br from-blue-100 to-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-search text-3xl text-blue-500"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-3">No products found</h3>
            <p class="text-gray-600 mb-8">We couldn't find any products matching your criteria. Try adjusting your filters or search terms.</p>
            <button class="v-btn v-btn-primary" id="clear-all-filters">
                <i class="fas fa-times mr-2"></i>
                Clear All Filters
            </button>
        </div>
    </div>
@endif
