@extends('frontend.layouts.app')

@section('title', 'All Products - NewTech')

@section('content')
    <!-- Page Title -->
    <div class="bg-gradient-to-r from-blue-50 to-indigo-100 py-12 px-4 border-b border-gray-200">
        <div class="container mx-auto max-w-7xl">
            <nav class="mb-4" aria-label="breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-gray-600">
                    <li><a href="{{ route('home') }}" class="hover:text-primary transition-colors duration-200">Home</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="font-semibold text-gray-800" aria-current="page">Products</li>
                </ol>
            </nav>
            <h1 class="text-4xl font-bold text-gray-900 mb-3">
                @php
                    $category = request('category');
                    if (is_array($category)) {
                        $category = $category[0];
                    }
                @endphp
                {{ $category ? Str::title(str_replace('-', ' ', $category)) : 'All Products' }}
            </h1>
            <p class="text-gray-600 text-lg">Discover our premium collection of cutting-edge devices and accessories</p>
        </div>
    </div>

    <!-- Main Content -->
    <section class="py-12 px-4 bg-gray-50">
        <div class="container mx-auto max-w-7xl">
            <div class="flex flex-col lg:flex-row gap-8" x-data="{ filtersOpen: window.innerWidth >= 1024 }" @resize.window="filtersOpen = window.innerWidth >= 1024">
                <!-- Backdrop for mobile filters -->
                <div x-show="filtersOpen && window.innerWidth < 1024" @click="filtersOpen = false" class="fixed inset-0 bg-black bg-opacity-50 z-30 lg:hidden" x-transition:enter="transition-opacity ease-linear duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity ease-linear duration-300" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" style="display: none;"></div>

                <!-- Left Side - Filter Results By Section -->
                <div
                    class="fixed lg:sticky top-0 left-0 h-full lg:h-auto lg:top-6 w-80 lg:w-1/4 bg-white rounded-r-2xl lg:rounded-2xl shadow-lg border border-gray-100 z-40 lg:z-auto transition-transform duration-300 ease-in-out"
                    :class="{ 'translate-x-0': filtersOpen, '-translate-x-full': !filtersOpen && window.innerWidth < 1024 }"
                    x-show="filtersOpen"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:leave="transition ease-in duration-300"
                    style="display: none;"
                >
                    <div class="h-full overflow-y-auto p-6">
                        <!-- Close button for mobile -->
                        <button @click="filtersOpen = false" class="absolute top-4 right-4 lg:hidden text-gray-500 hover:text-gray-800">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>

                        <!-- Filter Header -->
                        <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-200">
                            <h2 class="text-xl font-bold text-gray-900 flex items-center gap-2">
                                <i class="fas fa-filter text-primary"></i>
                                Filter Results
                            </h2>
                            <span class="bg-primary text-white text-xs font-semibold px-2 py-1 rounded-full">Active</span>
                        </div>

                        <!-- Category Filter -->
                        <div class="mb-6">
                            <h3 class="flex items-center gap-2 text-sm font-semibold text-gray-800 mb-4">
                                <i class="fas fa-layer-group text-primary w-5 h-5 flex items-center justify-center bg-primary/10 rounded-lg"></i>
                                Category
                            </h3>
                            <div class="space-y-3">
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="category" value="mobile-phones" checked>
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1">Phones</span>
                                    <span class="text-xs text-gray-500 bg-gray-100 px-2 py-1 rounded">24</span>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="category" value="smart-phones" checked>
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1">Smart Phone</span>
                                    <span class="text-xs text-gray-500 bg-gray-100 px-2 py-1 rounded">18</span>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="category" value="feature-phones">
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1">Feature Phone</span>
                                    <span class="text-xs text-gray-500 bg-gray-100 px-2 py-1 rounded">6</span>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="category" value="accessories" checked>
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1">Accessories</span>
                                    <span class="text-xs text-gray-500 bg-gray-100 px-2 py-1 rounded">12</span>
                                </label>
                            </div>
                        </div>

                        <!-- Price Range Filter -->
                        <div class="mb-6">
                            <h3 class="flex items-center gap-2 text-sm font-semibold text-gray-800 mb-4">
                                <i class="fas fa-tags text-primary w-5 h-5 flex items-center justify-center bg-primary/10 rounded-lg"></i>
                                Price Range
                            </h3>
                            <div class="price-range-slider bg-gray-50 p-4 rounded-xl">
                                <div id="price-slider"></div>
                                <div class="flex justify-between text-sm text-gray-600 mt-3">
                                    <span id="price-lower" class="bg-white px-3 py-1 rounded-lg border"></span>
                                    <span id="price-upper" class="bg-white px-3 py-1 rounded-lg border"></span>
                                </div>
                            </div>
                        </div>

                        <!-- Brand Filter -->
                        <div class="mb-6">
                            <h3 class="flex items-center gap-2 text-sm font-semibold text-gray-800 mb-4">
                                <i class="fas fa-copyright text-primary w-5 h-5 flex items-center justify-center bg-primary/10 rounded-lg"></i>
                                Brand
                            </h3>
                            <div class="space-y-3">
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="brand" value="samsung" checked>
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1 flex items-center gap-2">
                                        <span class="w-6 h-6 bg-blue-100 rounded flex items-center justify-center">
                                            <i class="fas fa-mobile text-blue-600 text-xs"></i>
                                        </span>
                                        Samsung
                                    </span>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="brand" value="apple">
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1 flex items-center gap-2">
                                        <span class="w-6 h-6 bg-gray-100 rounded flex items-center justify-center">
                                            <i class="fab fa-apple text-gray-600 text-xs"></i>
                                        </span>
                                        Apple
                                    </span>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="brand" value="xiaomi" checked>
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1 flex items-center gap-2">
                                        <span class="w-6 h-6 bg-orange-100 rounded flex items-center justify-center">
                                            <i class="fas fa-bolt text-orange-600 text-xs"></i>
                                        </span>
                                        Xiaomi
                                    </span>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="brand" value="nokia">
                                    <span class="v-checkbox-check"></span>
                                    <span class="flex-1 flex items-center gap-2">
                                        <span class="w-6 h-6 bg-blue-100 rounded flex items-center justify-center">
                                            <i class="fas fa-mobile-alt text-blue-600 text-xs"></i>
                                        </span>
                                        Nokia
                                    </span>
                                </label>
                            </div>
                        </div>

                        <!-- Rating Filter -->
                        <div class="mb-6">
                            <h3 class="flex items-center gap-2 text-sm font-semibold text-gray-800 mb-4">
                                <i class="fas fa-star text-primary w-5 h-5 flex items-center justify-center bg-primary/10 rounded-lg"></i>
                                Customer Rating
                            </h3>
                            <div class="space-y-3">
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="rating" value="5">
                                    <span class="v-checkbox-check"></span>
                                    <div class="flex items-center gap-2 text-yellow-400">
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <span class="text-gray-600 text-sm ml-1">& Up</span>
                                    </div>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="rating" value="4" checked>
                                    <span class="v-checkbox-check"></span>
                                    <div class="flex items-center gap-2 text-yellow-400">
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="far fa-star text-sm"></i>
                                        <span class="text-gray-600 text-sm ml-1">& Up</span>
                                    </div>
                                </label>
                                <label class="v-checkbox filter-option">
                                    <input type="checkbox" name="rating" value="3">
                                    <span class="v-checkbox-check"></span>
                                    <div class="flex items-center gap-2 text-yellow-400">
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="fas fa-star text-sm"></i>
                                        <i class="far fa-star text-sm"></i>
                                        <i class="far fa-star text-sm"></i>
                                        <span class="text-gray-600 text-sm ml-1">& Up</span>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <!-- Filter Actions -->
                        <div class="space-y-3 mt-8 pt-6 border-t border-gray-200">
                            <button class="v-btn v-btn-outline v-btn-block filter-action-btn" id="reset-filters">
                                <i class="fas fa-redo mr-2"></i>
                                Reset All
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Right Side - Products -->
                <div class="w-full lg:w-3/4">
                    <!-- Sort and Results Header -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 mb-8 border border-gray-100">
                        <div class="flex flex-col md:flex-row md:items-center justify-between">
                            <div class="flex items-center gap-4 mb-4 md:mb-0">
                                <!-- Mobile Filter Toggle -->
                                <button @click="filtersOpen = true" class="lg:hidden v-btn v-btn-outline">
                                    <i class="fas fa-filter mr-2"></i>
                                    Filters
                                </button>

                                <p class="text-gray-700">
                                    Showing <span class="font-bold text-gray-900">{{ $products->count() }}</span> products
                                </p>
                                <div class="hidden md:flex items-center gap-2">
                                    <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span>
                                    <span class="text-sm text-green-600">Live Results</span>
                                </div>
                            </div>
                            <div class="flex items-center space-x-6">
                                <div class="flex items-center space-x-3">
                                    <label for="sort-by" class="text-gray-600 font-medium">Sort by:</label>
                                    <select class="v-select custom-select">
                                        <option value="latest">Latest Products</option>
                                        <option value="price-low">Price: Low to High</option>
                                        <option value="price-high">Price: High to Low</option>
                                        <option value="name">Product Name</option>
                                        <option value="rating">Top Rated</option>
                                    </select>
                                </div>
                                <div class="flex items-center gap-3">
                                    <span class="text-gray-600 font-medium">View:</span>
                                    <div class="flex bg-gray-100 p-1 rounded-lg">
                                        <button class="view-toggle-btn active" id="grid-view" data-tooltip="Grid View">
                                            <i class="fas fa-th"></i>
                                        </button>
                                        <button class="view-toggle-btn" id="list-view" data-tooltip="List View">
                                            <i class="fas fa-list"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Products Grid -->
                    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-8" id="products-container">
                        @include('frontend.pages.partials.products-grid', ['products' => $products])
                    </div>

                    <!-- Pagination -->
                    <div class="mt-16" id="pagination-container">
                        {{ $products->links() }}
                    </div>
                </div>
            </div>
        </div>
    </section>

    @include('frontend.pages.partials.quick-view-modal')
@endsection

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/valo-ui@1.5.2/dist/valo.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.css" />

    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        .line-clamp-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        /* noUiSlider Customization */
        #price-slider {
            height: 6px;
            border: none;
            box-shadow: none;
        }
        .noUi-connect {
            background: linear-gradient(135deg, rgb(var(--color-primary)) 0%, rgb(var(--color-secondary)) 100%);
        }
        .noUi-handle {
            border-radius: 50%;
            background: #fff;
            border: 3px solid rgb(var(--color-primary));
            box-shadow: 0 2px 5px rgba(0,0,0,0.15);
            cursor: pointer;
            width: 20px;
            height: 20px;
            right: -10px;
            top: -7px;
        }
        .noUi-handle:focus {
            outline: none;
        }
        .noUi-handle::before, .noUi-handle::after {
            display: none;
        }
        .noUi-target {
            background: #e2e8f0;
        }
        .noUi-tooltip {
            display: none;
        }

        /* Custom Select */
        .custom-select {
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 8px 12px;
            background: white;
        }

        /* Enhanced Button Styles */
        .v-btn-primary {
            background-color: rgb(var(--color-primary)) !important;
            border: none;
            border-radius: 12px;
            font-weight: 600;
            color: white;
            transition: all 0.3s ease;
        }

        .v-btn-primary:hover {
            background-color: rgb(var(--color-primary) / 0.9) !important;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }

        .filter-action-btn {
            border-radius: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .add-to-cart-btn {
            border-radius: 10px;
            padding: 8px 16px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        /* Badge Styles */
        .product-badge-new {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.7rem;
            font-weight: 700;
            background: linear-gradient(135deg, #48bb78, #38a169);
            color: white;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 12px rgba(72, 187, 120, 0.3);
        }

        .product-badge-sale {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.7rem;
            font-weight: 700;
            background: linear-gradient(135deg, #ed8936, #dd6b20);
            color: white;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 12px rgba(237, 137, 54, 0.3);
        }

        .status-badge-new {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 8px;
            font-size: 0.65rem;
            font-weight: 600;
            background: rgba(72, 187, 120, 0.1);
            color: #48bb78;
            border: 1px solid rgba(72, 187, 120, 0.2);
        }

        .status-badge-sale {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 8px;
            font-size: 0.65rem;
            font-weight: 600;
            background: rgba(237, 137, 54, 0.1);
            color: #ed8936;
            border: 1px solid rgba(237, 137, 54, 0.2);
        }

        /* Filter Options */
        .filter-option {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            border-radius: 10px;
            transition: all 0.3s ease;
            border: 1px solid transparent;
        }

        .filter-option:hover {
            background: rgba(102, 126, 234, 0.05);
            border-color: rgba(102, 126, 234, 0.2);
        }

        /* View Toggle */
        .view-toggle-btn {
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .view-toggle-btn.active {
            background: linear-gradient(135deg, rgb(var(--color-primary)) 0%, rgb(var(--color-secondary)) 100%);
            color: white;
        }

        /* Product Card Animations */
        .product-card {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .product-card:hover {
            transform: translateY(-8px);
        }

        /* Tooltip */
        [data-tooltip] {
            position: relative;
        }

        [data-tooltip]:before {
            content: attr(data-tooltip);
            position: absolute;
            bottom: 100%;
            left: 50%;
            transform: translateX(-50%);
            background: #2d3748;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 0.75rem;
            white-space: nowrap;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        [data-tooltip]:hover:before {
            opacity: 1;
            visibility: visible;
            bottom: calc(100% + 5px);
        }

        /* Sticky Sidebar */
        .sticky {
            position: sticky;
        }

        /* List View Styles */
        .product-list {
            display: flex;
            flex-direction: column;
            gap: 24px; /* Increased gap */
        }

        .product-list .product-card {
            display: flex;
            flex-direction: row;
            align-items: center; /* Vertically align items */
            height: auto; /* Auto height */
        }

        .product-list .product-card > div:first-child {
            width: 240px; /* Increased image width */
            flex-shrink: 0;
            height: 200px; /* Fixed height for image container */
        }

        .product-list .product-card .p-6 {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center; /* Center content vertically */
            padding: 1rem 1.5rem; /* Adjust padding */
        }

        .product-list .product-card .line-clamp-2 {
            -webkit-line-clamp: 3; /* Allow more lines for description */
        }

        .product-list .product-card .add-to-cart-btn {
            white-space: nowrap; /* Prevent button text from wrapping */
        }

        @media (max-width: 768px) {
            .product-list .product-card {
                flex-direction: column;
                height: auto;
            }

            .product-list .product-card > div:first-child {
                width: 100%;
                height: 200px; /* Maintain aspect ratio on mobile */
            }
        }

        /* Notification Animations */
        @keyframes slideInRight {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        @keyframes slideOutRight {
            from { transform: translateX(0); opacity: 1; }
            to { transform: translateX(100%); opacity: 0; }
        }

        @keyframes toast-in {
            from { transform: translateX(110%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        @keyframes toast-out {
            from { transform: translateX(0); opacity: 1; }
            to { transform: translateX(110%); opacity: 0; }
        }

        @keyframes progress {
            from { width: 100%; }
            to { width: 0%; }
        }

        @keyframes pulse {
            50% { transform: scale(1.02); }
        }

        /* Responsive Improvements */
        @media (max-width: 1024px) {
            .container {
                padding: 0 16px;
            }

            .product-grid {
                gap: 16px;
            }
        }

        @media (max-width: 768px) {
            .header-section {
                padding: 20px 0;
            }

            .filter-section {
                position: static;
                margin-bottom: 24px;
            }

            .lg\:sticky {
                position: static;
            }
            .lg\:w-1\/4 {
                width: 100%;
            }
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/valo-ui@1.5.2/dist/valo.min.js"></script>
    <script>
        const MAX_PRICE = {{ $maxPrice ?? 50000 }};

        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Valo UI components
            if (typeof Valo !== 'undefined') {
                Valo.init();
            }

            // Add to Cart functionality
            document.body.addEventListener('click', function(event) {
                const button = event.target.closest('.add-to-cart');
                if (!button) return;

                const productId = button.getAttribute('data-product-id');
                const productCard = button.closest('.product-card, .bg-white');
                const productName = productCard.querySelector('h2, h3').textContent.trim();

                // Show loading state
                const originalText = button.innerHTML;
                button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Adding...';
                button.disabled = true;

                // Add pulse animation to product card
                if (productCard) {
                    productCard.style.animation = 'pulse 0.5s ease-in-out';
                }

                fetch(`/cart/add/${productId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showNotification(`"${productName}" added to cart!`, 'success');
                        // Update cart count in the navbar
                        const cartCountEl = document.getElementById('cart-count');
                        if (cartCountEl) {
                            cartCountEl.textContent = data.cartCount;
                        }
                    } else {
                        showNotification(data.message || 'Could not add to cart.', 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showNotification('An error occurred.', 'error');
                })
                .finally(() => {
                    // Reset button and animation
                    button.innerHTML = originalText;
                    button.disabled = false;
                    if (productCard) {
                        productCard.style.animation = '';
                    }
                });
            });

            // Wishlist functionality (using event delegation)
            document.body.addEventListener('click', function(event) {
                const button = event.target.closest('.add-to-wishlist');
                if (!button) return;

                const productId = button.dataset.productId;
                const icon = button.querySelector('i');

                fetch(`/wishlist/toggle/${productId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => {
                    if (response.status === 401) {
                        window.location.href = '{{ route('login') }}';
                        return;
                    }
                    return response.json();
                })
                .then(data => {
                    if (data && data.success) {
                        showNotification(data.message, 'success');
                        if (data.status === 'added') {
                            icon.classList.add('text-red-500');
                        } else {
                            icon.classList.remove('text-red-500');
                        }
                    }
                }).catch(error => {
                    console.error('Wishlist error:', error);
                    showNotification('Please log in to use the wishlist.', 'error');
                });
            });

            // Sort functionality
            const sortSelect = document.querySelector('.custom-select');
            if (sortSelect) {
                sortSelect.addEventListener('change', function() {
                    applyFilters();
                });
            }

            // View toggle functionality
            const gridViewBtn = document.getElementById('grid-view');
            const listViewBtn = document.getElementById('list-view');
            const productsContainer = document.getElementById('products-container');

            if (gridViewBtn && listViewBtn) {
                gridViewBtn.addEventListener('click', function() {
                    productsContainer.className = 'grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-8';
                    gridViewBtn.classList.add('active');
                    listViewBtn.classList.remove('active');
                    showNotification('Switched to Grid View', 'info');
                });

                listViewBtn.addEventListener('click', function() {
                    productsContainer.className = 'product-list';
                    listViewBtn.classList.add('active');
                    gridViewBtn.classList.remove('active');
                    showNotification('Switched to List View', 'info');
                });
            }

            // Enhanced Notification function
            function showNotification(message, type = 'info') {
                // Remove any existing notifications
                document.querySelectorAll('.toast-notification').forEach(n => n.remove());

                const notification = document.createElement('div');
                notification.className = 'toast-notification fixed top-5 right-5 w-full max-w-sm bg-white shadow-2xl rounded-xl p-4 border-l-4 z-[1000]';

                const icons = {
                    success: 'fa-check-circle',
                    error: 'fa-exclamation-circle',
                    info: 'fa-info-circle'
                };
                const borderColors = {
                    success: 'border-green-500',
                    error: 'border-red-500',
                    info: 'border-blue-500'
                };
                const textColors = {
                    success: 'text-green-500',
                    error: 'text-red-500',
                    info: 'text-blue-500'
                };

                notification.classList.add(borderColors[type] || borderColors.info);

                notification.innerHTML = `
                    <div class="flex items-start gap-4">
                        <i class="fas ${icons[type] || icons.info} ${textColors[type] || textColors.info} text-2xl mt-1"></i>
                        <div class="flex-1">
                            <p class="font-bold text-gray-800">${type.charAt(0).toUpperCase() + type.slice(1)}</p>
                            <p class="text-sm text-gray-600">${message}</p>
                        </div>
                        <button class="v-alert-close text-gray-400 hover:text-gray-600">&times;</button>
                    </div>
                    <div class="absolute bottom-0 left-0 h-1 bg-gray-200 rounded-bl-lg">
                        <div class="h-1 ${borderColors[type] ? borderColors[type].replace('border', 'bg') : 'bg-blue-500'} rounded-bl-lg" style="width: 100%; animation: progress 4s linear forwards;"></div>
                    </div>
                `;

                document.body.appendChild(notification);
                notification.style.animation = 'toast-in 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards';

                const close = () => {
                    notification.style.animation = 'toast-out 0.5s ease-in forwards';
                    notification.addEventListener('animationend', () => notification.remove(), { once: true });
                };

                // Auto remove after 4 seconds
                const timer = setTimeout(close, 4000);

                // Close button
                notification.querySelector('.v-alert-close').addEventListener('click', () => {
                    clearTimeout(timer);
                    close();
                });
            }

            // --- Auto-filtering logic ---
            const filterInputs = document.querySelectorAll('input[name="category"], input[name="brand"], input[name="rating"]');

            function applyFilters() {
                const productsContainer = document.getElementById('products-container');
                const paginationContainer = document.getElementById('pagination-container');

                // Show loading state
                productsContainer.style.opacity = '0.5';

                const params = new URLSearchParams();

                // Categories
                document.querySelectorAll('input[name="category"]:checked').forEach(el => params.append('category[]', el.value));
                // Brands
                document.querySelectorAll('input[name="brand"]:checked').forEach(el => params.append('brands[]', el.value));
                // Ratings
                document.querySelectorAll('input[name="rating"]:checked').forEach(el => params.append('ratings[]', el.value));
                // Price
                if (priceSlider.noUiSlider) {
                    const values = priceSlider.noUiSlider.get();
                    params.append('price_min', Math.round(values[0]));
                    params.append('price_max', Math.round(values[1]));
                }
                // Sort
                params.append('sort', document.querySelector('.custom-select').value);

                // Search term
                const searchParams = new URLSearchParams(window.location.search);
                if (searchParams.has('search')) {
                    params.append('search', searchParams.get('search'));
                }
                const url = `{{ route('products.index') }}?${params.toString()}`;

                // Update URL without reloading
                history.pushState(null, '', url);

                fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                    },
                })
                .then(response => response.json())
                .then(data => {
                    productsContainer.innerHTML = data.products_html;
                    paginationContainer.innerHTML = data.pagination_html;
                    // Re-attach event listeners to the new pagination links
                    paginationContainer.querySelectorAll('a.page-link').forEach(link => {
                        link.addEventListener('click', function(e) {
                            e.preventDefault();
                            fetchPage(this.href);
                        });
                    });
                })
                .catch(error => {
                    console.error('Error fetching filtered products:', error);
                    showNotification('Failed to apply filters.', 'error');
                })
                .finally(() => {
                    productsContainer.style.opacity = '1';
                });
            }

            function fetchPage(url) {
                const productsContainer = document.getElementById('products-container');
                const paginationContainer = document.getElementById('pagination-container');
                productsContainer.style.opacity = '0.5';

                fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                    },
                })
                .then(response => response.json())
                .then(data => {
                    productsContainer.innerHTML = data.products_html;
                    paginationContainer.innerHTML = data.pagination_html;
                    // Re-attach event listeners to the new pagination links
                    paginationContainer.querySelectorAll('a.page-link').forEach(link => {
                        link.addEventListener('click', function(e) {
                            e.preventDefault();
                            fetchPage(this.href);
                        });
                    });
                    // Scroll to top of products container
                    productsContainer.scrollIntoView({ behavior: 'smooth' });
                })
                .catch(error => {
                    console.error('Error fetching page:', error);
                    showNotification('Failed to load page.', 'error');
                })
                .finally(() => {
                    productsContainer.style.opacity = '1';
                });
            }

            // Use a debounce function to avoid firing too many requests
            const debouncedApplyFilters = debounce(applyFilters, 500);

            filterInputs.forEach(input => {
                input.addEventListener('change', debouncedApplyFilters);
            });

            // Price Slider Initialization
            const priceSlider = document.getElementById('price-slider');
            const priceLower = document.getElementById('price-lower');
            const priceUpper = document.getElementById('price-upper');

            if (priceSlider) {
                noUiSlider.create(priceSlider, {
                    start: [0, MAX_PRICE],
                    connect: true,
                    range: {
                        'min': 0,
                        'max': Math.ceil(MAX_PRICE)
                    },
                    format: {
                        to: function (value) {
                            return value;
                        },
                        from: function (value) {
                            return Number(value);
                        }
                    }
                });

                priceSlider.noUiSlider.on('update', function (values) {
                    priceLower.innerHTML = `৳${Math.round(values[0])}`;
                    priceUpper.innerHTML = `৳${Math.round(values[1])}`;
                });

                priceSlider.noUiSlider.on('change', debouncedApplyFilters);
            }

            function debounce(func, delay) {
                let timeout;
                return function(...args) {
                    const context = this;
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(context, args), delay);
                };
            }

            // Reset Filters functionality
            const resetFiltersBtn = document.getElementById('reset-filters');
            if (resetFiltersBtn) {
                resetFiltersBtn.addEventListener('click', function() {
                    window.location.href = '{{ route('products.index') }}';
                });
            }

            // Initial pagination listener
            const paginationContainer = document.getElementById('pagination-container');
            if (paginationContainer) {
                paginationContainer.addEventListener('click', function(e) {
                    if (e.target.tagName === 'A' && e.target.classList.contains('page-link')) {
                        e.preventDefault();
                        fetchPage(e.target.href);
                    }
                });
            }
        });
    </script>
@endpush
