@extends('frontend.layouts.app')

@section('title', 'Track Your Order - ' . config('app.name', 'NewTech Mobile'))

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="bg-white p-8 rounded-lg shadow-lg max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold mb-6 text-gray-800 border-b pb-4">Track Your Order</h1>

        <p class="text-gray-600 mb-6">
            To track your order, please enter your Order ID in the box below and press the "Track" button. You would have received this ID in your order confirmation email.
        </p>

        <form action="#" method="GET">
            <div class="flex flex-col sm:flex-row items-end gap-4">
                <div class="w-full">
                    <label for="order_id" class="block text-sm font-medium text-gray-700 mb-1">Order ID</label>
                    <input type="text" name="order_id" id="order_id" placeholder="e.g., NT-12345" class="w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <button type="submit" class="w-full sm:w-auto bg-primary hover:bg-blue-700 text-white font-bold py-2 px-6 rounded-md transition duration-300">Track</button>
            </div>
        </form>
    </div>
</div>
@endsection
