<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', config('app.name'))</title>

    <!-- Fonts & Icons -->
    {{-- Font Awesome is loaded here for all backend pages --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        .sidebar-transition {
            transition: transform 0.3s ease-in-out;
        }

        .sidebar-shadow {
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }

        .active-menu-item {
            background-color: #e5e7eb;
            font-weight: 600;
            color: #111827;
        }

        .menu-item {
            transition: all 0.2s ease-in-out;
        }

        .menu-item:hover {
            background-color: #f3f4f6;
            transform: translateX(2px);
        }

        .user-avatar {
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
        }
    </style>
</head>

<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100">
        @include('layouts.navigation', ['slot' => $slot ?? ''])
        @stack('styles')
    </div>
    @stack('scripts')

</body>

</html>
