<x-app-layout>
    @section('header', 'Dashboard')
    @section('subheader', 'Welcome to your dashboard')

    <!-- Welcome Message -->
    <div class="bg-gradient-to-r from-blue-500 to-purple-600 overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-2xl font-bold mb-2">Welcome back, {{ Auth::user()->name }}! 👋</h3>
                    <p class="opacity-90">Here's a quick overview of the system.</p>
                    @if(Auth::user()->last_login_at)
                    <div class="mt-2 text-sm">
                        <span class="bg-blue-400 bg-opacity-30 px-2 py-1 rounded">Last login: {{ Auth::user()->last_login_at->format('M j, Y g:i A') }}</span>
                    </div>
                    @endif
                </div>
                <div class="hidden md:block">
                    <i class="fas fa-chart-line text-4xl opacity-20"></i>
                </div>
            </div>
        </div>
    </div>

    @if(auth()->user()->isAdmin())
        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
                <div class="p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4">
                            <i class="fas fa-box text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-600">Total Products</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $totalProducts ?? '0' }}</p>
                        </div>
                    </div>
                    <div class="mt-2 text-xs text-green-600">
                        <i class="fas fa-database"></i> In system
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
                <div class="p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-purple-100 text-purple-600 mr-4">
                            <i class="fas fa-users text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-600">Total Users</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $totalUsers ?? '0' }}</p>
                        </div>
                    </div>
                    <div class="mt-2 text-xs text-blue-600">
                        <i class="fas fa-user-check"></i> Registered
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
                <div class="p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4">
                            <i class="fas fa-barcode text-sm"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-600">Today's Scans</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $todayScans ?? '0' }}</p>
                        </div>
                    </div>
                    <div class="mt-2 text-xs text-green-600">
                        <i class="fas fa-sync-alt"></i> Scanned today
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
                <div class="p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4">
                            <i class="fas fa-chart-bar text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-600">This Week</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $weeklyScans ?? '0' }}</p>
                        </div>
                    </div>
                    <div class="mt-2 text-xs text-purple-600">
                        <i class="fas fa-calendar-week"></i> This week's activity
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Area -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
            <!-- Quick Actions -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-6">Quick Actions</h3>

                    <div class="grid grid-cols-2 gap-4">
                        <a href="{{ route('scanner.index') }}" class="bg-blue-50 hover:bg-blue-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-blue-200">
                            <i class="fas fa-barcode text-blue-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                            <p class="font-medium text-gray-900">Scan Item</p>
                            <p class="text-xs text-gray-500 mt-1">Quick inventory check</p>
                        </a>

                        <a href="{{ route('products') }}" class="bg-green-50 hover:bg-green-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-green-200">
                            <i class="fas fa-list-alt text-green-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                            <p class="font-medium text-gray-900">View Products</p>
                            <p class="text-xs text-gray-500 mt-1">Browse inventory</p>
                        </a>

                        <a href="{{ route('verify') }}" class="bg-purple-50 hover:bg-purple-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-purple-200">
                            <i class="fas fa-shield-alt text-purple-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                            <p class="font-medium text-gray-900">Verify Product</p>
                            <p class="text-xs text-gray-500 mt-1">Check authenticity</p>
                        </a>

                        <a href="{{ route('profile.edit') }}" class="bg-yellow-50 hover:bg-yellow-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-yellow-200">
                            <i class="fas fa-cog text-yellow-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                            <p class="font-medium text-gray-900">Settings</p>
                            <p class="text-xs text-gray-500 mt-1">Profile settings</p>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Activity</h3>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="p-2 rounded-full bg-blue-100 text-blue-600 mr-3">
                                <i class="fas fa-barcode text-sm"></i>
                            </div>
                            <div>
                                <p class="font-medium">Barcode Scanner</p>
                                <p class="text-sm text-gray-500">Quick product lookup and verification</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="p-2 rounded-full bg-green-100 text-green-600 mr-3">
                                <i class="fas fa-box text-sm"></i>
                            </div>
                            <div>
                                <p class="font-medium">Product Management</p>
                                <p class="text-sm text-gray-500">View and manage all products</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="p-2 rounded-full bg-purple-100 text-purple-600 mr-3">
                                <i class="fas fa-shield-alt text-sm"></i>
                            </div>
                            <div>
                                <p class="font-medium">Product Verification</p>
                                <p class="text-sm text-gray-500">Check product authenticity</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="p-2 rounded-full bg-yellow-100 text-yellow-600 mr-3">
                                <i class="fas fa-print text-sm"></i>
                            </div>
                            <div>
                                <p class="font-medium">Sticker Printing</p>
                                <p class="text-sm text-gray-500">Generate product stickers</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</x-app-layout>
