<?php

use App\Http\Controllers\FakeDataController;
use App\Http\Controllers\ScannerController;
use Illuminate\Support\Facades\Route;

Route::prefix('scanner')->group(function () {
    Route::post('/scan', [ScannerController::class, 'scan']);
    Route::post('/bulk-scan', [ScannerController::class, 'bulkScan']);
    Route::get('/recent', [ScannerController::class, 'recentScans']);
    Route::post('/simulate', [ScannerController::class, 'simulateScan']);
});

Route::post('/generate-fake-products', [FakeDataController::class, 'generateFakeProducts']);
