<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-A-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Report - <?php echo e($product->serial_no); ?></title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 12px;
            color: #333;
        }
        .container {
            width: 100%;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #000;
        }
        .header p {
            margin: 5px 0 0;
            font-size: 14px;
        }
        .content {
            margin-top: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            width: 30%;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 10px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Product Authenticity Report</h1>
            <p>Generated on: <?php echo e(date('d-m-Y H:i:s')); ?></p>
        </div>

        <div class="content">
            <table>
                <tr><th>Serial No</th><td><?php echo e($product->serial_no); ?></td></tr>
                <tr><th>Product Name</th><td><?php echo e($product->product_name); ?></td></tr>
                <tr><th>IMEI</th><td><?php echo e($product->imei ?? 'N/A'); ?></td></tr>
                <tr><th>Condition</th><td><?php echo e($product->condition); ?></td></tr>
                <tr><th>Status</th><td><?php echo e($product->status); ?></td></tr>
                <tr><th>Quality</th><td><?php echo e($product->quality); ?></td></tr>
                <tr><th>Color</th><td><?php echo e($product->color); ?></td></tr>
                <tr><th>Distributor</th><td><?php echo e($product->distributor_name); ?></td></tr>
                <tr><th>Retailer</th><td><?php echo e($product->retailer_name ?? 'Not Available'); ?></td></tr>
                <tr><th>Client</th><td><?php echo e($product->client_name ?? 'Not Available'); ?></td></tr>
            </table>
        </div>

        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Product Authentication System. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\products\report.blade.php ENDPATH**/ ?>