<div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
    <form method="GET" action="<?php echo e(route('products')); ?>" class="flex flex-col md:flex-row gap-4">
        <div class="relative flex-grow">
            <input type="text" name="search" value="<?php echo e($search); ?>" placeholder="Search by serial, IMEI, name..." 
                   class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
        </div>
        <div class="flex flex-col sm:flex-row gap-2">
            <select name="quality" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Qualities</option>
                <option value="Authentic" <?php echo e($quality == 'Authentic' ? 'selected' : ''); ?>>Authentic</option>
                <option value="Premium" <?php echo e($quality == 'Premium' ? 'selected' : ''); ?>>Premium</option>
                <option value="Standard" <?php echo e($quality == 'Standard' ? 'selected' : ''); ?>>Standard</option>
            </select>
            <select name="color" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Colors</option>
                <option value="Blue Ae" <?php echo e($color == 'Blue Ae' ? 'selected' : ''); ?>>Blue Ae</option>
                <option value="White" <?php echo e($color == 'White' ? 'selected' : ''); ?>>White</option>
                <option value="Black" <?php echo e($color == 'Black' ? 'selected' : ''); ?>>Black</option>
            </select>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <i class="fas fa-filter mr-2"></i>Filter
            </button>
            <a href="<?php echo e(route('products')); ?>" class="px-6 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition-colors flex items-center">
                <i class="fas fa-refresh mr-2"></i>Reset
            </a>
        </div>
    </form>
</div><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\products\partials\search-form.blade.php ENDPATH**/ ?>