<?php $__env->startSection('title', 'Edit Product'); ?>
<?php $__env->startSection('header', 'Edit Product Details'); ?>
<?php $__env->startSection('subheader', 'Update the details for an existing product.'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-4xl mx-auto bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-gradient-to-r from-primary to-purple-600 px-4 sm:px-6 py-4">
            <h1 class="text-2xl font-bold text-white flex items-center"><i class="fas fa-pencil-alt mr-3"></i>Edit Product</h1>
            <p class="text-indigo-100 mt-1">Update details for: <?php echo e($product->product_name); ?> (<?php echo e($product->serial_no); ?>)</p>
        </div>

        <form action="<?php echo e(route('admin.products.update', $product->id)); ?>" method="POST" enctype="multipart/form-data" class="p-4 sm:p-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <?php if($errors->any()): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
                    <p class="font-bold">Please correct the errors below:</p>
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6" x-data="{
                selectedColors: <?php echo e(json_encode(old('color', $product->color ?? []))); ?>,
                availableColors: ['Black', 'White', 'Silver', 'Gray', 'Red', 'Blue', 'Green', 'Gold', 'Cyan', 'Pink', 'Other'],
                toggleColor(color) { this.selectedColors.includes(color) ? this.selectedColors = this.selectedColors.filter(c => c !== color) : this.selectedColors.push(color) }
            }">
                <!-- Product Name -->
                <div>
                    <label for="product_name" class="block text-sm font-medium text-gray-700">Product Name</label>
                    <input type="text" name="product_name" id="product_name" value="<?php echo e(old('product_name', $product->product_name)); ?>" list="product_names_list" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                    <datalist id="product_names_list">
                        
                        <?php $__currentLoopData = $productNames ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($name); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                </div>

                <!-- Serial No -->
                <div>
                    <label for="serial_no" class="block text-sm font-medium text-gray-700">Serial No</label>
                    <input type="text" name="serial_no" id="serial_no" value="<?php echo e(old('serial_no', $product->serial_no)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary bg-gray-100" readonly>
                </div>

                <!-- IMEI -->
                <div>
                    <label for="imei" class="block text-sm font-medium text-gray-700">IMEI</label>
                    <input type="text" name="imei" id="imei" value="<?php echo e(old('imei', $product->imei)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                </div>

                <!-- Status -->
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" id="status" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                        <option value="In Warehouse" <?php echo e(old('status', $product->status) == 'In Warehouse' ? 'selected' : ''); ?>>In Warehouse</option>
                        <option value="Shipped" <?php echo e(old('status', $product->status) == 'Shipped' ? 'selected' : ''); ?>>Shipped</option>
                        <option value="Delivered" <?php echo e(old('status', $product->status) == 'Delivered' ? 'selected' : ''); ?>>Delivered</option>
                        <option value="Sold" <?php echo e(old('status', $product->status) == 'Sold' ? 'selected' : ''); ?>>Sold</option>
                        <option value="Returned" <?php echo e(old('status', $product->status) == 'Returned' ? 'selected' : ''); ?>>Returned</option>
                    </select>
                </div>

                <!-- Condition -->
                <div>
                    <label for="condition" class="block text-sm font-medium text-gray-700">Condition</label>
                    <select name="condition" id="condition" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                        <option value="New" <?php echo e(old('condition', $product->condition) == 'New' ? 'selected' : ''); ?>>New</option>
                        <option value="Used" <?php echo e(old('condition', $product->condition) == 'Used' ? 'selected' : ''); ?>>Used</option>
                        <option value="Refurbished" <?php echo e(old('condition', $product->condition) == 'Refurbished' ? 'selected' : ''); ?>>Refurbished</option>
                    </select>
                </div>

                <!-- Quality -->
                <div>
                    <label for="quality" class="block text-sm font-medium text-gray-700">Quality</label>
                    <select name="quality" id="quality" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                        <option value="Authentic" <?php echo e(old('quality', $product->quality) == 'Authentic' ? 'selected' : ''); ?>>Authentic</option>
                        <option value="Premium" <?php echo e(old('quality', $product->quality) == 'Premium' ? 'selected' : ''); ?>>Premium</option>
                        <option value="Standard" <?php echo e(old('quality', $product->quality) == 'Standard' ? 'selected' : ''); ?>>Standard</option>
                    </select>
                </div>

                <!-- Color -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Colors</label>
                    <div class="mt-2 flex flex-wrap gap-2">
                        <template x-for="color in availableColors" :key="color">
                            <button
                                type="button"
                                @click="toggleColor(color)"
                                :class="selectedColors.includes(color) ? 'bg-primary text-white border-primary' : 'bg-white text-gray-700 border-gray-300 hover:bg-gray-50'"
                                class="px-3 py-1 border rounded-full text-sm font-medium transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary"
                                x-text="color">
                            </button>
                        </template>
                    </div>
                    <!-- Hidden inputs to submit selected colors -->
                    <template x-for="color in selectedColors" :key="color"><input type="hidden" name="color[]" :value="color"></template>
                </div>

                <!-- Distributor Name -->
                <div>
                    <label for="distributor_name" class="block text-sm font-medium text-gray-700">Distributor Name</label>
                    <input type="text" name="distributor_name" id="distributor_name" value="<?php echo e(old('distributor_name', $product->distributor_name)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                </div>

                <!-- Retailer Name -->
                <div>
                    <label for="retailer_name" class="block text-sm font-medium text-gray-700">Retailer Name</label>
                    <input type="text" name="retailer_name" id="retailer_name" value="<?php echo e(old('retailer_name', $product->retailer_name)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary">
                </div>

                <!-- Product Description -->
                <div class="md:col-span-2">
                    <label for="description" class="block text-sm font-medium text-gray-700">Product Description</label>
                    <textarea name="description" id="description" rows="3" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary focus:border-primary"><?php echo e(old('description', $product->description)); ?></textarea>
                </div>

            </div>

            <div class="mt-8 flex flex-col-reverse sm:flex-row sm:justify-end sm:space-x-4 space-y-4 space-y-reverse sm:space-y-0">
                <a href="<?php echo e(url()->previous(route('admin.products'))); ?>" class="w-full sm:w-auto justify-center text-center bg-secondary text-white px-6 py-2 rounded-lg hover:bg-opacity-90 transition-colors">
                    Cancel
                </a>
                <button type="submit" class="w-full sm:w-auto justify-center bg-primary text-white px-6 py-2 rounded-lg hover:bg-opacity-90 transition-colors flex items-center">
                    <i class="fas fa-save mr-2"></i>Update Product
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\products\edit.blade.php ENDPATH**/ ?>