    

    <?php $__env->startSection('content'); ?>
        <div class="container mx-auto px-4 py-8">
            <!-- Print Controls -->
            <div class="print-controls bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="flex justify-between items-center">
                    <h1 class="text-2xl font-bold text-gray-800">Authenticity Sticker Printing</h1>
                    <button onclick="window.print()"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg flex items-center">
                        <i class="fas fa-print mr-2"></i> Print Stickers
                    </button>
                </div>

                <!-- Print Settings Form -->
                <form method="GET" action="<?php echo e(route('sticker.print')); ?>" class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Starting Serial Number</label>
                        <input type="text" name="serial_no" value="<?php echo e($serialNo); ?>" placeholder="e.g., INT-2301-200601"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Number of Stickers</label>
                        <input type="number" name="quantity" value="<?php echo e($quantity); ?>" placeholder="e.g., 5" min="1"
                            max="160"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div class="flex items-end">
                        <button type="submit"
                            class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg w-full">
                            Generate Stickers
                        </button>
                    </div>
                </form>
            </div>

            <!-- Sticker Printing Area -->
            <div class="print-area flex items-center justify-center">
                <?php $__currentLoopData = $products->chunk(40); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pageProducts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="page break-after-page">
                        <div class="grid grid-cols-5 grid-rows-8 gap-1 p-1 h-[297mm] w-[210mm] mx-auto bg-white">
                            <?php $__currentLoopData = $pageProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $qrData = urlencode(route('verify', ['serial_no' => $product->serial_no]));
                                    $barcodeValue = $product->barcode ?? $product->serial_no;
                                    $barcodeURL = route('barcode.generate', ['text' => $barcodeValue]);
                                    $qrURL = 'https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=' . $qrData;
                                ?>

                                <div class="sticker-wrapper flex rounded">
                                    <div class="sticker flex-1 flex flex-col items-center justify-between p-1 text-center">
                                        <div class="title font-bold text-xs">HIGH AR:M</div>
                                        <div class="brand font-bold text-[7px] text-green-600"><?php echo e($product->product_name); ?></div>
                                        <img src="<?php echo e($qrURL); ?>" alt="QR Code" class="w-16 h-16 mx-auto">
                                        <div class="scan-note text-[5px] text-gray-600">Scan to Verify Authenticity</div>
                                        <div class="serial text-[6px] text-red-600 font-bold border-t border-gray-300 pt-1 w-full">
                                            Serial: <?php echo e($product->serial_no); ?>

                                        </div>
                                    </div>
                                    <div class="barcode-wrapper w-4 flex items-center justify-center overflow-hidden">
                                        <img src="<?php echo e($barcodeURL); ?>" alt="Barcode" class="barcode-image">
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <style>
            /* Print-specific styles */
            @media print {
                /* Hide everything in the body by default */
                body * {
                    visibility: hidden;
                }

                /* Make the print-area and its children visible */
                .print-area, .print-area * {
                    visibility: visible;
                }

                /* Position the print-area at the top-left corner of the page */
                .print-area {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                }

                .print-controls, .v-footer, .v-navigation-drawer, .v-app-bar {
                    display: none;
                }
                body {
                    margin: 0;
                }
                @page {
                    size: A4;
                    margin: 0;
                }
                .page {
                    margin: 0;
                    page-break-after: always;
                    box-shadow: none; /* Remove shadow in print view */
                }
            }

            .page {
                width: 210mm;
                height: 297mm;
                display: grid;
                gap: 0.8mm;
                padding: 1mm;
                box-sizing: border-box;
                /* The grid definition is already on the child div, so it's not needed here */
                /* Or if you want it here, remove it from the child */
            }

            .sticker-wrapper {
                display: flex;
                align-items: stretch;
                justify-content: stretch;
                width: 100%;
                height: 100%;
            }

            .sticker {
                flex: 1;
                border: 2px solid #000;
                text-align: center;
                box-sizing: border-box;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                align-items: center;
                padding-top: 5px;
                padding-bottom: 3px;
                background: #fff;
            }

            .barcode-wrapper {
                width: 12px;
                margin-left: 1px;
                display: flex;
                align-items: center;
                justify-content: center;
                overflow: hidden;
                position: relative; /* Add this to establish positioning context */
            }

            .barcode-image {
                /* SVG rotation is better handled by swapping width/height and rotating */
                height: 100%; /* The SVG's height will determine the barcode's width after rotation */
                width: 100%; /* The SVG's width will determine the barcode's height after rotation */
                transform: rotate(270deg);
                transform-origin: center;
                object-fit: contain; /* Use contain to maintain aspect ratio */
                display: block;
            }
        </style>
    <?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\products\sticker-print.blade.php ENDPATH**/ ?>