<?php $__env->startSection('title', 'Products List'); ?>
<?php $__env->startSection('header', 'Manage Products'); ?>
<?php $__env->startSection('subheader', 'View, search, and manage all products in the system.'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-gradient-to-r from-primary to-purple-700 px-6 py-4">
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                <div>
                    <h1 class="text-2xl font-bold text-white flex items-center"><i class="fas fa-boxes-stacked mr-3"></i>Stock Management</h1>
                    <p class="text-blue-100 mt-1">Track and manage your product inventory</p>
                </div>
                <div class="mt-4 md:mt-0">
                    <a href="<?php echo e(route('admin.scanner.index')); ?>" class="inline-block px-5 py-2 bg-white text-primary rounded-lg font-semibold hover:bg-gray-100 transition-colors">
                        <i class="fas fa-qrcode mr-2"></i>Scan with Create New Product
                    </a>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <?php if(isset($stats)): ?>
        <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
            <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-6 gap-4">
                <div class="bg-white rounded-lg shadow p-4 text-center">
                    <p class="text-sm font-medium text-gray-500">Total Products</p>
                    <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['total_products'] ?? 'N/A'); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-4 text-center">
                    <p class="text-sm font-medium text-gray-500">In Warehouse</p>
                    <p class="text-2xl font-bold text-indigo-600"><?php echo e($stats['in_warehouse'] ?? 'N/A'); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-4 text-center">
                    <p class="text-sm font-medium text-gray-500">Shipped</p>
                    <p class="text-2xl font-bold text-yellow-600"><?php echo e($stats['shipped'] ?? 'N/A'); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-4 text-center">
                    <p class="text-sm font-medium text-gray-500">Delivered</p>
                    <p class="text-2xl font-bold text-green-600"><?php echo e($stats['delivered'] ?? 'N/A'); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-4 text-center">
                    <p class="text-sm font-medium text-gray-500">Sold</p>
                    <p class="text-2xl font-bold text-purple-600"><?php echo e($stats['sold'] ?? 'N/A'); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-4 text-center">
                    <p class="text-sm font-medium text-gray-500">Returned</p>
                    <p class="text-2xl font-bold text-red-600"><?php echo e($stats['returned'] ?? 'N/A'); ?></p>
                </div>
            </div>
        </div>
        <?php endif; ?>


        <!-- Search and Filter Section -->
        <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
            <form method="GET" action="<?php echo e(route('admin.products')); ?>" class="flex flex-col md:flex-row gap-4">
                <div class="relative flex-grow">
                    <input type="text" name="search" value="<?php echo e($search); ?>" placeholder="Search products..."
                           class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                </div>
                <div class="flex flex-col sm:flex-row gap-2">
                    <select name="quality" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Qualities</option>
                        <option value="Authentic" <?php echo e($quality == 'Authentic' ? 'selected' : ''); ?>>Authentic</option>
                        <option value="Premium" <?php echo e($quality == 'Premium' ? 'selected' : ''); ?>>Premium</option>
                        <option value="Standard" <?php echo e($quality == 'Standard' ? 'selected' : ''); ?>>Standard</option>
                    </select>
                    <select name="color" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Colors</option>
                        <option value="Black" <?php echo e($color == 'Black' ? 'selected' : ''); ?>>Black</option>
                        <option value="Blue" <?php echo e($color == 'Blue' ? 'selected' : ''); ?>>Blue</option>
                        <option value="Blue Ae" <?php echo e($color == 'Blue Ae' ? 'selected' : ''); ?>>Blue Ae</option>
                        <option value="Cyan" <?php echo e($color == 'Cyan' ? 'selected' : ''); ?>>Cyan</option>
                        <option value="Gold" <?php echo e($color == 'Gold' ? 'selected' : ''); ?>>Gold</option>
                        <option value="Gray" <?php echo e($color == 'Gray' ? 'selected' : ''); ?>>Gray</option>
                        <option value="Green" <?php echo e($color == 'Green' ? 'selected' : ''); ?>>Green</option>
                        <option value="Red" <?php echo e($color == 'Red' ? 'selected' : ''); ?>>Red</option>
                        <option value="Silver" <?php echo e($color == 'Silver' ? 'selected' : ''); ?>>Silver</option>
                        <option value="White" <?php echo e($color == 'White' ? 'selected' : ''); ?>>White</option>
                        <option value="Yellow" <?php echo e($color == 'Yellow' ? 'selected' : ''); ?>>Yellow</option>
                    </select>
                    <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors"><i class="fas fa-filter mr-2"></i>Filter</button>
                </div>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr class="text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        <th class="px-6 py-3"><i class="fas fa-hashtag mr-1"></i>#</th>
                        <th class="px-6 py-3"><i class="fas fa-barcode mr-1"></i>Serial No</th>
                        <th class="px-6 py-3"><i class="fas fa-box mr-1"></i>Product Name</th>
                        <th class="px-6 py-3"><i class="fas fa-heart-pulse mr-1"></i>Condition</th>
                        <th class="px-6 py-3"><i class="fas fa-truck-fast mr-1"></i>Status</th>
                        <th class="px-6 py-3"><i class="fas fa-star mr-1"></i>Quality</th>
                        <th class="px-6 py-3"><i class="fas fa-mobile-screen-button mr-1"></i>IMEI</th>
                        <th class="px-6 py-3"><i class="fas fa-palette mr-1"></i>Color</th>
                        <th class="px-6 py-3"><i class="fas fa-building mr-1"></i>Distributor</th>
                        <th class="px-6 py-3"><i class="fas fa-store mr-1"></i>Retailer</th>
                        <th class="px-6 py-3"><i class="fas fa-user mr-1"></i>Client</th>
                        <th class="px-6 py-3"><i class="fas fa-cogs mr-1"></i>Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 transition-shadow duration-200 hover:shadow-md" data-product-id="<?php echo e($product->id); ?>">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($loop->iteration); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono"><?php echo e($product->serial_no); ?></td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div id="product_name-btn-<?php echo e($loop->iteration); ?>" class="dropdown-btn" onclick="toggleDropdown('product_name-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span><?php echo e($product->product_name); ?></span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="product_name-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    
                                    <?php $productNames = ['Nokia 105 (2023) +', 'Nokia 105 (2022) +', 'Nokia 210', 'Nokia 5310']; ?>
                                    <?php $__currentLoopData = $productNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        
                                        <a onclick="updateProductField(<?php echo e($product->id); ?>, 'product_name', '<?php echo e(addslashes($name)); ?>', <?php echo e($loop->parent->iteration); ?>)"><?php echo e($name); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->condition); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div id="status-btn-<?php echo e($loop->iteration); ?>" class="dropdown-btn" onclick="toggleDropdown('status-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span id="status-badge-<?php echo e($loop->iteration); ?>" class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php switch($product->status): case ('In Warehouse'): ?> bg-blue-100 text-blue-800 <?php break; ?> <?php case ('Shipped'): ?> bg-yellow-100 text-yellow-800 <?php break; ?> <?php case ('Delivered'): ?> bg-green-100 text-green-800 <?php break; ?> <?php case ('Sold'): ?> bg-purple-100 text-purple-800 <?php break; ?> <?php case ('Returned'): ?> bg-red-100 text-red-800 <?php break; ?> <?php default: ?> bg-gray-100 text-gray-800 <?php endswitch; ?>">
                                        <?php echo e($product->status); ?>

                                    </span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="status-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'status', 'In Warehouse', <?php echo e($loop->iteration); ?>)">In Warehouse</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'status', 'Shipped', <?php echo e($loop->iteration); ?>)">Shipped</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'status', 'Delivered', <?php echo e($loop->iteration); ?>)">Delivered</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'status', 'Sold', <?php echo e($loop->iteration); ?>)">Sold</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'status', 'Returned', <?php echo e($loop->iteration); ?>)">Returned</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div id="quality-btn-<?php echo e($loop->iteration); ?>" class="dropdown-btn" onclick="toggleDropdown('quality-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span><?php echo e($product->quality); ?></span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="quality-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'quality', 'Authentic', <?php echo e($loop->iteration); ?>)">Authentic</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'quality', 'Premium', <?php echo e($loop->iteration); ?>)">Premium</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'quality', 'Standard', <?php echo e($loop->iteration); ?>)">Standard</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'quality', 'Economy', <?php echo e($loop->iteration); ?>)">Economy</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono"><?php echo e($product->imei); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div id="color-btn-<?php echo e($loop->iteration); ?>" class="dropdown-btn" onclick="toggleDropdown('color-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span><?php echo e(is_array($product->color) ? implode(', ', $product->color) : $product->color); ?></span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="color-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'color', 'Cyan', <?php echo e($loop->iteration); ?>)">Cyan</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'color', 'White', <?php echo e($loop->iteration); ?>)">White</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'color', 'Black', <?php echo e($loop->iteration); ?>)">Black</a>
                                    <a onclick="updateProductField(<?php echo e($product->id); ?>, 'color', 'Red', <?php echo e($loop->iteration); ?>)">Red</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->distributor_name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->retailer_name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->client_name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-4">
                                <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" class="text-indigo-600 hover:text-indigo-900" title="Edit Product">
                                    <i class="fas fa-pencil-alt"></i>
                                </a>
                                <form action="<?php echo e(route('admin.products.delete', $product->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this product?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900" title="Delete Product"><i class="fas fa-trash"></i></button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="bg-gray-50 px-6 py-3 flex items-center justify-between border-t border-gray-200">
            <div class="text-sm text-gray-700">
                Showing <span class="font-medium"><?php echo e($products->firstItem()); ?></span> to <span class="font-medium"><?php echo e($products->lastItem()); ?></span> of <span class="font-medium"><?php echo e($products->total()); ?></span> results
            </div>
            <div class="flex space-x-2">
                <?php if($products->onFirstPage()): ?>
                    <span class="px-4 py-2 text-sm bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed">Previous</span>
                <?php else: ?>
                    <a href="<?php echo e($products->previousPageUrl() . '&' . http_build_query(request()->except('page'))); ?>" class="px-4 py-2 text-sm bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors">Previous</a>
                <?php endif; ?>

                <?php if($products->hasMorePages()): ?>
                    <a href="<?php echo e($products->nextPageUrl() . '&' . http_build_query(request()->except('page'))); ?>" class="px-4 py-2 text-sm bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors">Next</a>
                <?php else: ?>
                    <span class="px-4 py-2 text-sm bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed">Next</span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('scripts'); ?>
    
    <script>
        // Define a global URL template for the update route, making it robust
        window.productUpdateUrl = "<?php echo e(route('admin.products.update', ['product' => 'PRODUCT_ID_PLACEHOLDER'])); ?>";
    </script>
    <script src="<?php echo e(asset('admin/assets/js/products.js')); ?>"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Define the showToast function globally for this page
            window.showToast = function(message, type = 'info') {
                const toast = document.createElement('div');
                const iconClass = type === 'success' ? 'fa-check-circle' : (type === 'error' ? 'fa-exclamation-circle' : 'fa-info-circle');
                const bgColor = type === 'success' ? 'bg-green-500' : (type === 'error' ? 'bg-red-500' : 'bg-blue-500');

                toast.className = `toast-notification fixed top-5 right-5 p-4 rounded-lg shadow-lg z-[1000] flex items-center text-white ${bgColor}`;
                toast.innerHTML = `
                    <i class="fas ${iconClass} mr-3"></i>
                    <span>${message}</span>
                    <button onclick="this.parentElement.remove()" class="ml-4 text-white hover:text-gray-200">
                        <i class="fas fa-times"></i>
                    </button>
                `;

                document.body.appendChild(toast);

                setTimeout(() => {
                    if (toast.parentElement) {
                        toast.remove();
                    }
                }, 5000);
            };

            // Check for session flash messages and show toast
            <?php if(session('success')): ?>
                showToast('<?php echo e(session('success')); ?>', 'success');
            <?php endif; ?>
            <?php if(session('error')): ?>
                showToast('<?php echo e(session('error')); ?>', 'error');
            <?php endif; ?>
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\products\list.blade.php ENDPATH**/ ?>