<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-gradient-to-r from-primary to-purple-700 px-6 py-4">
            <h1 class="text-2xl font-bold text-white flex items-center"><i class="fas fa-boxes-stacked mr-3"></i>Product Information</h1>
            <p class="text-blue-100 mt-1">Click on dropdowns to change values</p>
        </div>

        <!-- Search and Filter Section -->
        <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
            <form method="GET" action="<?php echo e(route('products')); ?>" class="flex flex-col md:flex-row gap-4">
                <div class="relative flex-grow">
                    <input type="text" name="search" value="<?php echo e($search); ?>" placeholder="Search products..."
                           class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                </div>
                <div class="flex flex-col sm:flex-row gap-2">
                    <select name="quality" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Qualities</option>
                        <option value="Authentic" <?php echo e($quality == 'Authentic' ? 'selected' : ''); ?>>Authentic</option>
                        <option value="Premium" <?php echo e($quality == 'Premium' ? 'selected' : ''); ?>>Premium</option>
                        <option value="Standard" <?php echo e($quality == 'Standard' ? 'selected' : ''); ?>>Standard</option>
                    </select>
                    <select name="color" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Colors</option>
                        <option value="Blue Ae" <?php echo e($color == 'Blue Ae' ? 'selected' : ''); ?>>Blue Ae</option>
                        <option value="White" <?php echo e($color == 'White' ? 'selected' : ''); ?>>White</option>
                        <option value="Black" <?php echo e($color == 'Black' ? 'selected' : ''); ?>>Black</option>
                    </select>
                    <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors"><i class="fas fa-filter mr-2"></i>Filter</button>
                </div>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr class="text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        <th class="px-6 py-3"><i class="fas fa-hashtag mr-1"></i>#</th>
                        <th class="px-6 py-3"><i class="fas fa-barcode mr-1"></i>Serial No</th>
                        <th class="px-6 py-3"><i class="fas fa-box mr-1"></i>Product Name</th>
                        <th class="px-6 py-3"><i class="fas fa-heart-pulse mr-1"></i>Condition</th>
                        <th class="px-6 py-3"><i class="fas fa-truck-fast mr-1"></i>Status</th>
                        <th class="px-6 py-3"><i class="fas fa-star mr-1"></i>Quality</th>
                        <th class="px-6 py-3"><i class="fas fa-mobile-screen-button mr-1"></i>IMEI</th>
                        <th class="px-6 py-3"><i class="fas fa-palette mr-1"></i>Color</th>
                        <th class="px-6 py-3"><i class="fas fa-building mr-1"></i>Distributor</th>
                        <th class="px-6 py-3"><i class="fas fa-store mr-1"></i>Retailer</th>
                        <th class="px-6 py-3"><i class="fas fa-user mr-1"></i>Client</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $statusColor = match($product->status) {
                            'In Warehouse' => 'bg-blue-100 text-blue-800',
                            'Shipped' => 'bg-yellow-100 text-yellow-800',
                            'Delivered' => 'bg-green-100 text-green-800',
                            default => 'bg-gray-100 text-gray-800',
                        };
                    ?>
                    <tr class="hover:bg-gray-50 transition-shadow duration-200 hover:shadow-md">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($loop->iteration); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono"><?php echo e($product->serial_no); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div class="dropdown-btn" onclick="toggleDropdown('product-name-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span><?php echo e($product->product_name); ?></span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="product-name-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'product_name', 'Nokia 105 (2023) +')">Nokia 105 (2023) +</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'product_name', 'Nokia 105 (2022) +')">Nokia 105 (2022) +</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'product_name', 'Nokia 210')">Nokia 210</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'product_name', 'Nokia 5310')">Nokia 5310</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->condition); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($statusColor); ?>">
                                <?php echo e($product->status); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div class="dropdown-btn" onclick="toggleDropdown('quality-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span><?php echo e($product->quality); ?></span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="quality-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'quality', 'Authentic')">Authentic</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'quality', 'Premium')">Premium</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'quality', 'Standard')">Standard</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'quality', 'Economy')">Economy</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono"><?php echo e($product->imei); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div class="dropdown-btn" onclick="toggleDropdown('color-dropdown-<?php echo e($loop->iteration); ?>')">
                                    <span><?php echo e($product->color); ?></span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="color-dropdown-<?php echo e($loop->iteration); ?>" class="dropdown-content">
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'color', 'Blue Ae')">Blue Ae</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'color', 'White')">White</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'color', 'Black')">Black</a>
                                    <a onclick="updateProductField(<?php echo e($loop->iteration); ?>, 'color', 'Red')">Red</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->distributor_name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->retailer_name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($product->client_name); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="bg-gray-50 px-6 py-3 flex items-center justify-between border-t border-gray-200">
            <div class="text-sm text-gray-700">
                Showing <span class="font-medium"><?php echo e($products->firstItem()); ?></span> to <span class="font-medium"><?php echo e($products->lastItem()); ?></span> of <span class="font-medium"><?php echo e($products->total()); ?></span> results
            </div>
            <div class="flex space-x-2">
                <?php if($products->onFirstPage()): ?>
                    <span class="px-4 py-2 text-sm bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed">Previous</span>
                <?php else: ?>
                    <a href="<?php echo e($products->previousPageUrl() . '&' . http_build_query(request()->except('page'))); ?>" class="px-4 py-2 text-sm bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors">Previous</a>
                <?php endif; ?>

                <?php if($products->hasMorePages()): ?>
                    <a href="<?php echo e($products->nextPageUrl() . '&' . http_build_query(request()->except('page'))); ?>" class="px-4 py-2 text-sm bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors">Next</a>
                <?php else: ?>
                    <span class="px-4 py-2 text-sm bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed">Next</span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\products.blade.php ENDPATH**/ ?>