<?php $__env->startSection('title', 'Customer Service - NewTech Mobile'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto px-4 py-8">
        <div class="bg-white p-8 rounded-lg shadow-lg max-w-4xl mx-auto">
            <h1 class="text-3xl font-bold mb-6 text-gray-800 border-b pb-4">Customer Service</h1>

            <div class="space-y-6">
                <section>
                    <h2 class="text-2xl font-semibold mb-3 text-gray-700">We're Here to Help!</h2>
                    <p class="text-gray-600 leading-relaxed mb-4">
                        If you have any questions about our products, need help with an order, or have any other inquiries, our customer service team is ready to assist you.
                    </p>

                    <!-- Interactive Contact Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 my-6">
                        <div class="contact-card bg-primary/10 p-4 rounded-lg border border-primary/20 text-center">
                            <i class="fas fa-envelope text-primary text-2xl mb-2"></i>
                            <h3 class="font-semibold text-gray-700">Email Support</h3>
                            <p class="text-sm text-gray-600 mt-1">Get help via email</p>
                            <a href="mailto:support@newtechmobile.com" class="inline-block mt-3 text-primary font-medium hover:underline">support@newtechmobile.com</a>
                        </div>
                        <div class="contact-card bg-green-50 p-4 rounded-lg border border-green-100 text-center">
                            <i class="fas fa-phone text-green-500 text-2xl mb-2"></i>
                            <h3 class="font-semibold text-gray-700">Phone Support</h3>
                            <p class="text-sm text-gray-600 mt-1">Call us directly</p>
                            <a href="tel:+1234567890" class="inline-block mt-3 text-primary font-medium hover:underline">+1 (234) 567-890</a>
                        </div>
                        <div class="contact-card bg-secondary/10 p-4 rounded-lg border border-secondary/20 text-center">
                            <i class="fas fa-comments text-secondary text-2xl mb-2"></i>
                            <h3 class="font-semibold text-gray-700">Live Chat</h3>
                            <p class="text-sm text-gray-600 mt-1">Chat with our agents</p>
                            <button id="liveChatBtn" class="mt-3 bg-secondary text-white px-4 py-1 rounded hover:bg-secondary/90 transition">Start Chat</button>
                        </div>
                    </div>
                </section>

                <!-- Tabs for different service areas -->
                <section>
                    <h2 class="text-2xl font-semibold mb-3 text-gray-700">How Can We Help?</h2>

                    <div class="border-b border-gray-200 mb-4">
                        <div class="flex flex-wrap -mb-px">
                            <button class="tab-button py-2 px-4 font-medium text-gray-500 hover:text-primary border-b-2 border-transparent active" data-tab="faq">
                                FAQ
                            </button>
                            <button class="tab-button py-2 px-4 font-medium text-gray-500 hover:text-primary border-b-2 border-transparent" data-tab="contact">
                                Contact Form
                            </button>
                            <button class="tab-button py-2 px-4 font-medium text-gray-500 hover:text-primary border-b-2 border-transparent" data-tab="hours">
                                Service Hours
                            </button>
                        </div>
                    </div>

                    <!-- FAQ Tab Content -->
                    <div id="faq-tab" class="tab-content active">
                        <div class="accordion">
                            <div class="accordion-item">
                                <div class="accordion-header flex justify-between items-center">
                                    <h3 class="font-medium text-gray-700">How can I track my order?</h3>
                                    <i class="fas fa-chevron-down text-gray-400 transition-transform"></i>
                                </div>
                                <div class="accordion-content">
                                    <p class="text-gray-600 py-2">You can track your order by logging into your account and visiting the "Order History" section. Alternatively, you can use the tracking link sent to your email.</p>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header flex justify-between items-center">
                                    <h3 class="font-medium text-gray-700">What is your return policy?</h3>
                                    <i class="fas fa-chevron-down text-gray-400 transition-transform"></i>
                                </div>
                                <div class="accordion-content">
                                    <p class="text-gray-600 py-2">We offer a 30-day return policy for all products in original condition with packaging. Please contact our support team to initiate a return.</p>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header flex justify-between items-center">
                                    <h3 class="font-medium text-gray-700">Do you offer international shipping?</h3>
                                    <i class="fas fa-chevron-down text-gray-400 transition-transform"></i>
                                </div>
                                <div class="accordion-content">
                                    <p class="text-gray-600 py-2">Yes, we ship to over 50 countries worldwide. Shipping costs and delivery times vary by location. You can check availability during checkout.</p>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header flex justify-between items-center">
                                    <h3 class="font-medium text-gray-700">How do I set up my device?</h3>
                                    <i class="fas fa-chevron-down text-gray-400 transition-transform"></i>
                                </div>
                                <div class="accordion-content">
                                    <p class="text-gray-600 py-2">We provide detailed setup guides with all our products. You can also find video tutorials on our YouTube channel or contact our support team for assistance.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Form Tab Content -->
                    <div id="contact-tab" class="tab-content hidden">
                        <form class="space-y-4">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Your Name</label>
                                <input type="text" id="name" class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary">
                            </div>
                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                                <input type="email" id="email" class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary">
                            </div>
                            <div>
                                <label for="subject" class="block text-sm font-medium text-gray-700 mb-1">Subject</label>
                                <select id="subject" class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary">
                                    <option value="">Select a topic</option>
                                    <option value="order">Order Issue</option>
                                    <option value="product">Product Question</option>
                                    <option value="return">Return Request</option>
                                    <option value="technical">Technical Support</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                            <div>
                                <label for="message" class="block text-sm font-medium text-gray-700 mb-1">Message</label>
                                <textarea id="message" rows="4" class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary"></textarea>
                            </div>
                            <button type="submit" class="bg-primary text-white px-6 py-2 rounded-md hover:bg-primary/90 transition">Send Message</button>
                        </form>
                    </div>

                    <!-- Service Hours Tab Content -->
                    <div id="hours-tab" class="tab-content hidden">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="font-semibold text-gray-700 mb-2">Customer Service Hours</h3>
                            <ul class="space-y-2 text-gray-600">
                                <li class="flex justify-between">
                                    <span>Monday - Friday</span>
                                    <span>9:00 AM - 5:00 PM (EST)</span>
                                </li>
                                <li class="flex justify-between">
                                    <span>Saturday</span>
                                    <span>10:00 AM - 2:00 PM (EST)</span>
                                </li>
                                <li class="flex justify-between">
                                    <span>Sunday</span>
                                    <span>Closed</span>
                                </li>
                            </ul>
                            <div class="mt-4 p-3 bg-yellow-50 border border-yellow-200 rounded">
                                <p class="text-sm text-yellow-800"><i class="fas fa-exclamation-circle mr-2"></i>For emergency technical support outside business hours, please call our 24/7 helpline at <strong>+1 (234) 567-891</strong></p>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Live Chat Simulation -->
                <div id="chatWindow" class="fixed bottom-5 right-5 w-80 bg-white rounded-lg shadow-xl border border-gray-200 hidden">
                    <div class="bg-primary text-white p-3 rounded-t-lg flex justify-between items-center">
                        <h3 class="font-semibold">Live Chat Support</h3>
                        <button id="closeChat" class="text-white hover:text-gray-200">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <div class="p-4 h-64 overflow-y-auto bg-gray-50">
                        <div class="mb-4 text-right">
                            <div class="bg-primary/10 text-gray-800 p-3 rounded-lg inline-block max-w-xs">
                                Hello, I need help with my order.
                            </div>
                        </div>
                        <div class="mb-4">
                            <div class="bg-gray-200 text-gray-800 p-3 rounded-lg inline-block max-w-xs">
                                Hi there! I'd be happy to help. Could you please provide your order number?
                            </div>
                        </div>
                    </div>
                    <div class="p-3 border-t border-gray-200">
                        <div class="flex">
                            <input type="text" placeholder="Type your message..." class="flex-1 border border-gray-300 rounded-l-lg px-4 py-2 focus:outline-none focus:ring-1 focus:ring-primary">
                            <button class="bg-primary text-white px-4 rounded-r-lg hover:bg-primary/90 transition">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .accordion-item {
        border-bottom: 1px solid #e5e7eb;
    }
    .accordion-header {
        cursor: pointer;
        padding: 1rem 0;
        transition: all 0.3s ease;
    }
    .accordion-header:hover {
        @apply text-primary;
    }
    .accordion-content {
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }
    .accordion-content.active {
        max-height: 500px;
    }
    .contact-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .contact-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    .tab-button {
        transition: all 0.3s ease;
    }
    .tab-button.active {
        @apply bg-primary text-white border-primary;
    }
    .form-input:focus {
        @apply ring-2 ring-primary/20;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Accordion functionality
    document.querySelectorAll('.accordion-header').forEach(header => {
        header.addEventListener('click', () => {
            const content = header.nextElementSibling;
            const icon = header.querySelector('i');

            // Toggle active class on content
            content.classList.toggle('active');

            // Rotate icon
            icon.classList.toggle('fa-chevron-down');
            icon.classList.toggle('fa-chevron-up');
        });
    });

    // Tab functionality
    document.querySelectorAll('.tab-button').forEach(button => {
        button.addEventListener('click', () => {
            // Remove active class from all buttons and tab contents
            document.querySelectorAll('.tab-button').forEach(btn => {
                btn.classList.remove('active');
            });
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
                content.classList.add('hidden');
            });

            // Add active class to clicked button
            button.classList.add('active');

            // Show corresponding tab content
            const tabId = button.getAttribute('data-tab');
            document.getElementById(`${tabId}-tab`).classList.remove('hidden');
            document.getElementById(`${tabId}-tab`).classList.add('active');
        });
    });

    // Live Chat functionality
    const liveChatBtn = document.getElementById('liveChatBtn');
    const chatWindow = document.getElementById('chatWindow');
    const closeChat = document.getElementById('closeChat');

    liveChatBtn.addEventListener('click', () => {
        chatWindow.classList.toggle('hidden');
    });

    closeChat.addEventListener('click', () => {
        chatWindow.classList.add('hidden');
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application-5\resources\views\frontend\pages\customer-service.blade.php ENDPATH**/ ?>