const defaultTheme = require('tailwindcss/defaultTheme');
const forms = require('@tailwindcss/forms');

/** @type {import('tailwindcss').Config} */
module.exports = {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/js/**/*.js',
        './resources/views/**/*.blade.php',
    ],
    safelist: [
        // Gradients
        'from-blue-500', 'to-blue-600', 'hover:from-blue-600', 'hover:to-blue-700',
        'from-blue-600', 'to-indigo-700',
        'from-indigo-600', 'to-blue-700',
        'from-blue-50', 'to-indigo-100',
        'from-gray-50', 'to-blue-50',

        // Primary/Secondary colors safelist
        'text-primary', 'text-secondary',
        'bg-primary', 'bg-secondary',
        'hover:text-primary', 'hover:bg-primary',
        'group-hover:text-primary',
        // Status badge colors for dynamic classes
        'bg-blue-100',   'text-blue-800',
        'bg-amber-100',  'text-amber-800',
        'bg-green-100',  'text-green-800',
        'bg-purple-100', 'text-purple-800',
        'bg-red-100',    'text-red-800',
        'bg-gray-100',   'text-gray-800',
        // Color indicators from getColorClass function
        'bg-cyan-500',
        'bg-gray-200',
        'bg-black',
        'bg-red-500',
        'bg-blue-500',
        'bg-green-500',
        'bg-amber-500',
        'bg-purple-500',
    ],

    theme: {
        extend: {
            colors: {
                primary: 'rgb(var(--color-primary) / <alpha-value>)',
                secondary: 'rgb(var(--color-secondary) / <alpha-value>)',
            },
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
        },
    },

    plugins: [forms],
};
