<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Category;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function home()
    {
        $featuredProducts = Product::where('featured', true)
            ->where('in_stock', true)
            ->take(8)
            ->get();

        return view('frontend.pages.home', compact('featuredProducts'));
    }

    public function about()
    {
        return view('frontend.pages.about');
    }

    public function contact()
    {
        return view('frontend.pages.contact');
    }

    public function customerService()
    {
        return view('frontend.pages.customer-service');
    }
}
