<?php

namespace App\View\Composers;

use App\Models\Category;
use Illuminate\View\View;

class CategoryComposer
{
    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    public function compose(View $view)
    {
        // Eager load children categories and count products for each category
        $categories = Category::with('children')
            ->whereNull('parent_id')
            ->withCount('products')->get();
        $view->with('categories', $categories);
    }
}
