<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            
            // 1st: Serial No
            $table->string('serial_no')->unique();
            
            // 2nd: Product Name
            $table->string('product_name');

            // Product Image
            $table->string('image')->nullable();
            
            // 3rd: Condition
            $table->enum('condition', ['New', 'Refurbished', 'Used', 'Damaged'])->default('New');
            
            // 4th: Status
            $table->enum('status', ['In Warehouse', 'Shipped', 'Delivered', 'Returned', 'Sold'])->default('In Warehouse');
            
            // 5th: Quality
            $table->enum('quality', ['Authentic', 'Premium', 'Standard', 'Economy'])->default('Authentic');
            
            // 6th: IMEI
            $table->string('imei')->unique()->nullable();
            
            // 7th: Color
            $table->string('color');
            
            // 8th: Distributor/SR Info
            $table->string('distributor_name');
            $table->string('distributor_code');
            $table->string('distributor_contact')->nullable();
            $table->text('distributor_address')->nullable();
            
            // 9th: Retailer Info
            $table->string('retailer_name')->nullable();
            $table->string('retailer_code')->nullable();
            $table->string('retailer_contact')->nullable();
            $table->text('retailer_address')->nullable();
            $table->timestamp('retailer_assigned_at')->nullable();
            
            // 10th: Client/Customer Info
            $table->string('client_name')->nullable();
            $table->string('client_phone')->nullable();
            $table->string('client_email')->nullable();
            $table->text('client_address')->nullable();
            $table->timestamp('sold_at')->nullable();
            
            // Additional fields
            $table->text('description')->nullable();
            $table->string('barcode')->nullable()->unique();
            $table->string('category')->default('Mobile Phone');
            $table->decimal('price', 10, 2)->nullable();
            $table->decimal('cost', 10, 2)->nullable();
            $table->string('warranty_period')->nullable();
            $table->date('manufacture_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->string('batch_number')->nullable();
            $table->string('supplier_name')->nullable();
            $table->string('location')->nullable();
            $table->text('notes')->nullable();
            
            // Tracking fields
            $table->string('scanned_by')->default('System');
            $table->timestamp('scanned_at')->nullable();
            $table->string('created_by')->default('System');
            $table->string('updated_by')->default('System');
            
            $table->timestamps();
            
            // Indexes
            $table->index('serial_no');
            $table->index('imei');
            $table->index('barcode');
            $table->index('product_name');
            $table->index('distributor_code');
            $table->index('retailer_code');
            $table->index('status');
            $table->index('quality');
        });
    }

    public function down()
    {
        Schema::dropIfExists('products');
    }
};