// Modern Carousel functionality
document.addEventListener('DOMContentLoaded', function () {
    const track = document.getElementById('carousel-track');
    const slides = document.querySelectorAll('.carousel-slide');
    const dots = document.querySelectorAll('.carousel-dot');
    const prevBtn = document.getElementById('prev-btn');
    const nextBtn = document.getElementById('next-btn');

    if (!track || slides.length === 0) return;

    let currentIndex = 0;
    const totalSlides = slides.length;
    let autoSlideInterval;

    // Initialize carousel position
    updateCarousel();

    // Next button event
    nextBtn.addEventListener('click', function () {
        resetAutoSlide();
        currentIndex = (currentIndex + 1) % totalSlides;
        updateCarousel();
    });

    // Previous button event
    prevBtn.addEventListener('click', function () {
        resetAutoSlide();
        currentIndex = (currentIndex - 1 + totalSlides) % totalSlides;
        updateCarousel();
    });

    // Dot navigation events
    dots.forEach((dot, index) => {
        dot.addEventListener('click', function () {
            resetAutoSlide();
            currentIndex = index;
            updateCarousel();
        });
    });

    // Auto slide every 5 seconds
    function startAutoSlide() {
        autoSlideInterval = setInterval(function () {
            currentIndex = (currentIndex + 1) % totalSlides;
            updateCarousel();
        }, 5000);
    }

    function resetAutoSlide() {
        clearInterval(autoSlideInterval);
        startAutoSlide();
    }

    startAutoSlide();

    // Update carousel position and active dot
    function updateCarousel() {
        const translateX = -currentIndex * 100;
        track.style.transform = `translate3d(${translateX}%, 0px, 0px)`;

        // Update active dot
        dots.forEach((dot, index) => {
            if (index === currentIndex) {
                dot.classList.add('active');
            } else {
                dot.classList.remove('active');
            }
        });
    }

    // Pause auto-slide on hover
    track.addEventListener('mouseenter', function () {
        clearInterval(autoSlideInterval);
    });

    track.addEventListener('mouseleave', function () {
        startAutoSlide();
    });
});

// Countdown Timer functionality
function startCountdown() {
    const countdownElement = document.getElementById('countdown');
    if (!countdownElement) return;

    // Set the end time for the countdown (e.g., 12 hours from now)
    const countdownTime = new Date().getTime() + (12 * 60 * 60 * 1000);

    const interval = setInterval(function () {
        const now = new Date().getTime();
        const distance = countdownTime - now;

        const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((distance % (1000 * 60)) / 1000);

        document.getElementById('hours').innerText = hours.toString().padStart(2, '0');
        document.getElementById('minutes').innerText = minutes.toString().padStart(2, '0');
        document.getElementById('seconds').innerText = seconds.toString().padStart(2, '0');

        if (distance < 0) {
            clearInterval(interval);
            countdownElement.innerHTML = "<div class='text-xl font-bold text-red-500'>Sale Ended!</div>";
        }
    }, 1000);
}
startCountdown();




// swiper slider js

const swiper = new Swiper('.mySwiper', {
    loop: true,
    autoplay: {
        delay: 5000,
        disableOnInteraction: true,
    },
    pagination: {
        el: '.swiper-pagination',
        clickable: true,
        renderBullet: function (index, className) {
            return `<span class="${className} w-2 h-1.5 rounded-full bg-white hover:bg-orange-500 transition-all duration-300"></span>`;
        },
    },
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
    },
});
