<x-guest-layout>
    <div class="bg-white py-8 px-6 shadow-lg rounded-lg sm:px-10">
        <!-- Session Status -->
        <x-auth-session-status class="mb-4" :status="session('status')" />

        <form method="POST" action="{{ route('login') }}" class="space-y-6">
            @csrf

            <!-- Email Address -->
            <div>
                <x-text-input id="email" class="block w-full text-lg" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" placeholder="Email address" />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <!-- Password -->
            <div>
                <x-text-input id="password" class="block w-full text-lg"
                                type="password"
                                name="password"
                                required autocomplete="current-password"
                                placeholder="Password" />
                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <!-- Login Button -->
            <div>
                <x-primary-button class="w-full justify-center text-lg font-bold py-3">
                    {{ __('Log In') }}
                </x-primary-button>
            </div>

            <!-- Forgot Password -->
            <div class="text-center">
                @if (Route::has('password.request'))
                    <a class="text-sm text-blue-600 hover:underline" href="{{ route('password.request') }}">
                        {{ __('Forgot your password?') }}
                    </a>
                @endif
            </div>

            <!-- Divider -->
            <div class="relative my-4">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t border-gray-300"></div>
                </div>
            </div>

            <!-- Create New Account Button -->
            <div class="pt-6 text-center">
                <a href="{{ route('register') }}" class="inline-flex justify-center py-3 px-6 border border-transparent rounded-md shadow-sm text-lg font-bold text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                    {{ __('Create New Account') }}
                </a>
            </div>
        </form>
    </div>
</x-guest-layout>
