@extends('frontend.layouts.app')

@section('title', 'Contact Us - NewTech Mobile')

@section('content')
    <!-- Page Title -->
    <div class="bg-gradient-to-r from-blue-50 to-indigo-100 py-16 px-4 border-b border-gray-200">
        <div class="container mx-auto max-w-7xl text-center">
            <nav class="mb-4" aria-label="breadcrumb">
                <ol class="flex items-center justify-center space-x-2 text-sm text-gray-600">
                    <li><a href="{{ route('home') }}" class="hover:text-blue-600 transition-colors duration-200">Home</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="font-semibold text-gray-800" aria-current="page">Contact Us</li>
                </ol>
            </nav>
            <h1 class="text-4xl md:text-5xl font-bold text-gray-900 mb-3">Get in Touch</h1>
            <p class="text-gray-600 text-lg max-w-3xl mx-auto">We'd love to hear from you. Whether you have a question about our products, pricing, or anything else, our team is ready to answer all your questions.</p>
        </div>
    </div>

    <!-- Main Content -->
    <section class="py-16 lg:py-24 bg-white">
        <div class="container mx-auto max-w-7xl px-4">

            <div class="grid grid-cols-1 lg:grid-cols-12 gap-12">

                <!-- Contact Information -->
                <div class="lg:col-span-5">
                    <div class="bg-gray-50 p-8 rounded-2xl border border-gray-100 h-full">
                        <h2 class="text-3xl font-bold text-gray-800 mb-6">Contact Information</h2>
                        <p class="text-gray-600 mb-8">
                            Fill up the form and our team will get back to you within 24 hours. You can also reach us through the following channels.
                        </p>

                        <div class="space-y-6">
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <i class="fas fa-phone-alt text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-lg text-gray-800">Call Us</h3>
                                    <p class="text-gray-600">Our team is available from 10am to 8pm.</p>
                                    <a href="tel:+8801234567890" class="text-blue-600 font-medium hover:underline mt-1 block">+880 123 456 7890</a>
                                </div>
                            </div>
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <i class="fas fa-envelope text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-lg text-gray-800">Email Us</h3>
                                    <p class="text-gray-600">For general inquiries and support.</p>
                                    <a href="mailto:info@newtechmobile.com" class="text-blue-600 font-medium hover:underline mt-1 block">info@newtechmobile.com</a>
                                </div>
                            </div>
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <i class="fas fa-map-marker-alt text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-lg text-gray-800">Our Location</h3>
                                    <p class="text-gray-600">123 Mobile Street, Tech City, Dhaka, Bangladesh</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Form -->
                <div class="lg:col-span-7">
                    <div class="bg-white p-8 rounded-2xl shadow-lg border border-gray-100">
                        <h2 class="text-3xl font-bold text-gray-800 mb-6">Send a Message</h2>
                        <form action="#" method="POST">
                            @csrf
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Your Name</label>
                                    <input type="text" name="name" id="name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500" placeholder="John Doe" required>
                                </div>
                                <div>
                                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Your Email</label>
                                    <input type="email" name="email" id="email" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500" placeholder="john.doe@example.com" required>
                                </div>
                            </div>
                            <div class="mt-6">
                                <label for="subject" class="block text-sm font-medium text-gray-700 mb-2">Subject</label>
                                <input type="text" name="subject" id="subject" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500" placeholder="Question about a product" required>
                            </div>
                            <div class="mt-6">
                                <label for="message" class="block text-sm font-medium text-gray-700 mb-2">Message</label>
                                <textarea name="message" id="message" rows="5" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500" placeholder="Write your message here..." required></textarea>
                            </div>
                            <div class="mt-8 text-right">
                                <button type="submit" class="bg-blue-600 text-white font-bold py-3 px-8 rounded-lg hover:bg-blue-700 transition duration-300">
                                    Send Message
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
