@extends('frontend.layouts.app')

@section('title', 'NewTech Mobile - Premium Phones & Accessories')

@section('content')
    <!-- Hero Section -->
    <section class="bg-blue-50 text-gray-800 py-16 md:py-52 px-4">
        <div class="container mx-auto max-w-7xl px-4">
            <div class="container mx-auto max-w-7xl grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Left Side: Title and Verification Form -->
                <div class="text-center lg:text-left">
                    <h1 class="text-4xl md:text-5xl font-bold mb-4 text-blue-900 leading-tight">
                        Authentic Phones, <br> <span class="text-blue-600">Guaranteed.</span>
                    </h1>
                    <p class="text-lg mb-8 text-gray-600">
                        Verify your product's authenticity by entering its serial number or IMEI.
                    </p>

                    <!-- Verification Form -->
                    <div class="bg-white p-6 rounded-2xl shadow-lg max-w-lg mx-auto lg:mx-0">
                        <h2 class="text-xl font-semibold text-gray-800 mb-4">Product Authenticity Report</h2>
                        <form action="{{ route('products.verify.post') }}" method="POST">
                            @csrf
                            <div class="relative group">
                                <input type="text" name="serial_no" placeholder="Enter Serial Number or IMEI..."
                                    class="w-full bg-gray-50 border-2 border-gray-300 rounded-full py-3 pl-5 pr-32 text-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                                    required>
                                <button type="submit"
                                    class="absolute inset-y-0 right-0 flex items-center justify-center bg-blue-600 hover:bg-blue-700 text-white font-bold px-6 rounded-full m-1.5 transition-all duration-300 group-focus-within:shadow-lg">
                                    <i class="fas fa-search sm:mr-2"></i>
                                    <span class="hidden sm:inline">Verify</span>
                                </button>
                            </div>
                        </form>
                        <p class="text-xs text-gray-500 mt-3 text-center">
                            Your trust is our priority. Ensure you have a genuine product.
                        </p>
                    </div>

                    <div class="mt-8 text-center lg:text-left">
                        <a href="{{ route('products.index') }}" class="text-blue-600 font-semibold hover:underline">Or
                            browse
                            our products <i class="fas fa-arrow-right ml-1"></i></a>
                    </div>
                </div>
                <!-- Right Side: Image -->
                <div class="flex justify-center">
                    <img src="{{ asset('frontend/assets/images/hero.avif') }}" alt="Latest Smartphone"
                        class="rounded-lg shadow-lg max-h-85 object-contain">
                </div>
            </div>
        </div>
    </section>

<!-- Product Grid Section -->
<section class="py-8 px-4 sm:px-6 lg:px-8">
    <div class="container mx-auto max-w-7xl grid grid-cols-1 lg:grid-cols-10 gap-6">
        <!-- Modern Hero Carousel -->
        <div class="carousel-container col-span-1 lg:col-span-7 h-full rounded-2xl overflow-hidden shadow-lg">
            <div class="carousel-track" id="carousel-track">
                <!-- Slide 1 -->
                <div class="carousel-slide">
                    <img src="{{ asset('frontend/assets/images/Premium-Smartphones.png') }}" alt="Website Banner"
                        class="carousel-image">
                    <div class="carousel-content">
                        <h3 class="carousel-title">Premium Smartphones</h3>
                        <p class="carousel-description">Discover the latest flagship models with cutting-edge technology
                        </p>
                        <a href="#" class="carousel-button">
                            Shop Now <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                    <div class="carousel-indicator">New Arrival</div>
                </div>

                <!-- Slide 2 -->
                <div class="carousel-slide">
                    <img src="{{ asset('frontend/assets/images/Samsung.avif') }}" alt="Samsung S25 Ultra"
                        class="carousel-image">
                    <div class="carousel-content">
                        <h3 class="carousel-title">Samsung S25 Ultra</h3>
                        <p class="carousel-description">Experience the future with our most advanced camera system yet
                        </p>
                        <a href="#" class="carousel-button">
                            Explore <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                    <div class="carousel-indicator">Flagship</div>
                </div>

                <!-- Slide 3 -->
                <div class="carousel-slide">
                    <img src="{{ asset('frontend/assets/images/iPad.avif') }}" alt="iPad Air M3" class="carousel-image">
                    <div class="carousel-content">
                        <h3 class="carousel-title">iPad Air M3</h3>
                        <p class="carousel-description">Powerful performance meets stunning Retina display</p>
                        <a href="#" class="carousel-button">
                            Learn More <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                    <div class="carousel-indicator">Just Released</div>
                </div>

                <!-- Slide 4 -->
                <div class="carousel-slide">
                    <img src="https://images.unsplash.com/photo-1517336714731-489689fd1ca8?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80"
                        alt="MacBook Pro M4" class="carousel-image">
                    <div class="carousel-content">
                        <h3 class="carousel-title">MacBook Pro M4</h3>
                        <p class="carousel-description">Next-level performance for professionals and creators</p>
                        <a href="#" class="carousel-button">
                            Discover <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                    <div class="carousel-indicator">Pro Series</div>
                </div>
            </div>

            <!-- Navigation Buttons -->
            <button class="carousel-arrow prev" aria-label="Previous Slide" id="prev-btn">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="carousel-arrow next" aria-label="Next Slide" id="next-btn">
                <i class="fas fa-chevron-right"></i>
            </button>

            <!-- Dots Navigation -->
            <div class="carousel-nav" role="navigation" aria-label="Carousel dots">
                <button class="carousel-dot active" type="button" aria-label="Go to slide 1" data-index="0"></button>
                <button class="carousel-dot" type="button" aria-label="Go to slide 2" data-index="1"></button>
                <button class="carousel-dot" type="button" aria-label="Go to slide 3" data-index="2"></button>
                <button class="carousel-dot" type="button" aria-label="Go to slide 4" data-index="3"></button>
            </div>
        </div>

        <!-- Right Side Product Cards - Updated -->
        <div class="col-span-1 lg:col-span-3 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-1 gap-6">
            @php
            // We take 2 products. You might want to pass a specific variable for this from your controller.
            $sideProducts = $featuredProducts->take(2);
            @endphp

            @foreach ($sideProducts as $product)
            <a href="{{ route('products.show', $product->id) }}" class="product-side-card group">
                <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400x300' }}"
                    alt="{{ $product->product_name }}" class="product-side-image">
                <div class="product-side-overlay">
                    <h3 class="font-bold text-lg leading-tight mb-2">{{ $product->product_name }}</h3>
                    <div class="flex items-center justify-between">
                        <div>
                            @if ($product->discount_price)
                            <span
                                class="font-bold text-yellow-400 text-xl">৳{{ number_format($product->discount_price) }}</span>
                            <span
                                class="text-sm line-through opacity-70 ml-1">৳{{ number_format($product->price) }}</span>
                            @else
                            <span
                                class="font-bold text-yellow-400 text-xl">৳{{ number_format($product->price) }}</span>
                            @endif
                        </div>
                        <div
                            class="bg-blue-600 text-white text-xs font-bold px-3 py-2 rounded-full opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            Shop Now
                        </div>
                    </div>
                </div>
            </a>
            @endforeach

            {{-- Placeholder if there are less than 2 products --}}
            @if ($sideProducts->count() < 2)
                @for ($i=0; $i < 2 - $sideProducts->count(); $i++)
                <div class="product-side-card bg-gradient-to-br from-gray-200 to-gray-300 rounded-2xl flex items-center justify-center h-full min-h-[200px] lg:min-h-0">
                    <div class="text-center p-4">
                        <i class="fas fa-ad text-gray-500 text-3xl mb-2"></i>
                        <span class="text-gray-500 font-medium">Ad Space</span>
                    </div>
                </div>
                @endfor
                @endif
        </div>
    </div>

    <!-- Additional Info Section -->
    <div class="container mx-auto max-w-7xl mt-8 lg:mt-12 bg-white rounded-xl shadow-md p-6">
        <h2 class="text-2xl font-bold mb-6 text-center">Why Shop With Us?</h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
            <div
                class="text-center p-4 rounded-lg transition-all duration-300 hover:bg-indigo-50 hover:shadow-inner group">
                <div
                    class="text-3xl font-bold text-indigo-600 mb-2 transition-transform duration-300 group-hover:scale-110">
                    38</div>
                <div class="text-sm font-medium">Months EMI</div>
            </div>
            <div
                class="text-center p-4 rounded-lg transition-all duration-300 hover:bg-indigo-50 hover:shadow-inner group">
                <div
                    class="text-3xl font-bold text-indigo-600 mb-2 transition-transform duration-300 group-hover:scale-110">
                    <i class="fas fa-shipping-fast"></i>
                </div>
                <div class="text-sm font-medium">Fastest Home Delivery</div>
            </div>
            <div
                class="text-center p-4 rounded-lg transition-all duration-300 hover:bg-indigo-50 hover:shadow-inner group">
                <div
                    class="text-3xl font-bold text-indigo-600 mb-2 transition-transform duration-300 group-hover:scale-110">
                    <i class="fas fa-sync-alt"></i>
                </div>
                <div class="text-sm font-medium">Exchange Facility</div>
            </div>
            <div
                class="text-center p-4 rounded-lg transition-all duration-300 hover:bg-indigo-50 hover:shadow-inner group">
                <div
                    class="text-3xl font-bold text-indigo-600 mb-2 transition-transform duration-300 group-hover:scale-110">
                    <i class="fas fa-tag"></i>
                </div>
                <div class="text-sm font-medium">Best Price Deals</div>
            </div>
        </div>
        <div class="mt-6 pt-6 border-t border-gray-200 text-center">
            <div class="text-lg font-medium text-gray-700">After Sale Service</div>
        </div>
    </div>
</section>

<!-- Featured Products -->
<section class="py-12 px-4">
    <div class="container mx-auto max-w-7xl">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-3xl font-bold text-gray-800">Featured Products</h2>
            <a href="{{ route('products.index') }}" class="text-blue-600 font-semibold hover:underline">View All <i
                    class="fas fa-arrow-right ml-1"></i></a>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            @forelse($featuredProducts as $product)
            <div class="bg-white rounded-xl border border-gray-200 overflow-hidden product-card-minimal">
                <a href="{{ route('products.show', $product->id) }}"
                    class="block bg-gray-100 featured-image-container">
                    <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400x300' }}"
                        alt="{{ $product->product_name }}" class="w-full h-48 object-contain p-4 featured-image">
                    <div
                        class="absolute inset-0 flex items-center justify-center bg-black bg-opacity-25 opacity-0 transition-opacity duration-300 view-product-overlay">
                        <div class="text-white font-bold py-2 px-4 rounded-lg border-2 border-white">View Product
                        </div>
                    </div>
                </a>
                <div class="p-5">
                    <h3 class="font-bold text-lg mb-2 truncate" title="{{ $product->product_name }}">
                        {{ $product->product_name }}
                    </h3>
                    <div class="flex justify-between items-center">
                        <div>
                            @if ($product->discount_price)
                            <span
                                class="font-bold text-blue-600 text-xl">৳{{ number_format($product->discount_price) }}</span>
                            <span
                                class="text-sm text-gray-500 line-through ml-2">৳{{ number_format($product->price) }}</span>
                            @else
                            <span
                                class="font-bold text-blue-600 text-xl">৳{{ number_format($product->price) }}</span>
                            @endif
                        </div>
                        @if ($product->discount_price && $product->price > 0)
                        <div class="bg-red-100 text-red-800 text-xs font-bold px-2.5 py-1.5 rounded-full">
                            {{ round((($product->price - $product->discount_price) / $product->price) * 100) }}%
                            OFF
                        </div>
                        @else
                        <a href="{{ route('products.show', $product->id) }}"
                            class="bg-blue-100 text-blue-800 w-10 h-10 rounded-full hover:bg-blue-200 font-semibold transition duration-300 flex items-center justify-center"
                            title="View Product"><i class="fas fa-eye"></i></a>
                        @endif
                    </div>
                </div>
            </div>
            @empty
            <p class="text-gray-500 col-span-full text-center">No featured products available at the moment.</p>
            @endforelse
        </div>
    </div>
</section>

<!-- Flash Sale Section -->
<section class="py-16 px-4 bg-gray-900 text-white">
    <div class="container mx-auto max-w-7xl">
        <div class="flex flex-col lg:flex-row items-center justify-between mb-12">
            <div class="text-center lg:text-left">
                <h2 class="text-3xl md:text-4xl font-bold text-yellow-400">Flash Sale!</h2>
                <p class="text-lg text-gray-300 mt-2">Hurry up! The offer is limited.</p>
            </div>
            <!-- Countdown Timer -->
            <div id="countdown" class="flex items-center gap-2 sm:gap-4 mt-6 lg:mt-0">
                <div class="text-center">
                    <div id="hours"
                        class="text-3xl sm:text-4xl font-bold bg-white text-gray-900 rounded-lg px-3 sm:px-4 py-2">00
                    </div>
                    <div class="text-xs sm:text-sm mt-2 uppercase">Hours</div>
                </div>
                <div class="text-3xl sm:text-4xl font-bold">:</div>
                <div class="text-center">
                    <div id="minutes"
                        class="text-3xl sm:text-4xl font-bold bg-white text-gray-900 rounded-lg px-3 sm:px-4 py-2">00
                    </div>
                    <div class="text-sm mt-2 uppercase">Minutes</div>
                </div>
                <div class="text-3xl sm:text-4xl font-bold">:</div>
                <div class="text-center">
                    <div id="seconds"
                        class="text-3xl sm:text-4xl font-bold bg-white text-gray-900 rounded-lg px-3 sm:px-4 py-2">00
                    </div>
                    <div class="text-sm mt-2 uppercase">Seconds</div>
                </div>
            </div>
        </div>

        <!-- Flash Sale Products -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {{-- For demonstration, we are taking 4 featured products. You should pass specific flash sale products from your controller. --}}
            @forelse($featuredProducts->take(4) as $product)
            <div class="bg-gray-800 rounded-xl border border-gray-700 overflow-hidden product-card-minimal">
                <a href="{{ route('products.show', $product->id) }}"
                    class="block bg-gray-700 flash-sale-image-container">
                    <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400x300' }}"
                        alt="{{ $product->product_name }}" class="w-full h-48 object-contain p-4">
                </a>
                <div class="p-5">
                    <h3 class="font-bold text-lg mb-2 truncate text-white" title="{{ $product->product_name }}">
                        {{ $product->product_name }}
                    </h3>
                    <div class="flex justify-between items-center">
                        <div>
                            @if ($product->discount_price)
                            <span
                                class="font-bold text-yellow-400 text-xl">৳{{ number_format($product->discount_price) }}</span>
                            <span
                                class="text-sm text-gray-400 line-through ml-2">৳{{ number_format($product->price) }}</span>
                            @else
                            <span
                                class="font-bold text-yellow-400 text-xl">৳{{ number_format($product->price) }}</span>
                            @endif
                        </div>
                        @if ($product->discount_price && $product->price > 0)
                        <div class="bg-red-100 text-red-800 text-xs font-bold px-2.5 py-1.5 rounded-full">
                            {{ round((($product->price - $product->discount_price) / $product->price) * 100) }}%
                            OFF
                        </div>
                        @else
                        <a href="{{ route('products.show', $product->id) }}"
                            class="bg-yellow-400 text-gray-900 w-10 h-10 rounded-full hover:bg-yellow-500 font-semibold transition duration-300 flex items-center justify-center"
                            title="View Product"><i class="fas fa-eye"></i></a>
                        @endif
                    </div>
                </div>
            </div>
            @empty
            <p class="text-gray-400 col-span-full text-center">No flash sale products available at the moment.</p>
            @endforelse
        </div>
    </div>
</section>

<!-- New Arrivals Section -->
<section class="py-16 px-4 bg-gray-50">
    <div class="container mx-auto max-w-7xl">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-800">New Arrivals</h2>
            <p class="text-xl text-blue-600 font-semibold mt-2">Discover the Latest Tech!</p>
            <p class="mt-4 text-gray-600 max-w-3xl mx-auto">
                Explore our brand-new collection of cutting-edge . Fresh arrivals, premium quality, and the
                newest innovations—shop now!
            </p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {{-- You should pass a $newArrivals variable from your controller. For now, we'll reuse featured products as an example. --}}
            @forelse($featuredProducts->take(4) as $product)
            <div
                class="bg-white rounded-2xl shadow-lg overflow-hidden group border border-gray-200 new-arrival-card">
                <a href="{{ route('products.show', $product->id) }}"
                    class="block bg-white p-4 overflow-hidden relative">
                    <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400x300' }}"
                        alt="{{ $product->product_name }}"
                        class="w-full h-48 object-contain group-hover:scale-110 transition-transform duration-500 ease-in-out">
                    <span
                        class="absolute top-3 left-3 bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full">NEW</span>
                </a>
                <div class="p-5 flex flex-col flex-grow">
                    <h3 class="font-bold text-lg mb-2 truncate group-hover:text-blue-600 transition-colors"
                        title="{{ $product->product_name }}">{{ $product->product_name }}</h3>
                    <div class="mt-auto">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                @if ($product->discount_price)
                                <span
                                    class="font-bold text-blue-600 text-xl">৳{{ number_format($product->discount_price) }}</span>
                                <span
                                    class="text-sm text-gray-500 line-through ml-2">৳{{ number_format($product->price) }}</span>
                                @else
                                <span
                                    class="font-bold text-blue-600 text-xl">৳{{ number_format($product->price) }}</span>
                                @endif
                            </div>
                            <div class="flex text-yellow-400 text-sm">
                                <i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                    class="fas fa-star"></i><i class="fas fa-star"></i><i
                                    class="far fa-star"></i>
                            </div>
                        </div>
                        @if ($product->discount_price && $product->price > 0)
                        <div class="w-full bg-red-100 text-red-800 font-bold py-2 px-4 rounded-lg text-center">
                            {{ round((($product->price - $product->discount_price) / $product->price) * 100) }}%
                            OFF
                        </div>
                        @else
                        <a href="{{ route('products.show', $product->id) }}"
                            class="w-full bg-blue-100 text-blue-800 font-bold py-2 px-4 rounded-lg hover:bg-blue-200 transition duration-300 text-center"
                            title="View Product"><i class="fas fa-eye mr-2"></i>View Details</a>
                        @endif
                    </div>
                </div>
            </div>
            @empty
            <p class="text-gray-500 col-span-full text-center">No new arrivals available at the moment.</p>
            @endforelse
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="py-16 px-4 bg-white">
    <div class="container mx-auto max-w-7xl">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-800">What Our Customers Say</h2>
            <p class="text-lg text-gray-500 mt-2">Real stories from satisfied customers.</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Testimonial 1 -->
            <div class="bg-gray-50 rounded-2xl p-8 testimonial-card border border-gray-200">
                <div class="flex items-center mb-4">
                    <img src="https://randomuser.me/api/portraits/men/32.jpg" alt="User Avatar"
                        class="w-12 h-12 rounded-full mr-4">
                    <div>
                        <p class="font-bold text-gray-800">Rahim Islam</p>
                        <div class="flex text-yellow-400 text-sm">
                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                class="fas fa-star"></i><i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
                <p class="text-gray-600">"Excellent service! I verified my phone and it was 100% authentic. The
                    delivery was super fast too. Highly recommended."</p>
            </div>

            <!-- Testimonial 2 -->
            <div class="bg-gray-50 rounded-2xl p-8 testimonial-card border border-gray-200">
                <div class="flex items-center mb-4">
                    <img src="https://randomuser.me/api/portraits/women/44.jpg" alt="User Avatar"
                        class="w-12 h-12 rounded-full mr-4">
                    <div>
                        <p class="font-bold text-gray-800">Fatima Akter</p>
                        <div class="flex text-yellow-400 text-sm">
                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                class="fas fa-star"></i><i class="fas fa-star-half-alt"></i>
                        </div>
                    </div>
                </div>
                <p class="text-gray-600">"Great collection of phones. The flash sale price was unbelievable. I got a
                    genuine product at a great discount."</p>
            </div>

            <!-- Testimonial 3 -->
            <div class="bg-gray-50 rounded-2xl p-8 testimonial-card border border-gray-200">
                <div class="flex items-center mb-4">
                    <img src="https://randomuser.me/api/portraits/men/56.jpg" alt="User Avatar"
                        class="w-12 h-12 rounded-full mr-4">
                    <div>
                        <p class="font-bold text-gray-800">Jamal Uddin</p>
                        <div class="flex text-yellow-400 text-sm">
                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                class="fas fa-star"></i><i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
                <p class="text-gray-600">"The product verification system is a game-changer. It gives so much peace of
                    mind. Will definitely shop here again."</p>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Subscription Section -->
<section class="py-16 px-4 bg-gray-600">
    <div class="container mx-auto max-w-4xl text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white">Stay Updated!</h2>
        <p class="text-lg text-blue-100 mt-2 mb-8">Subscribe to our newsletter to get the latest news, updates, and
            special offers.</p>
        <form action="#" method="POST" class="max-w-lg mx-auto">
            @csrf
            <div class="relative group">
                <input type="email" name="email" placeholder="Enter your email address..."
                    class="w-full bg-white border-2 border-transparent rounded-full py-4 pl-6 pr-40 text-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-400 transition-all"
                    required>
                <button type="submit"
                    class="absolute inset-y-0 right-0 flex items-center justify-center bg-blue-600 hover:bg-gray-800 text-white font-bold px-8 rounded-full m-2 transition-all duration-300 transform group-hover:scale-105">
                    <i class="fas fa-paper-plane sm:mr-2"></i>
                    <span class="hidden sm:inline">Subscribe</span>
                </button>
            </div>
        </form>
    </div>
</section>

<!-- Banner and Content Section from your request -->
<section class="grid grid-cols-1 mx-auto container max-w-7xl md:grid-cols-2 2xl:grid-cols-3 gap-6 mt-6 py-12 px-4">
    <!-- Content Block 1 -->
    <div class="accent-1 p-6 bg-gray-300 rounded-2xl shadow-md">
        <h1 class="text-xl text-gray-900 font-bold mb-3">Bangladesh’s Trusted Tech E-Commerce Store for Phones, Accessories</h1>
        <div class="text-base text-gray-700 leading-relaxed">
            In Bangladesh, NewTech has emerged as the premier source for genuine and accessories. We provide you with reliable brands all in one place, from the newest iPhones and iPads to robust MacBooks and wearables. Essentials like docks, hubs, safety gear, and stylus pens are also available. We always strive to provide you with excellent service, prompt delivery, and authentic products, whether you shop online or in-store. Our collection fits every lifestyle, whether you're a student, tech enthusiast, or regular user. Additionally, our customer care representatives are available at all times to help you with warranty inquiries, product selections, and post-purchase assistance.
        </div>
    </div>

    <!-- Swiper Slider -->
    <div class="rounded-2xl overflow-hidden shadow-md md:col-span-2 2xl:col-span-1 h-80 md:h-full">
        <div class="swiper mySwiper h-full" aria-label="Content Slider" aria-roledescription="carousel">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <figure class="relative w-full h-full">
                        <img alt="content-image-1" loading="lazy" decoding="async"
                            class="w-full h-full object-cover"
                            src="{{ asset('frontend/assets/images/banner/banner-1.png') }}"
                            sizes="(min-width: 1200px) 100vw, 50vw">
                    </figure>
                </div>
                <div class="swiper-slide">
                    <figure class="relative w-full h-full">
                        <img alt="content-image-2" loading="lazy" decoding="async"
                            class="w-full h-full object-cover"
                            src="{{ asset('frontend/assets/images/banner/banner-2.png') }}"
                            sizes="(min-width: 1200px) 100vw, 50vw">
                    </figure>
                </div>
            </div>
            <!-- Navigation -->
            <div class="swiper-button-prev !text-white after:!text-lg"></div>
            <div class="swiper-button-next !text-white after:!text-lg"></div>
            <!-- Pagination -->
            <div class="swiper-pagination !bottom-4"></div>
        </div>
    </div>

    <!-- Content Block 2 -->
    <div class="accent-3 p-6 bg-sky-200 rounded-2xl shadow-md">
        <h2 class="text-xl text-gray-900 font-bold mb-3">Smartphones & Tablets from Apple, Samsung, Xiaomi, OnePlus & More</h2>
        <div class="text-base text-gray-700 leading-relaxed">
            Looking for a reliable smartphone or tablet? We bring you a rich lineup of the most trusted brands including Apple, Samsung, Xiaomi, OnePlus, and more. From flagship powerhouses to value-packed models, you can pick based on your needs and budget. You’ll also find the latest Galaxy Tabs and iPads for work, study, or entertainment. All our phones and tablets come with guaranteed authenticity and after-sales support. If you are planning to upgrade your main device or add a secondary one, we make sure your shopping experience is smooth, safe, and satisfying. Enjoy the latest models at competitive prices, both online and in-store.
        </div>
    </div>

    <!-- Content Block 3 -->
    <div class="accent-4 p-6 bg-[#e3f2d5] rounded-2xl shadow-md">
        <h2 class="text-xl text-gray-900 font-bold mb-3">Mobile Accessories You Can Rely On — Cables, Cases, Power Banks</h2>
        <div class="text-base text-gray-700 leading-relaxed"> The right accessories make your tech life easier. At NewTech, we offer a complete range of reliable accessories like fast-charging cables, durable power banks, magnetic wireless chargers, docks, and more. We also have high-quality phone covers and screen protectors to keep your device safe. Need a stylus or an adapter for your MacBook? You’ll find that too. Our accessories are selected for both quality and compatibility, so they work exactly how you need them to. Whether you're replacing an old charger or buying your first wireless power bank, we’ve got the right tool for the job.
        </div>
    </div>

    <!-- Content Block 4 -->
    <div class="accent-5 p-6 bg-[#6f855b9a] rounded-2xl shadow-md 2xl:order-last">
        <h2 class="text-xl text-gray-900 font-bold mb-3">Smartwatches & Fitness Bands from Reliable Brands</h2>
        <div class="text-base text-gray-700 leading-relaxed">
            Smartwatches are more than just timekeepers now; they’re your health tracker, workout buddy, and personal assistant. At NewTech, we offer a wide range of options like Apple Watch, Huawei Watch, Xiaomi bands, and other popular picks that blend design with daily usefulness. Check messages, track your steps, monitor heart rate, or just match your outfit. We bring you original wearables that work smoothly and last long, backed with proper support and quick delivery.
        </div>
    </div>

    <!-- Content Block 5 -->
    <div class="accent-6 p-6 bg-[#5b679c9a] rounded-2xl shadow-md">
        <h2 class="text-xl text-gray-900 font-bold mb-3">AirPods, Wireless Earbuds & Premium Audio Devices</h2>
        <div class="text-base text-gray-700 leading-relaxed">
            Music should sound rich, clear, and uninterrupted. That’s what we aim for with our collection of audio gear. From original Apple AirPods to noise-cancelling earbuds, studio-quality over-ear headphones, and pocket-size Bluetooth speakers, we’ve got something for every listener. When you’re tuning in during a commute or zoning out at home, our devices bring sound to life. All products are tested, original, and tuned to give you that crisp, satisfying audio experience every time.
        </div>
    </div>
</section>


<!-- Brands Section -->
<section class="py-12 px-4 bg-gray-50">
    <div class="container mx-auto max-w-7xl">
        <h2 class="text-center text-2xl font-bold text-gray-800 mb-8">Shop by Brand</h2>

        <div class="relative overflow-hidden">
            <div class="flex animate-scroll">
                @php
                $brands = [
                [
                'name' => 'Samsung',
                'logo' => asset('frontend/assets/images/brand/Samsung-Logo.png'),
                'height' => 'h-10',
                ],
                [
                'name' => 'Apple',
                'logo' => asset('frontend/assets/images/brand/Apple-Logo.png'),
                'height' => 'h-10',
                ],
                [
                'name' => 'Xiaomi',
                'logo' => asset('frontend/assets/images/brand/Xiaomi-Logo.png'),
                'height' => 'h-10',
                ],
                [
                'name' => 'Nokia',
                'logo' => asset('frontend/assets/images/brand/Nokia-Logo.png'),
                'height' => 'h-10',
                ],
                [
                'name' => 'Oppo',
                'logo' => asset('frontend/assets/images/brand/Oppo-Logo.png'),
                'height' => 'h-10',
                ],
                [
                'name' => 'Vivo',
                'logo' => asset('frontend/assets/images/brand/Vivo-Logo.png'),
                'height' => 'h-10',
                ],
                [
                'name' => 'OnePlus',
                'logo' => asset('frontend/assets/images/brand/OnePlus-Logo.png'),
                'height' => 'h-10',
                ],
                ];
                $allBrands = array_merge($brands, $brands); // repeat for infinite effect
                @endphp

                @foreach ($allBrands as $brand)
                <a href="{{ route('products.index', ['brands[]' => $brand['name']]) }}"
                    class="flex-shrink-0 w-48 h-24 flex items-center justify-center bg-white p-4 rounded-2xl shadow-sm border border-gray-200 hover:shadow-lg hover:border-blue-300 transition-all duration-300">
                    <img src="{{ $brand['logo'] }}" alt="{{ $brand['name'] }}" class="max-h-20 object-contain">
                </a>
                @endforeach
            </div>
        </div>
    </div>

    <style>
        @keyframes scroll {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-50%);
            }
        }

        .animate-scroll {
            display: flex;
            width: calc(12rem * 14 + 13 * 2rem);
            /* (card_width * num_cards) + (gap * (num_cards - 1)) */
            gap: 2rem;
            /* Add gap between items */
            animation: scroll 30s linear infinite;
        }

        .animate-scroll:hover {
            animation-play-state: paused;
            /* pause on hover */
        }
    </style>
</section>


<!-- Categories Section -->
<section class="py-16 px-4 bg-gray-50">
    <div class="container mx-auto max-w-7xl">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-800">Explore Our Categories</h2>
            <p class="text-lg text-gray-500 mt-2">Find what you're looking for, faster.</p>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4  xl:grid-cols-3 gap-6">
            @forelse($categories as $category)
            <a href="{{ route('products.index', ['category' => $category->slug]) }}"
                class="relative bg-white rounded-2xl p-6 text-center border border-gray-200 overflow-hidden group category-card-new">
                <div class="absolute inset-0 bg-gradient-to-br from-blue-500 to-indigo-600 opacity-0 group-hover:opacity-100 transition-opacity duration-300 rounded-2xl transform scale-105 category-bg-shape">
                </div>
                <div class="relative z-10 flex flex-col items-center">
                    <div
                        class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mb-4 transition-all duration-300 group-hover:bg-white group-hover:scale-110 group-hover:shadow-lg">
                        <i
                            class="{{ $category->icon }} text-4xl text-blue-600 transition-colors duration-300 group-hover:text-indigo-600"></i>
                    </div>
                    <h3
                        class="font-bold text-lg text-gray-800 transition-colors duration-300 group-hover:text-blue-600 truncate">
                        {{ $category->name }}
                    </h3>
                    @php
                    // Sum the parent's own product count with the counts of all its children.
                    $productCount = $category->products_count + $category->children->sum('products_count');
                    @endphp
                    <p class="text-gray-500 text-sm mt-1 transition-colors duration-300 group-hover:text-blue-600">
                        {{ $productCount }} products
                    </p>
                </div>
            </a>
            @empty
            <p class="text-gray-500 col-span-full text-center">No categories found.</p>
            @endforelse
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Modern Hero Carousel Logic
        const track = document.getElementById('carousel-track');
        if (track) {
            const slides = Array.from(track.children);
            const nextButton = document.getElementById('next-btn');
            const prevButton = document.getElementById('prev-btn');
            const dotsNav = document.querySelector('.carousel-nav');
            const dots = dotsNav ? Array.from(dotsNav.children) : [];
            const slideWidth = slides[0].getBoundingClientRect().width;
            let currentIndex = 0;
            let autoPlayInterval;

            const moveToSlide = (targetIndex) => {
                track.style.transform = 'translateX(-' + slideWidth * targetIndex + 'px)';
                currentIndex = targetIndex;
                updateDots(targetIndex);
            };

            const updateDots = (targetIndex) => {
                if (!dotsNav) return;
                const currentDot = dotsNav.querySelector('.active');
                if (currentDot) {
                    currentDot.classList.remove('active');
                }
                dots[targetIndex].classList.add('active');
            };

            nextButton.addEventListener('click', () => {
                const nextIndex = (currentIndex + 1) % slides.length;
                moveToSlide(nextIndex);
                resetAutoPlay();
            });

            prevButton.addEventListener('click', () => {
                const prevIndex = (currentIndex - 1 + slides.length) % slides.length;
                moveToSlide(prevIndex);
                resetAutoPlay();
            });

            if (dotsNav) {
                dotsNav.addEventListener('click', e => {
                    const targetDot = e.target.closest('button');
                    if (!targetDot) return;

                    const targetIndex = dots.findIndex(dot => dot === targetDot);
                    moveToSlide(targetIndex);
                    resetAutoPlay();
                });
            }

            const startAutoPlay = () => {
                autoPlayInterval = setInterval(() => {
                    const nextIndex = (currentIndex + 1) % slides.length;
                    moveToSlide(nextIndex);
                }, 5000); // Change slide every 5 seconds
            };

            const resetAutoPlay = () => {
                clearInterval(autoPlayInterval);
                startAutoPlay();
            };

            startAutoPlay();
        }

        // Swiper Initialization
        new Swiper(".mySwiper", {
            loop: true,
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
        });

        // Countdown Timer Logic
        // This should be replaced with a dynamic end time from your backend
        const countdown = () => {
            // ... (Your existing countdown logic from main.js can be placed here or kept in main.js)
            // For now, assuming it's in main.js which is now loaded via Vite
        };
        countdown();
    });
</script>
@endpush
