@if($products->count() > 0)
    @foreach($products as $product)
        <div class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-500 group border border-gray-100 product-card">
            <!-- Product Image -->
            <div class="h-52 bg-gradient-to-br from-blue-50 via-purple-50 to-pink-50 flex items-center justify-center relative overflow-hidden">
                @if($product->image)
                    <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->product_name }}"
                         class="h-full w-full object-cover group-hover:scale-110 transition-transform duration-700">
                @else
                    <div class="text-center">
                        <i class="fas fa-mobile-alt text-6xl text-gray-300 group-hover:text-blue-400 transition-colors duration-300"></i>
                        <p class="text-gray-400 text-sm mt-2">No Image</p>
                    </div>
                @endif

                <!-- Product Badges -->
                <div class="absolute top-4 left-4 flex flex-col gap-2">
                    @if($product->is_new)
                        <span class="product-badge-new">NEW</span>
                    @endif
                    @if($product->discount_price)
                        <span class="product-badge-sale">
                            SAVE {{ number_format(($product->price - $product->discount_price) / $product->price * 100) }}%
                        </span>
                    @endif
                </div>

                <!-- Quick Actions -->
                <div class="absolute top-4 right-4 flex flex-col gap-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                    <button class="add-to-wishlist w-8 h-8 bg-white rounded-full shadow-md flex items-center justify-center hover:bg-blue-500 hover:text-white transition-colors duration-200"
                            data-tooltip="Add to Wishlist"
                            data-product-id="{{ $product->id }}">
                        <i class="fas fa-heart text-xs"></i>
                    </button>
                    <button @click="$dispatch('open-quick-view', { id: {{ $product->id }} })"
                            class="w-8 h-8 bg-white rounded-full shadow-md flex items-center justify-center hover:bg-blue-500 hover:text-white transition-colors duration-200"
                            data-tooltip="Quick View" >
                        <i class="fas fa-eye text-xs"></i>
                    </button>
                </div>
            </div>

            <!-- Product Info -->
            <div class="p-6">
                <div class="flex justify-between items-start mb-3">
                    <h3 class="font-bold text-lg text-gray-900 group-hover:text-blue-600 transition-colors duration-300 truncate flex-1 mr-3">
                        {{ $product->product_name }}
                    </h3>
                    <div class="flex-shrink-0">
                        @if($product->is_new)
                            <span class="status-badge-new">New Arrival</span>
                        @elseif($product->discount_price)
                            <span class="status-badge-sale">On Sale</span>
                        @endif
                    </div>
                </div>

                <p class="text-gray-600 text-sm mb-4 line-clamp-2 leading-relaxed">
                    {{ Str::limit($product->description, 80) }}
                </p>

                <!-- Rating and Reviews -->
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-2">
                        <div class="flex text-yellow-400">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= ($product->rating ?? 4))
                                    <i class="fas fa-star text-sm"></i>
                                @else
                                    <i class="far fa-star text-sm"></i>
                                @endif
                            @endfor
                        </div>
                        <span class="text-gray-500 text-sm">({{ $product->reviews_count ?? 0 }})</span>
                    </div>
                    <div @class([
                        'text-xs px-2 py-1 rounded',
                        'bg-green-100 text-green-800' => $product->in_stock,
                        'bg-red-100 text-red-800' => !$product->in_stock,
                    ])>
                        {{ $product->in_stock ? 'In Stock' : 'Out of Stock' }}
                    </div>
                </div>

                <!-- Price and Action -->
                <div class="flex justify-between items-center pt-4 border-t border-gray-100">
                    <div class="flex flex-col">
                        @if($product->discount_price)
                            <span class="font-bold text-2xl text-green-600">৳{{ number_format($product->discount_price) }}</span>
                            <span class="text-gray-400 line-through text-sm">৳{{ number_format($product->price) }}</span>
                        @else
                            <span class="font-bold text-2xl text-gray-900">৳{{ number_format($product->price) }}</span>
                        @endif
                    </div>
                    <button class="v-btn v-btn-primary add-to-cart-btn add-to-cart"
                            data-product-id="{{ $product->id }}"
                            data-tooltip="Add to Cart">
                        <i class="fas fa-shopping-cart mr-2"></i>
                        Add to Cart
                    </button>
                </div>
            </div>
        </div>
    @endforeach
@else
    <div class="text-center py-16 bg-white rounded-2xl shadow-lg border border-gray-100 md:col-span-2 xl:col-span-3">
        <div class="max-w-md mx-auto">
            <div class="w-24 h-24 bg-gradient-to-br from-blue-100 to-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-search text-3xl text-blue-500"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-3">No products found</h3>
            <p class="text-gray-600 mb-8">We couldn't find any products matching your criteria. Try adjusting your filters or search terms.</p>
            <button class="v-btn v-btn-primary" id="clear-all-filters">
                <i class="fas fa-times mr-2"></i>
                Clear All Filters
            </button>
        </div>
    </div>
@endif
