<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', config('app.name'))</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100 flex flex-col justify-center py-12 sm:px-6 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-4xl">
            <div class="lg:grid lg:grid-cols-2 lg:gap-16 items-center">
                <!-- Left Column: Branding -->
                <div class="text-center lg:text-left px-4 lg:px-0">
                    <h1 class="text-5xl font-bold text-blue-600">{{ config('app.name', 'Laravel') }}</h1>
                    <p class="mt-4 text-2xl text-gray-700">
                        Connect with friends and the world around you on {{ config('app.name', 'Laravel') }}.
                    </p>
                </div>

                <!-- Right Column: Form Slot -->
                <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
                    {{ $slot }}
                </div>
            </div>
        </div>
    </div>
</body>
</html>
