@php
    $currentRoute = request()->route()->getName();
@endphp

<div
    x-data="{
        sidebarOpen: window.innerWidth >= 1024,
        dropdownOpen: false
    }"
    x-init="
        window.addEventListener('resize', () => {
            sidebarOpen = window.innerWidth >= 1024
        })
    "
    class="flex min-h-screen"
>
    <!-- Sidebar Backdrop (for mobile) -->
    <div
        x-show="sidebarOpen && window.innerWidth < 1024"
        x-transition:enter="transition-opacity ease-linear duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition-opacity ease-linear duration-300"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="fixed inset-0 z-20 bg-gray-900 bg-opacity-50 lg:hidden"
        @click="sidebarOpen = false"
    ></div>

    <!-- Sidebar for authenticated users -->
    @auth
    <aside
        class="fixed inset-y-0 left-0 z-30 w-64 px-4 py-7 overflow-y-auto bg-white sidebar-shadow sidebar-transition lg:translate-x-0 lg:static lg:inset-0"
        :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'"
    >
        <div class="flex items-center justify-between px-2 mb-8">
            <a href="{{ route('home') }}" class="flex items-center space-x-2">
                <div class="flex items-center justify-center w-10 h-10 bg-blue-600 rounded-lg">
                    <span class="text-xl font-bold text-white">I</span>
                </div>
                <span class="text-2xl font-bold text-gray-800">{{ config('app.name', 'Intech') }}</span>
            </a>
            <!-- Close button for mobile -->
            <button
                class="p-1 text-gray-500 rounded-lg lg:hidden hover:bg-gray-100"
                @click="sidebarOpen = false"
            >
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>

        <nav class="mt-4">
            <h3 class="px-3 text-xs font-semibold tracking-wider text-gray-500 uppercase">Main Menu</h3>
            <div class="mt-2 space-y-1">
                <a href="{{ route('dashboard') }}" class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item {{ $currentRoute == 'dashboard' ? 'active-menu-item' : '' }}">
                    <i class="w-5 h-5 text-blue-600 fas fa-tachometer-alt"></i>
                    <span class="mx-3 font-medium">Dashboard</span>
                </a>
                @if(auth()->check() && auth()->user()->isAdmin())
                    <a href="{{ route('admin.scanner.index') }}" class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item {{ str_starts_with($currentRoute, 'admin.scanner.') ? 'active-menu-item' : '' }}">
                        <i class="w-5 h-5 text-blue-600 fas fa-barcode"></i>
                        <span class="mx-3 font-medium">Scanner</span>
                    </a>
                @else
                    <a href="{{ route('verify') }}" class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item {{ $currentRoute == 'verify' ? 'active-menu-item' : '' }}">
                        <i class="w-5 h-5 text-blue-600 fas fa-shield-alt"></i>
                        <span class="mx-3 font-medium">Verify Product</span>
                    </a>
                @endif
            </div>

            @if(auth()->check() && auth()->user()->isAdmin())
            <h3 class="px-3 mt-6 text-xs font-semibold tracking-wider text-gray-500 uppercase">Admin</h3>
            <div class="mt-2 space-y-1">
                <a href="{{ route('admin.dashboard') }}" class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item {{ $currentRoute == 'admin.dashboard' ? 'active-menu-item' : '' }}">
                    <i class="w-5 h-5 text-blue-600 fas fa-user-shield"></i>
                    <span class="mx-3 font-medium">Admin Dashboard</span>
                </a>
                <a href="{{ route('admin.products') }}" class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item {{ $currentRoute == 'admin.products' ? 'active-menu-item' : '' }}">
                    <i class="w-5 h-5 text-blue-600 fas fa-cogs"></i>
                    <span class="mx-3 font-medium">Manage Products</span>
                </a>
            </div>
            @endif

            <h3 class="px-3 mt-6 text-xs font-semibold tracking-wider text-gray-500 uppercase">Account</h3>
            <div class="mt-2 space-y-1">
                <a href="{{ route('profile.edit') }}" class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item {{ $currentRoute == 'profile.edit' ? 'active-menu-item' : '' }}">
                    <i class="w-5 h-5 text-blue-600 fas fa-user-circle"></i>
                    <span class="mx-3 font-medium">Profile</span>
                </a>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <a href="{{ route('logout') }}"
                       onclick="event.preventDefault(); this.closest('form').submit();"
                       class="flex items-center px-3 py-3 text-gray-700 rounded-lg menu-item">
                        <i class="w-5 h-5 text-blue-600 fas fa-sign-out-alt"></i>
                        <span class="mx-3 font-medium">Logout</span>
                    </a>
                </form>
            </div>
        </nav>
    </aside>
    @endauth

    <!-- Main Content Area -->
    <div class="flex-1 flex flex-col min-h-screen overflow-hidden">
        <!-- Top Navigation Bar -->
        <header class="bg-white shadow">
            <div class="flex items-center justify-between px-4 py-4 sm:px-6 lg:px-8">
                <div class="flex items-center">
                    <!-- Mobile menu button -->
                    @auth
                    <button
                        @click="sidebarOpen = !sidebarOpen"
                        class="p-2 text-gray-500 rounded-lg lg:hidden hover:bg-gray-100"
                    >
                        <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none">
                            <path d="M4 6H20M4 12H20M4 18H11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </button>
                    @endauth

                    <!-- Page Heading -->
                    <div class="{{ auth()->check() ? 'ml-4' : '' }}">
                        <h1 class="text-2xl font-semibold text-gray-900">
                            @hasSection('header')
                                @yield('header')
                            @else
                                <a href="{{ route('home') }}" class="transition-colors">@yield('header', 'NewTechMobile')</a>
                            @endif
                        </h1>
                        @hasSection('subheader')
                            <p class="text-sm text-gray-500">@yield('subheader')</p>
                        @endif
                    </div>
                </div>

                <!-- User Menu -->
                <div class="flex items-center space-x-4">
                    @auth
                        <!-- Notifications -->
                        <button class="relative p-2 text-gray-500 rounded-lg hover:bg-gray-100">
                            <i class="text-lg fas fa-bell"></i>
                            <span class="absolute top-0 right-0 flex w-3 h-3 -mt-1 -mr-1">
                                <span class="absolute inline-flex w-full h-full bg-red-400 rounded-full opacity-75 animate-ping"></span>
                                <span class="relative inline-flex w-3 h-3 bg-red-500 rounded-full"></span>
                            </span>
                        </button>

                        <!-- User dropdown -->
                        <div x-data="{ dropdownOpen: false }" class="relative">
                            <button
                                @click="dropdownOpen = !dropdownOpen"
                                class="flex items-center space-x-2 text-gray-700 focus:outline-none"
                            >
                                <div class="w-8 h-8 user-avatar rounded-full">
                                    <span>{{ strtoupper(substr(auth()->user()->name, 0, 1)) }}</span>
                                </div>
                                <span class="hidden md:block font-medium">{{ auth()->user()->name }}</span>
                                <i class="text-gray-400 fas fa-chevron-down"></i>
                            </button>

                            <div
                                x-show="dropdownOpen"
                                @click.away="dropdownOpen = false"
                                class="absolute right-0 w-48 mt-2 overflow-hidden bg-white rounded-lg shadow-lg z-10"
                                style="display: none;"
                            >
                                <a href="{{ route('profile.edit') }}" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-100">
                                    <i class="w-4 h-4 mr-3 text-gray-500 fas fa-user-circle"></i>
                                    Profile
                                </a>
                                <div class="border-t border-gray-100"></div>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <a href="{{ route('logout') }}"
                                       onclick="event.preventDefault(); this.closest('form').submit();"
                                       class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="w-4 h-4 mr-3 text-gray-500 fas fa-sign-out-alt"></i>
                                        Logout
                                    </a>
                                </form>
                            </div>
                        </div>
                    @endauth

                    @guest
                        <div class="flex items-center space-x-4">
                            <a href="{{ route('login') }}" class="text-sm font-medium text-gray-600 hover:text-gray-900">
                                Log in
                            </a>
                            <a href="{{ route('register') }}" class="text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 px-4 py-2 rounded-md transition-colors">
                                Register
                            </a>
                        </div>
                    @endguest
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100">
            <div class="container mx-auto px-4 py-6 sm:px-6 lg:px-8">
                @if (isset($slot) && trim($slot) !== '')
                    {{ $slot }}
                @else
                    @yield('content')
                @endif
            </div>
        </main>
    </div>
</div>
