@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-gradient-to-r from-blue-600 to-purple-700 px-6 py-4">
            <h1 class="text-2xl font-bold text-white flex items-center"><i class="fas fa-boxes-stacked mr-3"></i>Product Information</h1>
            <p class="text-blue-100 mt-1">Click on dropdowns to change values</p>
        </div>

        <!-- Search and Filter Section -->
        <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
            <form method="GET" action="{{ route('products') }}" class="flex flex-col md:flex-row gap-4">
                <div class="relative flex-grow">
                    <input type="text" name="search" value="{{ $search }}" placeholder="Search products..."
                           class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                </div>
                <div class="flex flex-col sm:flex-row gap-2">
                    <select name="quality" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Qualities</option>
                        <option value="Authentic" {{ $quality == 'Authentic' ? 'selected' : '' }}>Authentic</option>
                        <option value="Premium" {{ $quality == 'Premium' ? 'selected' : '' }}>Premium</option>
                        <option value="Standard" {{ $quality == 'Standard' ? 'selected' : '' }}>Standard</option>
                    </select>
                    <select name="color" class="bg-white px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Colors</option>
                        <option value="Blue Ae" {{ $color == 'Blue Ae' ? 'selected' : '' }}>Blue Ae</option>
                        <option value="White" {{ $color == 'White' ? 'selected' : '' }}>White</option>
                        <option value="Black" {{ $color == 'Black' ? 'selected' : '' }}>Black</option>
                    </select>
                    <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors"><i class="fas fa-filter mr-2"></i>Filter</button>
                </div>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr class="text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        <th class="px-6 py-3"><i class="fas fa-hashtag mr-1"></i>#</th>
                        <th class="px-6 py-3"><i class="fas fa-barcode mr-1"></i>Serial No</th>
                        <th class="px-6 py-3"><i class="fas fa-box mr-1"></i>Product Name</th>
                        <th class="px-6 py-3"><i class="fas fa-heart-pulse mr-1"></i>Condition</th>
                        <th class="px-6 py-3"><i class="fas fa-truck-fast mr-1"></i>Status</th>
                        <th class="px-6 py-3"><i class="fas fa-star mr-1"></i>Quality</th>
                        <th class="px-6 py-3"><i class="fas fa-mobile-screen-button mr-1"></i>IMEI</th>
                        <th class="px-6 py-3"><i class="fas fa-palette mr-1"></i>Color</th>
                        <th class="px-6 py-3"><i class="fas fa-building mr-1"></i>Distributor</th>
                        <th class="px-6 py-3"><i class="fas fa-store mr-1"></i>Retailer</th>
                        <th class="px-6 py-3"><i class="fas fa-user mr-1"></i>Client</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($products as $product)
                    @php
                        $statusColor = match($product->status) {
                            'In Warehouse' => 'bg-blue-100 text-blue-800',
                            'Shipped' => 'bg-yellow-100 text-yellow-800',
                            'Delivered' => 'bg-green-100 text-green-800',
                            default => 'bg-gray-100 text-gray-800',
                        };
                    @endphp
                    <tr class="hover:bg-gray-50 transition-shadow duration-200 hover:shadow-md">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $loop->iteration }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono">{{ $product->serial_no }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div class="dropdown-btn" onclick="toggleDropdown('product-name-dropdown-{{ $loop->iteration }}')">
                                    <span>{{ $product->product_name }}</span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="product-name-dropdown-{{ $loop->iteration }}" class="dropdown-content">
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'product_name', 'Nokia 105 (2023) +')">Nokia 105 (2023) +</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'product_name', 'Nokia 105 (2022) +')">Nokia 105 (2022) +</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'product_name', 'Nokia 210')">Nokia 210</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'product_name', 'Nokia 5310')">Nokia 5310</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $product->condition }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusColor }}">
                                {{ $product->status }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div class="dropdown-btn" onclick="toggleDropdown('quality-dropdown-{{ $loop->iteration }}')">
                                    <span>{{ $product->quality }}</span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="quality-dropdown-{{ $loop->iteration }}" class="dropdown-content">
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'quality', 'Authentic')">Authentic</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'quality', 'Premium')">Premium</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'quality', 'Standard')">Standard</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'quality', 'Economy')">Economy</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono">{{ $product->imei }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div class="dropdown">
                                <div class="dropdown-btn" onclick="toggleDropdown('color-dropdown-{{ $loop->iteration }}')">
                                    <span>{{ $product->color }}</span>
                                    <i class="fas fa-chevron-down text-xs ml-1"></i>
                                </div>
                                <div id="color-dropdown-{{ $loop->iteration }}" class="dropdown-content">
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'color', 'Blue Ae')">Blue Ae</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'color', 'White')">White</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'color', 'Black')">Black</a>
                                    <a onclick="updateProductField({{ $loop->iteration }}, 'color', 'Red')">Red</a>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $product->distributor_name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $product->retailer_name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $product->client_name }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="bg-gray-50 px-6 py-3 flex items-center justify-between border-t border-gray-200">
            <div class="text-sm text-gray-700">
                Showing <span class="font-medium">{{ $products->firstItem() }}</span> to <span class="font-medium">{{ $products->lastItem() }}</span> of <span class="font-medium">{{ $products->total() }}</span> results
            </div>
            <div class="flex space-x-2">
                @if($products->onFirstPage())
                    <span class="px-4 py-2 text-sm bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed">Previous</span>
                @else
                    <a href="{{ $products->previousPageUrl() . '&' . http_build_query(request()->except('page')) }}" class="px-4 py-2 text-sm bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">Previous</a>
                @endif

                @if($products->hasMorePages())
                    <a href="{{ $products->nextPageUrl() . '&' . http_build_query(request()->except('page')) }}" class="px-4 py-2 text-sm bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">Next</a>
                @else
                    <span class="px-4 py-2 text-sm bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed">Next</span>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
