<?php

use App\Http\Controllers\PageController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ScannerController;
use App\Http\Controllers\Frontend\CartController;
use App\Http\Controllers\Frontend\WishlistController;
use Illuminate\Support\Facades\Route;

// ==================== FRONTEND/PUBLIC ROUTES ====================
Route::get('/', [PageController::class, 'home'])->name('home');
Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');
Route::get('/customer-service', [PageController::class, 'customerService'])->name('customer-service');

// Product verification and public actions
Route::get('/products', [ProductController::class, 'index'])->name('products.index');
Route::get('/products/{product}', [ProductController::class, 'show'])->name('products.show');
Route::get('/products/quick-view/{product}', [ProductController::class, 'quickView'])->name('products.quickView');
Route::get('/verify', [ProductController::class, 'showVerifyForm'])->name('verify');
Route::post('/verify', [ProductController::class, 'handleVerification'])->name('products.verify.post');
Route::get('/verify/{serial_no}', [ProductController::class, 'showVerifiedProduct'])->name('products.verified');
Route::get('/products/{id}/report', [ProductController::class, 'generateReport'])->name('products.report');
Route::get('/sticker-print', [ProductController::class, 'stickerPrint'])->name('sticker.print');


// ==================== AUTHENTICATION ROUTES ====================
require __DIR__.'/auth.php';

// ==================== PROTECTED ROUTES (Login Required) ====================
Route::middleware(['auth'])->group(function () {
    // User Dashboard
    Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');

    // Profile Management
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Wishlist Routes (Authenticated Users)
    Route::get('/wishlist', [WishlistController::class, 'index'])->name('wishlist.index');
    Route::post('/wishlist/add/{product}', [WishlistController::class, 'add'])->name('wishlist.add');
    Route::post('/wishlist/remove/{product}', [WishlistController::class, 'remove'])->name('wishlist.remove');
    Route::get('/wishlist/count', [WishlistController::class, 'count'])->name('wishlist.count');

});

// ==================== ADMIN ONLY ROUTES ====================
Route::middleware(['auth', \App\Http\Middleware\AdminMiddleware::class])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');
    Route::get('/products', [ProductController::class, 'adminIndex'])->name('products');
    Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('products.edit');
    Route::post('/products', [ProductController::class, 'store'])->name('products.store');
    Route::put('/products/{product}', [ProductController::class, 'update'])->name('products.update');
    Route::delete('/products/{id}', [ProductController::class, 'destroy'])->name('products.delete');

    // Scanner Functionality (Admin Only)
    Route::prefix('scanner')->name('scanner.')->group(function () {
        Route::get('/', [ScannerController::class, 'index'])->name('index');
        Route::get('/bulk', [ScannerController::class, 'bulkScanPage'])->name('bulk');
        Route::post('/scan', [ScannerController::class, 'scan'])->name('scan');
        Route::get('/search', [ScannerController::class, 'search'])->name('search');
        // ... other scanner routes
    });
});

// Cart Routes
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::post('/cart/add/{product}', [CartController::class, 'add'])->name('cart.add');
Route::get('/cart/add/{product}', [CartController::class, 'add'])->name('cart.add.another');
Route::post('/cart/update', [CartController::class, 'update'])->name('cart.update');
Route::post('/cart/remove', [CartController::class, 'remove'])->name('cart.remove');
Route::post('/cart/clear', [CartController::class, 'clear'])->name('cart.clear');

// ==================== API ROUTES ====================
require __DIR__.'/api.php';
