<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('header', 'Admin Dashboard'); ?>
    <?php $__env->startSection('subheader', 'Welcome to admin panel'); ?>

    <!-- Welcome Message -->
    <div class="bg-gradient-to-r from-blue-500 to-purple-600 overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-2xl font-bold mb-2">Welcome back, Admin <?php echo e(Auth::user()->name); ?>! 👋</h3>
                    <p class="opacity-90">Admin dashboard - Full system control</p>
                    <?php if(Auth::user()->last_login_at): ?>
                    <div class="mt-2 text-sm">
                        <span class="bg-blue-400 bg-opacity-30 px-2 py-1 rounded">Last login: <?php echo e(Auth::user()->last_login_at->format('M j, Y g:i A')); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="hidden md:block">
                    <i class="fas fa-user-shield text-4xl opacity-20"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4">
                        <i class="fas fa-box text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Total Products</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($data['totalProducts'] ?? '0'); ?></p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-green-600">
                    <i class="fas fa-database"></i> In system
                </div>
            </div>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-purple-100 text-purple-600 mr-4">
                        <i class="fas fa-users text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Total Users</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($data['totalUsers'] ?? '0'); ?></p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-blue-600">
                    <i class="fas fa-user-check"></i> Registered users
                </div>
            </div>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4">
                        <i class="fas fa-barcode text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Today's Scans</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($data['todayScans'] ?? '0'); ?></p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-green-600">
                    <i class="fas fa-sync-alt"></i> Scanned today
                </div>
            </div>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg transition-transform hover:scale-105">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4">
                        <i class="fas fa-calendar-week text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Weekly Scans</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($data['weeklyScans'] ?? '0'); ?></p>
                    </div>
                </div>
                <div class="mt-2 text-xs text-yellow-600">
                    <i class="fas fa-chart-bar"></i> This week's activity
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Quick Actions -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-6">Admin Quick Actions</h3>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <a href="<?php echo e(route('admin.products')); ?>" class="bg-blue-50 hover:bg-blue-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-blue-200">
                    <i class="fas fa-boxes text-blue-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">Manage Products</p>
                    <p class="text-xs text-gray-500 mt-1">Full product control</p>
                </a>

                <a href="<?php echo e(route('admin.scanner.index')); ?>" class="bg-green-50 hover:bg-green-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-green-200">
                    <i class="fas fa-barcode text-green-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">Scan Items</p>
                    <p class="text-xs text-gray-500 mt-1">Quick inventory check</p>
                </a>

                <a href="<?php echo e(route('admin.products')); ?>" class="bg-purple-50 hover:bg-purple-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-purple-200">
                    <i class="fas fa-list-alt text-purple-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">View Products</p>
                    <p class="text-xs text-gray-500 mt-1">Browse all inventory</p>
                </a>

                <a href="<?php echo e(route('profile.edit')); ?>" class="bg-yellow-50 hover:bg-yellow-100 p-4 rounded-lg text-center transition-all group border border-transparent hover:border-yellow-200">
                    <i class="fas fa-cog text-yellow-600 text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                    <p class="font-medium text-gray-900">Admin Settings</p>
                    <p class="text-xs text-gray-500 mt-1">System configuration</p>
                </a>
            </div>
        </div>
    </div>

    <!-- Admin Recent Activity -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Admin Panel</h3>
            <div class="space-y-4">
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-blue-100 text-blue-600 mr-3">
                        <i class="fas fa-user-shield text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Administrator Access</p>
                        <p class="text-sm text-gray-500">Full system control privileges</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-green-100 text-green-600 mr-3">
                        <i class="fas fa-boxes text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Product Management</p>
                        <p class="text-sm text-gray-500">Add, edit, delete products</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-red-100 text-red-600 mr-3">
                        <i class="fas fa-trash-alt text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Delete Products</p>
                        <p class="text-sm text-gray-500">Remove products from system</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="p-2 rounded-full bg-purple-100 text-purple-600 mr-3">
                        <i class="fas fa-chart-bar text-sm"></i>
                    </div>
                    <div>
                        <p class="font-medium">Analytics & Reports</p>
                        <p class="text-sm text-gray-500">View system statistics</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\product-authentication-system2\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>