<!-- Quick View Modal -->
<div
    x-data="{
        open: false,
        loading: false,
        product: null,
        fetchProduct(id) {
            this.open = true;
            this.loading = true;
            this.product = null;

            fetch(`/products/quick-view/${id}`)
                .then(response => response.json())
                .then(data => {
                    this.product = data;
                })
                .catch(error => {
                    console.error('Error fetching product:', error);
                    this.open = false;
                })
                .finally(() => {
                    this.loading = false;
                });
        }
    }"
    @keydown.escape.window="open = false"
    @open-quick-view.window="fetchProduct($event.detail.id)"
>
    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition ease-in duration-300"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="fixed inset-0 bg-gray-900 bg-opacity-75 flex items-center justify-center z-50 p-4"
        style="display: none;"
    >
        <!-- Modal Content -->
        <div
            x-show="open"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0 transform scale-90"
            x-transition:enter-end="opacity-100 transform scale-100"
            x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100 transform scale-100"
            x-transition:leave-end="opacity-0 transform scale-90"
            @click.away="open = false"
            class="bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-y-auto"
        >
            <template x-if="loading">
                <div class="p-8 text-center">
                    <i class="fas fa-spinner fa-spin text-4xl text-blue-500"></i>
                    <p class="mt-4 text-gray-600">Loading product details...</p>
                </div>
            </template>

            <template x-if="!loading && product">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 p-8">
                    <!-- Image -->
                    <div class="flex items-center justify-center bg-gray-100 rounded-lg">
                        <img :src="product.image_url" :alt="product.product_name" class="max-h-80 object-contain p-4">
                    </div>

                    <!-- Details -->
                    <div>
                        <h2 class="text-3xl font-bold text-gray-900 mb-2" x-text="product.product.product_name"></h2>

                        <!-- Price -->
                        <div class="mb-4">
                            <template x-if="product.product.discount_price">
                                <div>
                                    <span class="text-3xl font-bold text-red-600" x-text="`৳${Number(product.product.discount_price).toLocaleString()}`"></span>
                                    <span class="text-lg text-gray-400 line-through ml-2" x-text="`৳${Number(product.product.price).toLocaleString()}`"></span>
                                </div>
                            </template>
                            <template x-if="!product.product.discount_price">
                                <span class="text-3xl font-bold text-gray-900" x-text="`৳${Number(product.product.price).toLocaleString()}`"></span>
                            </template>
                        </div>

                        <!-- Short Description -->
                        <p class="text-gray-600 mb-6 leading-relaxed" x-text="product.product.description || 'No description available.'"></p>

                        <!-- Add to Cart -->
                        <div class="flex items-center gap-4 mb-6">
                            <button class="flex-1 v-btn v-btn-primary add-to-cart" :data-product-id="product.product.id">
                                <i class="fas fa-shopping-cart mr-2"></i> Add to Cart
                            </button>
                            <button class="v-btn v-btn-outline add-to-wishlist" :data-product-id="product.product.id">
                                <i class="fas fa-heart"></i>
                            </button>
                        </div>

                        <!-- Meta -->
                        <div class="text-sm text-gray-500 space-y-1">
                            <p><span class="font-semibold text-gray-700">Category:</span> <span x-text="product.product.category ? product.product.category.name : 'N/A'"></span></p>
                            <p><span class="font-semibold text-gray-700">SKU:</span> <span x-text="product.product.serial_no"></span></p>
                        </div>

                        <a :href="product.show_url" class="inline-block mt-6 text-blue-600 font-semibold hover:underline">
                            View Full Details <i class="fas fa-arrow-right ml-1"></i>
                        </a>
                    </div>
                </div>
            </template>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/frontend/pages/partials/quick-view-modal.blade.php ENDPATH**/ ?>