<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'NewTech Mobile'); ?></title>

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />


    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/main.css')); ?>">
    <style>
        .sticky-nav {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            width: 100%;
            z-index: 1000;
            transition: top 0.3s ease-in-out;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="font-sans bg-gray-50">
    <?php echo $__env->make('frontend.layouts.partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>



    <!-- Navigation -->
    <nav id="main-nav" x-data="{ open: false, categoriesOpen: false, phonesOpen: false }" class="bg-white shadow-sm p-4">
        <div class="container mx-auto flex flex-col lg:flex-row justify-start lg:justify-center items-center relative">
            <div class="w-full lg:w-auto flex justify-between items-center lg:absolute lg:left-0">
                <div class="relative">
                    <button @click="categoriesOpen = !categoriesOpen" @keydown.escape.window="categoriesOpen = false"
                        id="categoriesBtn"
                        class="bg-primary text-black px-4 py-2 rounded-lg flex items-center hover:bg-blue-700 transition">
                        Categories <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                            xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7">
                            </path>
                        </svg>
                    </button>
                    <div id="categoriesDropdown" x-show="categoriesOpen" @click.away="categoriesOpen = false"
                        class="absolute bg-white border rounded mt-2 w-56 shadow-lg z-10" style="display: none;"
                        x-transition>
                        <?php if(isset($categories)): ?>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($category->children->isNotEmpty()): ?>
                                    <div class="relative" x-data="{ open: false }" @mouseenter="open = true"
                                        @mouseleave="open = false">
                                        <a href="<?php echo e(route('products.index', ['category' => $category->slug])); ?>"
                                            class="flex justify-between items-center px-4 py-2 text-gray-800 hover:bg-gray-200">
                                            <span><i class="<?php echo e($category->icon); ?> mr-2"></i><?php echo e($category->name); ?></span>
                                            <i class="fas fa-chevron-right text-xs"></i>
                                        </a>
                                        <div x-show="open"
                                            class="absolute left-full top-0 mt-0 w-56 bg-white border rounded shadow-lg"
                                            x-transition>
                                            <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('products.index', ['category' => $child->slug])); ?>"
                                                    class="block px-4 py-2 text-gray-800 hover:bg-gray-200"><?php echo e($child->name); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <a href="<?php echo e(route('products.index', ['category' => $category->slug])); ?>"
                                        class="block px-4 py-2 text-gray-800 hover:bg-gray-200">
                                        <i class="<?php echo e($category->icon); ?> mr-2"></i><?php echo e($category->name); ?>

                                    </a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
                <!-- Hamburger -->
                <div class="lg:hidden">
                    <button @click="open = !open" class="text-gray-600 hover:text-blue-600 focus:outline-none">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                            xmlns="http://www.w3.org/2000/svg">
                            <path :class="{ 'hidden': open, 'inline-flex': !open }" class="inline-flex"
                                stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16M4 18h16" />
                            <path :class="{ 'hidden': !open, 'inline-flex': open }" class="hidden"
                                stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
            </div>
            <div :class="{ 'flex': open, 'hidden': !open }"
                class="w-full flex-col lg:flex lg:flex-row lg:items-center lg:justify-center mt-4 lg:mt-0 space-y-4 lg:space-y-0">
                <ul
                    class="flex flex-col lg:flex-row lg:flex-wrap justify-center items-start lg:space-x-6 space-y-2 lg:space-y-0">
                    <li><a href="<?php echo e(route('home')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Home</a>
                    </li>
                    <li><a href="<?php echo e(route('about')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">About
                            Us</a></li>
                    <li><a href="<?php echo e(route('products.index')); ?>"
                            class="text-gray-700 hover:text-blue-600 font-medium">Phones</a></li>
                    <li><a href="<?php echo e(route('products.index', ['category' => 'accessories'])); ?>"
                            class="text-gray-700 hover:text-blue-600 font-medium">Accessories</a></li>
                    <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Contact
                            Us</a></li>
                    <li><a href="#" class="text-gray-700 hover:text-blue-600 font-medium">Customer Service</a>
                    </li>
                    <li><a href="#" class="text-gray-700 hover:text-blue-600 font-medium">Track Order</a></li>
                </ul>
                <div class="flex items-center space-x-4 lg:absolute lg:right-0">
                    <a href="#" class="text-gray-600 hover:text-blue-600"><i class="fas fa-gift text-xl"></i></a>
                    <a href="<?php echo e(route('cart.index')); ?>" class="text-gray-600 hover:text-blue-600 relative">
                        <i class="fas fa-shopping-cart text-xl"></i>
                        <span id="cart-count"
                            class="absolute -top-2 -right-2 bg-primary text-blue-900 font-extrabold text-xsrounded-full w-5 h-5 flex items-center justify-center text-xs"><?php echo e(count((array) session('cart'))); ?></span>
                    </a>
                    <a href="#" class="text-gray-600 hover:text-blue-600"><i class="far fa-comment text-xl"></i></a>
                </div>
                <!-- Search Form - moved outside for better responsive handling -->
                <div class="w-full lg:w-auto mt-4 lg:mt-0 lg:absolute lg:right-0 lg:mr-32">
                    <form action="<?php echo e(route('products.index')); ?>" method="GET" class="flex items-center w-full">
                        <input type="text" name="search" placeholder="Search..."
                            class="border rounded-l py-1 px-2 text-sm w-full">
                        <button type="submit" class="bg-blue-700 text-white py-1 px-3 rounded-r">
                            <i class="fas fa-search"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </nav>


    <!-- Main Content -->
    <main id="main-content">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php echo $__env->make('frontend.layouts.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        // Sticky navigation
        window.addEventListener('scroll', function() {
            const nav = document.getElementById('main-nav');
            const mainContent = document.getElementById('main-content');
            const header = document.querySelector('header');

            if (nav && header) {
                const navHeight = nav.offsetHeight;
                const stickyPoint = header.offsetHeight;

                if (window.pageYOffset > stickyPoint) {
                    nav.classList.add('sticky-nav');
                    mainContent.style.paddingTop = navHeight + 'px';
                } else {
                    nav.classList.remove('sticky-nav');
                    mainContent.style.paddingTop = '0px';
                }
            }
        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <script src="<?php echo e(asset('frontend/assets/js/main.js')); ?>"></script>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>