<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'NewTech Mobile'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .sticky-nav {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            width: 100%;
            z-index: 1000;
            transition: top 0.3s ease-in-out;
        }
    </style>
</head>
<body class="font-sans bg-gray-50">
    <!-- Header -->
    <header class="bg-white text-gray-800 p-4 flex justify-between items-center border-b">
        <div class="text-4xl font-bold">
            <a href="<?php echo e(route('home')); ?>">NewTech<span class="text-blue-600">Mobile</span></a>
        </div>
        <div class="flex space-x-4">
            <?php if(auth()->guard()->check()): ?>
                <a href="#" class="hover:underline"><i class="fas fa-user mr-1"></i><?php echo e(Auth::user()->name); ?></a> |
                <a href="<?php echo e(route('logout')); ?>" class="hover:underline" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
                    <?php echo csrf_field(); ?>
                </form>
            <?php else: ?>
                <a href="<?php echo e(route('login')); ?>" class="text-gray-600 hover:text-blue-600"><i class="fas fa-user mr-1"></i>Sign in</a> |
                <a href="<?php echo e(route('register')); ?>" class="text-gray-600 hover:text-blue-600"><i class="fas fa-user-plus mr-1"></i>Join</a>
            <?php endif; ?>
        </div>
    </header>

    <!-- Navigation -->
    <nav id="main-nav" class="bg-white shadow-sm p-4 flex flex-col md:flex-row justify-between items-center">
        <div class="relative mb-4 md:mb-0">
            <button id="categoriesBtn" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center hover:bg-blue-700 transition">
                Categories <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
            </button>
            <div id="categoriesDropdown" class="hidden absolute bg-white border rounded mt-2 w-48 shadow-lg z-10">
                <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('products.index', ['category' => $category->slug])); ?>" class="block px-4 py-2 text-gray-800 hover:bg-gray-200">
                    <i class="<?php echo e($category->icon); ?> mr-2"></i><?php echo e($category->name); ?>

                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <ul class="flex flex-wrap justify-center space-x-2 md:space-x-6 mb-4 md:mb-0">
            <li><a href="<?php echo e(route('home')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Home</a></li>
            <li><a href="<?php echo e(route('about')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">About Us</a></li>
            <li><a href="<?php echo e(route('products.index')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Phones</a></li>
            <li><a href="<?php echo e(route('products.index', ['category' => 'accessories'])); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Accessories</a></li>
            <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Contact Us</a></li>
            <li><a href="<?php echo e(route('customer-service')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Customer Service</a></li>
            <li><a href="#" class="text-gray-700 hover:text-blue-600 font-medium">Track Order</a></li>
        </ul>
        <div class="flex space-x-4">
            <a href="#" class="text-gray-600 hover:text-blue-600"><i class="fas fa-gift text-xl"></i></a>
            <a href="#" class="text-gray-600 hover:text-blue-600 relative">
                <i class="fas fa-shopping-cart text-xl"></i>
                <span class="absolute -top-2 -right-2 bg-blue-600 text-white rounded-full w-5 h-5 flex items-center justify-center text-xs">3</span>
            </a>
            <a href="#" class="text-gray-600 hover:text-blue-600"><i class="far fa-comment text-xl"></i></a>
            <form action="<?php echo e(route('products.index')); ?>" method="GET" class="flex items-center">
                <input type="text" name="search" placeholder="Search..." class="border rounded-l py-1 px-2 text-sm">
                <button type="submit" class="bg-blue-600 text-white py-1 px-3 rounded-r hover:bg-blue-700">
                    <i class="fas fa-search"></i>
                </button>
            </form>
        </div>
    </nav>

    <!-- Main Content -->
    <main id="main-content">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-100 text-gray-700 py-12 px-4">
        <div class="container mx-auto max-w-6xl">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div>
                    <h3 class="text-2xl font-bold mb-4">NewTech<span class="text-blue-600">Mobile</span></h3>
                    <p class="text-gray-500">Your trusted source for premium mobile devices and accessories since 2010.</p>
                </div>
                <div>
                    <h4 class="font-bold text-lg mb-4">Quick Links</h4>
                    <ul class="space-y-2">
                        <li><a href="<?php echo e(route('home')); ?>" class="text-gray-400 hover:text-white">Home</a></li>
                        <li><a href="<?php echo e(route('about')); ?>" class="text-gray-400 hover:text-white">About Us</a></li>
                        <li><a href="<?php echo e(route('products.index')); ?>" class="text-gray-400 hover:text-white">Products</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-400 hover:text-white">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-bold text-lg mb-4">Customer Service</h4>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-gray-500 hover:text-blue-600">Track Order</a></li>
                        <li><a href="#" class="text-gray-500 hover:text-blue-600">Returns & Refunds</a></li>
                        <li><a href="#" class="text-gray-500 hover:text-blue-600">Shipping Info</a></li>
                        <li><a href="#" class="text-gray-500 hover:text-blue-600">FAQ</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-bold text-lg mb-4">Contact Us</h4>
                    <ul class="space-y-2">
                        <li class="flex items-center text-gray-500"><i class="fas fa-map-marker-alt mr-2 text-blue-500"></i> 123 Mobile Street, Tech City</li>
                        <li class="flex items-center text-gray-500"><i class="fas fa-phone mr-2 text-blue-500"></i> (555) 123-4567</li>
                        <li class="flex items-center text-gray-500"><i class="fas fa-envelope mr-2 text-blue-500"></i> info@newtechmobile.com</li>
                    </ul>
                    <div class="flex space-x-4 mt-4">
                        <a href="#" class="text-gray-500 hover:text-blue-600"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="text-gray-500 hover:text-blue-600"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="text-gray-500 hover:text-blue-600"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
            <div class="border-t border-gray-200 mt-8 pt-8 text-center text-gray-500">
                <p>&copy; <?php echo e(date('Y')); ?> NewTech Mobile. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        document.getElementById('categoriesBtn')?.addEventListener('click', function() {
            const dropdown = document.getElementById('categoriesDropdown');
            dropdown.classList.toggle('hidden');
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdown = document.getElementById('categoriesDropdown');
            const button = document.getElementById('categoriesBtn');
            if (button && dropdown && !button.contains(event.target) && !dropdown.contains(event.target)) {
                dropdown.classList.add('hidden');
            }
        });

        // Sticky navigation
        window.addEventListener('scroll', function() {
            const nav = document.getElementById('main-nav');
            const mainContent = document.getElementById('main-content');
            const header = document.querySelector('header');

            if (nav && header) {
                const navHeight = nav.offsetHeight;
                const stickyPoint = header.offsetHeight;

                if (window.pageYOffset > stickyPoint) {
                    nav.classList.add('sticky-nav');
                    mainContent.style.paddingTop = navHeight + 'px';
                } else {
                    nav.classList.remove('sticky-nav');
                    mainContent.style.paddingTop = '0px';
                }
            }
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\product-authentication-system2\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>