<?php $__env->startSection('title', '5Star Mobile - Premium Phones & Accessories'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-blue-50 text-gray-800 py-20 px-4">
        <div class="container mx-auto max-w-6xl flex flex-col md:flex-row items-center">
            <div class="md:w-1/2 mb-8 md:mb-0">
                <h1 class="text-4xl md:text-5xl font-bold mb-4 text-blue-900">Authentic Phones, Guaranteed</h1>
                <p class="text-xl mb-6 text-gray-600">Discover the newest models with cutting-edge technology and premium features.</p>
                <a href="<?php echo e(route('products.index')); ?>" class="bg-blue-600 text-white font-bold py-3 px-8 rounded-lg hover:bg-blue-700 transition duration-300 shadow-lg">Shop Now</a>
            </div>
            <div class="md:w-1/2 flex justify-center">
                <img src="https://via.placeholder.com/500x300" alt="Latest Smartphones" class="rounded-lg shadow-lg">
            </div>
        </div>
    </section>

    <!-- Featured Products -->
    <section class="py-16 px-4 bg-white">
        <div class="container mx-auto max-w-6xl">
            <h2 class="text-3xl font-bold text-center mb-10">Featured Products</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg border border-gray-200 overflow-hidden hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                    <img src="<?php echo e($product->image); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-48 object-cover">
                    <div class="p-4">
                        <h3 class="font-bold text-lg mb-2"><?php echo e($product->name); ?></h3>
                        <p class="text-gray-600 mb-4"><?php echo e(Str::limit($product->description, 80)); ?></p>
                        <div class="flex justify-between items-center">
                            <span class="font-bold text-blue-600 text-xl">$<?php echo e($product->final_price); ?></span>
                            <?php if($product->is_on_sale): ?>
                                <span class="text-sm text-gray-500 line-through">$<?php echo e($product->price); ?></span>
                            <?php endif; ?>
                            <button class="bg-blue-100 text-blue-800 py-2 px-4 rounded-lg hover:bg-blue-200 font-semibold transition duration-300">Add to Cart</button>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Categories Section -->
    <section class="py-16 px-4 bg-gray-50">
        <div class="container mx-auto max-w-6xl">
            <h2 class="text-3xl font-bold text-center mb-10">Shop by Category</h2>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('products.index', ['category' => $category->slug])); ?>" class="bg-white rounded-lg shadow-sm p-6 text-center hover:shadow-lg hover:border-blue-500 border-2 border-transparent transition duration-300 group">
                    <i class="<?php echo e($category->icon); ?> text-4xl text-blue-500 mb-4 group-hover:scale-110 transition-transform"></i>
                    <h3 class="font-bold text-lg"><?php echo e($category->name); ?></h3>
                    <p class="text-gray-500 text-sm mt-2"><?php echo e($category->products_count); ?> products</p>
                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section class="py-16 px-4 bg-blue-600 text-white">
        <div class="container mx-auto max-w-4xl text-center">
            <h2 class="text-3xl font-bold mb-4">Stay Updated</h2>
            <p class="mb-6 text-lg">Subscribe to our newsletter for the latest product releases and exclusive deals.</p>
            <form class="flex flex-col md:flex-row justify-center space-y-4 md:space-y-0 md:space-x-4">
                <input type="email" placeholder="Your email address" class="py-3 px-4 rounded-lg text-gray-800 w-full md:w-1/2 focus:outline-none focus:ring-2 focus:ring-blue-300">
                <button type="submit" class="bg-white text-red-600 font-bold py-3 px-6 rounded-lg hover:bg-gray-100 transition duration-300">Subscribe</button>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\product-authentication-system2\resources\views/frontend/pages/home.blade.php ENDPATH**/ ?>