<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-8 bg-gray-50 flex items-center justify-center px-4">
    <div class="verification-box bg-white w-full max-w-4xl mx-auto">
        <div class="p-6 sm:p-8">
            <div class="bg-gradient-to-r from-blue-600 to-purple-700 text-white p-6 text-center rounded-t-lg -m-6 sm:-m-8 mb-8">
                <h1 class="text-2xl md:text-3xl font-bold">Product Authenticity Report</h1>
            </div>

            <!-- Verification Form (shown if no result is present) -->
            <?php if(!session('error') && !isset($error) && !isset($product)): ?>
                <div class="verification-form-section mt-6">
                    <h2 class="text-xl sm:text-2xl font-bold text-gray-800 text-center mb-4">Verify Your Product</h2>
                    <p class="text-gray-600 text-center mb-6">Enter the serial number or IMEI found on your product to check its authenticity.</p>

                    <form id="verification-form" action="<?php echo e(route('products.verify.post')); ?>" method="POST" class="max-w-lg mx-auto">
                        <?php echo csrf_field(); ?>
                        <div class="relative group">
                            <input type="text" id="serial_no" name="serial_no" placeholder="Enter Serial Number or IMEI..." class="w-full bg-gray-50 border-2 border-gray-300 rounded-full py-3 pl-5 pr-32 text-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" required value="<?php echo e(old('serial_no')); ?>">
                            <button type="submit" class="absolute inset-y-0 right-0 flex items-center justify-center bg-blue-600 hover:bg-blue-700 text-white font-bold px-6 rounded-full m-1.5 transition-all duration-300 group-focus-within:shadow-lg">
                                <i class="fas fa-search sm:mr-2"></i>
                                <span class="hidden sm:inline">Verify</span>
                            </button>
                        </div>
                    </form>

                    <!-- OR Separator -->
                    <div class="flex items-center justify-center my-6">
                        <span class="h-px bg-gray-300 flex-1"></span>
                        <span class="px-4 text-sm font-semibold text-gray-500">OR</span>
                        <span class="h-px bg-gray-300 flex-1"></span>
                    </div>

                    <!-- Scan Button and Camera View -->
                    <div class="text-center pb-4">
                        <button type="button" id="scan-qr-btn" class="bg-purple-600 hover:bg-purple-700 text-white font-bold py-2 px-8 rounded-full transition duration-300">
                            <i class="fas fa-qrcode mr-2"></i> Scan with Camera
                        </button>
                        <div id="scanner-section" class="mt-4 max-w-sm mx-auto hidden">
                            <div id="reader" class="w-full border-2 border-dashed border-gray-300 rounded-lg p-2"></div>
                            <div id="scanner-error" class="text-red-500 text-sm mt-2 text-center hidden"></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>


            <!-- Error Result Section -->
            
            <?php if(session('error') || isset($error)): ?> <div class="result-section mt-6 border-t pt-8">
                    <div class="text-center p-4">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-red-100 mb-4">
                            <i class="fas fa-times text-red-600 text-3xl"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-800">Verification Failed</h2>
                        <p class="text-gray-600 mt-2 max-w-md mx-auto"><?php echo e(session('error') ?? $error); ?></p>
                        <a href="<?php echo e(route('verify')); ?>" class="mt-6 inline-flex items-center bg-blue-600 text-white font-semibold py-2 px-6 rounded-lg hover:bg-blue-700 transition-colors">
                            <i class="fas fa-arrow-left mr-1"></i> Try Again
                        </a>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Success Result Section -->
            <?php if(isset($product)): ?>
                <div class="result-section mt-6 border-t pt-8">
                    <div class="text-center mb-8">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-green-100 mb-4">
                            <i class="fas fa-check-circle text-green-600 text-3xl"></i>
                        </div>
                        <h2 class="text-2xl sm:text-3xl font-bold text-gray-800">Product Verified</h2>
                        <p class="text-gray-600 mt-1">This is an authentic product from our database.</p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                        <!-- Product Image -->
                        <div class="flex justify-center items-center">
                            <div class="product-image w-48 h-48 bg-gray-100 border border-gray-200 rounded-lg flex items-center justify-center p-2 overflow-hidden">
                                <?php if($product->image): ?>
                                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>" alt="<?php echo e($product->product_name); ?>" class="w-full h-full object-cover">
                                <?php else: ?>
                                    
                                    <i class="fas fa-mobile-alt text-6xl text-gray-400"></i>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Product Details -->
                        <div class="md:col-span-2">
                            <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg mb-4">
                                <p class="text-gray-500 text-sm font-medium">Product Name</p>
                                <p class="font-semibold text-lg text-gray-800"><?php echo e($product->product_name); ?></p>
                            </div>
                            <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg mb-4">
                                <p class="text-gray-500 text-sm font-medium">Serial No</p>
                                <p class="font-semibold text-lg text-gray-800 font-mono"><?php echo e($product->serial_no); ?></p>
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg">
                                    <p class="text-gray-500 text-sm font-medium">Condition</p>
                                    <p class="font-semibold text-gray-800"><?php echo e($product->condition); ?></p>
                                </div>
                                <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg">
                                    <p class="text-gray-500 text-sm font-medium">Quality</p>
                                    <p class="font-semibold text-gray-800"><?php echo e($product->quality); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Details -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
                        <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg">
                            <p class="text-gray-500 text-sm font-medium">Status</p>
                            <p class="font-semibold text-gray-800"><?php echo e($product->status); ?></p>
                        </div>
                        <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg">
                            <p class="text-gray-500 text-sm font-medium">IMEI</p>
                            <p class="font-semibold text-gray-800 font-mono"><?php echo e($product->imei ?? 'N/A'); ?></p>
                        </div>
                        <div class="detail-card border border-gray-200 bg-white p-4 rounded-lg">
                            <p class="text-gray-500 text-sm font-medium">Color</p>
                            <p class="font-semibold text-gray-800"><?php echo e($product->color); ?></p>
                        </div>
                    </div>

                    <!-- Download Button -->
                    <div class="text-center pt-4 border-t">
                        <button onclick="generateReport('<?php echo e($product->id); ?>')" class="download-btn bg-blue-600 hover:bg-blue-700 text-white py-3 px-6 rounded-lg font-semibold inline-flex items-center transition duration-200">
                            <i class="fas fa-download mr-2"></i> Download Report PDF Copy
                        </button>
                        <a href="<?php echo e(route('verify')); ?>" class="mt-4 sm:mt-0 sm:ml-4 inline-block text-blue-600 hover:underline">Verify Another Product</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Include HTML5 QR Code Scanner Library -->
<script src="https://unpkg.com/html5-qrcode/minified/html5-qrcode.min.js"></script>

<script>
    // Function to generate and download PDF report
    function generateReport(productId) {
        window.open(`/products/${productId}/report`, '_blank');
    }
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const scanButton = document.getElementById('scan-qr-btn');
    const scannerSection = document.getElementById('scanner-section');
    const serialInput = document.getElementById('serial_no');
    const verificationForm = document.getElementById('verification-form');
    const scannerError = document.getElementById('scanner-error');
    let html5QrcodeScanner = null;
    let isScannerActive = false;

    // Only run if the scan button exists on the page
    if (scanButton) {
        scanButton.addEventListener('click', toggleScanner);
    }

    function toggleScanner() {
        isScannerActive = !isScannerActive;
        if (isScannerActive) {
            startScanner();
            scannerSection.classList.remove('hidden');
            scanButton.innerHTML = '<i class="fas fa-stop mr-2"></i> Stop Scanner';
            scanButton.classList.replace('bg-purple-600', 'bg-red-600');
            scanButton.classList.replace('hover:bg-purple-700', 'hover:bg-red-700');
        } else {
            stopScanner();
            scannerSection.classList.add('hidden');
            scanButton.innerHTML = '<i class="fas fa-qrcode mr-2"></i> Scan with Camera';
            scanButton.classList.replace('bg-red-600', 'bg-purple-600');
            scanButton.classList.replace('hover:bg-red-700', 'hover:bg-purple-700');
        }
    }

    function startScanner() {
        if (!html5QrcodeScanner) {
            html5QrcodeScanner = new Html5Qrcode("reader");
        }
        scannerError.classList.add('hidden');
        html5QrcodeScanner.start(
            { facingMode: "environment" }, // Use the rear camera
            { fps: 10, qrbox: { width: 250, height: 250 } },
            onScanSuccess,
            onScanFailure
        ).catch(err => {
            showError(`Unable to start camera. Please grant camera permissions.`);
            if(isScannerActive) toggleScanner(); // Revert button state on failure
        });
    }

    function stopScanner() {
        if (html5QrcodeScanner && html5QrcodeScanner.isScanning) {
            html5QrcodeScanner.stop().catch(err => console.error("Failed to stop the scanner.", err));
        }
    }

    function onScanSuccess(decodedText, decodedResult) {
        stopScanner();
        let serial = decodedText;
        // Try to extract serial from a URL if the QR code contains one
        try {
            const url = new URL(decodedText);
            const serialFromParam = url.searchParams.get('serial') || url.searchParams.get('serial_no');
            if (serialFromParam) {
                serial = serialFromParam;
            }
        } catch (e) {
            // Not a URL, use the decoded text as is
        }
        serialInput.value = serial;
        verificationForm.submit();
    }

    function onScanFailure(error) {
        // This callback is called frequently, so we don't log every time.
    }

    function showError(message) {
        scannerError.textContent = message;
        scannerError.classList.remove('hidden');
    }
});
</script>
<style>
    .verification-box {
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        border-radius: 1rem; /* 16px */
        overflow: hidden;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/products/verify.blade.php ENDPATH**/ ?>