<?php $__env->startSection('title', $product->product_name . ' - NewTech'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen py-8">
    <div class="container mx-auto px-4">
        <!-- Breadcrumbs -->
        <nav class="mb-6" aria-label="Breadcrumb">
            <ol class="flex items-center space-x-2 text-sm">
                <li>
                    <a href="<?php echo e(route('home')); ?>" class="text-gray-500 hover:text-blue-600 flex items-center transition-colors">
                        <i class="fas fa-home mr-2"></i> Home
                    </a>
                </li>
                <li><i class="fas fa-chevron-right text-gray-300 text-xs"></i></li>
                <li>
                    <a href="<?php echo e(route('products.index')); ?>" class="text-gray-500 hover:text-blue-600 transition-colors">Products</a>
                </li>
                <li><i class="fas fa-chevron-right text-gray-300 text-xs"></i></li>
                <li class="text-gray-800 font-medium truncate max-w-xs"><?php echo e($product->product_name); ?></li>
            </ol>
        </nav>

        <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 p-6 md:p-8">
                <!-- Product Image Gallery -->
                <div x-data="productGallery()" class="space-y-6">
                    <!-- Tabs for Image/3D -->
                    <div class="flex border-b mb-4">
                        <button
                            @click="activeTab = 'images'"
                            :class="activeTab === 'images' ? 'text-blue-600 font-semibold border-b-2 border-blue-600' : 'text-gray-500 hover:text-gray-700'"
                            class="py-3 px-6 focus:outline-none transition-colors"
                        >
                            <i class="fas fa-images mr-2"></i> Images
                        </button>
                        <button
                            @click="activeTab = '3d'"
                            :class="activeTab === '3d' ? 'text-blue-600 font-semibold border-b-2 border-blue-600' : 'text-gray-500 hover:text-gray-700'"
                            class="py-3 px-6 focus:outline-none transition-colors"
                        >
                            <i class="fas fa-cube mr-2"></i> 3D View
                        </button>
                    </div>

                    <!-- Image Gallery -->
                    <div x-show="activeTab === 'images'" x-transition class="space-y-4">
                        <!-- Main Image with Zoom -->
                        <div
                            class="relative border border-gray-200 rounded-xl overflow-hidden bg-gray-50 h-[500px] cursor-zoom-in"
                            @mousemove="handleZoom($event)"
                            @mouseleave="resetZoom()"
                        >
                            <img
                                :src="mainImage"
                                alt="<?php echo e($product->product_name); ?>"
                                class="w-full h-full object-contain p-4 transition-transform duration-200"
                                :style="zoomStyle"
                                @click="toggleZoom()"
                            >
                            <!-- Zoom Indicator -->
                            <div x-show="isZoomed" class="absolute top-4 right-4 bg-black bg-opacity-50 text-white px-3 py-1 rounded-full text-sm">
                                <i class="fas fa-search-plus mr-1"></i> Zoomed
                            </div>
                        </div>

                        <!-- Thumbnails -->
                        <div class="grid grid-cols-4 gap-3">
                            <template x-for="(thumb, index) in thumbnails" :key="index">
                                <button
                                    @click="changeMainImage(thumb)"
                                    :class="mainImage === thumb ? 'border-blue-500 ring-2 ring-blue-200' : 'border-gray-200 hover:border-blue-300'"
                                    class="border-2 rounded-lg p-1 transition-all duration-200"
                                >
                                    <img :src="thumb" :alt="`Thumbnail ${index + 1}`" class="w-full h-20 object-cover rounded-md">
                                </button>
                            </template>
                        </div>
                    </div>

                    <!-- 3D Model Viewer -->
                    <div x-show="activeTab === '3d'" x-transition>
                        <?php $model3dPath = 'models/phone.glb'; ?>
                        <?php if(true): ?>
                            <div class="border border-gray-200 rounded-xl bg-gray-50 h-[500px] flex items-center justify-center">
                                <div class="text-center">
                                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i class="fas fa-cube text-2xl text-blue-600"></i>
                                    </div>
                                    <p class="font-semibold text-lg mb-2">3D Viewer</p>
                                    <p class="text-gray-500 max-w-md">Interactive 3D model would be displayed here</p>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="h-[500px] border border-gray-200 rounded-xl bg-gray-50 flex flex-col items-center justify-center text-center text-gray-500 p-6">
                                <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mb-4">
                                    <i class="fas fa-cube text-2xl text-gray-400"></i>
                                </div>
                                <p class="font-semibold text-lg mb-2">3D Model Not Available</p>
                                <p class="text-gray-500 max-w-md">An interactive 3D view of this product will be available soon.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Product Details -->
                <div class="sticky top-8">
                    <div class="space-y-6">
                        <div>
                            <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-3 leading-tight"><?php echo e($product->product_name); ?></h1>
                            <div class="flex items-center flex-wrap gap-3 mb-4">
                                <div class="flex text-yellow-400">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <i class="fas fa-star text-sm"></i>
                                    <?php endfor; ?>
                                </div>
                                <span class="text-gray-500 text-sm">(15 Reviews)</span>
                                <span class="w-2 h-2 bg-gray-300 rounded-full"></span>
                                <span class="text-green-600 font-semibold text-sm flex items-center">
                                    <i class="fas fa-check-circle mr-1"></i> In Stock
                                </span>
                            </div>
                        </div>

                        <!-- Price -->
                        <div class="mb-2">
                            <?php if($product->discount_price): ?>
                                <div class="flex items-baseline gap-3">
                                    <span class="text-4xl font-bold text-red-600">৳<?php echo e(number_format($product->discount_price)); ?></span>
                                    <span class="text-xl text-gray-400 line-through">৳<?php echo e(number_format($product->price)); ?></span>
                                    <span class="bg-red-100 text-red-800 text-sm font-medium px-2.5 py-0.5 rounded-full">
                                        Save ৳<?php echo e(number_format($product->price - $product->discount_price)); ?>

                                    </span>
                                </div>
                            <?php else: ?>
                                <span class="text-4xl font-bold text-gray-900">৳<?php echo e(number_format($product->price)); ?></span>
                            <?php endif; ?>
                        </div>

                        <!-- Short Description -->
                        <p class="text-gray-600 leading-relaxed text-lg"><?php echo e($product->description ?: 'No description available for this product.'); ?></p>

                        <!-- Color Selection -->
                        <div class="mt-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-3">Color</h3>
                            <div class="flex gap-3" x-data="{ selectedColor: 'blue' }">
                                <template x-for="color in [
                                    { id: 'blue', name: 'Blue', value: '#3b82f6' },
                                    { id: 'red', name: 'Red', value: '#ef4444' },
                                    { id: 'green', name: 'Green', value: '#10b981' },
                                    { id: 'black', name: 'Black', value: '#1e293b' },
                                    { id: 'silver', name: 'Silver', value: '#94a3b8' }
                                ]" :key="color.id">
                                    <button
                                        @click="selectedColor = color.id"
                                        :class="selectedColor === color.id ? 'ring-2 ring-blue-500 ring-offset-2' : ''"
                                        class="w-10 h-10 rounded-full border-2 border-white shadow-md transition-all duration-200 hover:scale-110"
                                        :style="`background-color: ${color.value}`"
                                        :title="color.name"
                                    >
                                        <span x-show="selectedColor === color.id" class="flex items-center justify-center h-full text-white text-sm">
                                            ✓
                                        </span>
                                    </button>
                                </template>
                            </div>
                            <div class="mt-2 text-sm text-gray-600">
                                Selected: <span x-text="selectedColor.charAt(0).toUpperCase() + selectedColor.slice(1)" class="font-medium"></span>
                            </div>
                        </div>

                        

                        <!-- Add to Cart Section -->
                        <div class="bg-gray-50 rounded-xl p-6 space-y-5 mt-6 border border-gray-200 hover:border-blue-300 transition-all duration-300 hover:shadow-md">
                            <div class="flex items-center justify-between">
                                <span class="font-medium text-gray-700">Quantity</span>
                                <div class="flex items-center border border-gray-300 rounded-lg overflow-hidden">
                                    <button class="px-4 py-2 text-gray-600 hover:bg-gray-100 transition-colors quantity-decrease">-</button>
                                    <input type="text" value="1" class="w-12 text-center border-l border-r focus:outline-none py-2 quantity-input">
                                    <button class="px-4 py-2 text-gray-600 hover:bg-gray-100 transition-colors quantity-increase">+</button>
                                </div>
                            </div>

                            <div class="flex gap-3">
                                <button class="flex-1 bg-gradient-to-r from-blue-500 to-blue-600 text-white font-bold py-4 px-6 rounded-xl hover:from-blue-600 hover:to-blue-700 transition-all duration-300 hover:shadow-lg transform hover:-translate-y-0.5 add-to-cart" data-product-id="<?php echo e($product->id); ?>">
                                    <i class="fas fa-shopping-cart mr-2"></i> Add to Cart
                                </button>
                                <button class="p-4 border border-gray-300 rounded-xl hover:bg-gray-50 transition-colors hover:border-blue-300">
                                    <i class="far fa-heart text-xl text-gray-600 hover:text-red-500 transition-colors"></i>
                                </button>
                            </div>

                            <!-- Buy Now Button -->
                            <button class="w-full bg-gray-900 text-white font-bold py-4 px-6 rounded-xl hover:bg-gray-800 transition-colors transform hover:-translate-y-0.5">
                                <i class="fas fa-bolt mr-2"></i> Buy Now
                            </button>
                        </div>

                        <!-- Features -->
                        <div class="grid grid-cols-2 gap-4 mt-6">
                            <div class="flex items-center gap-3 p-3 bg-blue-50 rounded-lg">
                                <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                    <i class="fas fa-shipping-fast text-blue-600"></i>
                                </div>
                                <div>
                                    <p class="font-medium text-sm">Free Shipping</p>
                                    <p class="text-xs text-gray-500">Over ৳5000</p>
                                </div>
                            </div>
                            <div class="flex items-center gap-3 p-3 bg-green-50 rounded-lg">
                                <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                                    <i class="fas fa-shield-alt text-green-600"></i>
                                </div>
                                <div>
                                    <p class="font-medium text-sm">2 Year Warranty</p>
                                    <p class="text-xs text-gray-500">Full coverage</p>
                                </div>
                            </div>
                        </div>

                        <!-- Meta Info -->
                        <div class="text-sm text-gray-500 space-y-3 pt-4 border-t border-gray-200">
                            <div class="flex justify-between">
                                <span class="font-medium text-gray-700">SKU:</span>
                                <span><?php echo e($product->serial_no); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="font-medium text-gray-700">Category:</span>
                                <a href="<?php echo e(route('products.index', ['category' => $product->category->slug ?? ''])); ?>" class="text-blue-600 hover:underline"><?php echo e($product->category->name ?? 'Uncategorized'); ?></a>
                            </div>
                            <div class="flex justify-between">
                                <span class="font-medium text-gray-700">Delivery:</span>
                                <span>2-4 business days</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Description / Specs -->
            <div class="border-t border-gray-200 mt-8">
                <div class="flex border-b overflow-x-auto">
                    <button class="tab-button py-4 px-6 font-medium text-gray-500 hover:text-gray-700 border-b-2 border-blue-600 text-blue-600" data-tab="description">
                        Description
                    </button>
                    <button class="tab-button py-4 px-6 font-medium text-gray-500 hover:text-gray-700" data-tab="specifications">
                        Specifications
                    </button>
                    <button class="tab-button py-4 px-6 font-medium text-gray-500 hover:text-gray-700" data-tab="reviews">
                        Reviews (15)
                    </button>
                </div>

                <div class="p-8">
                    <!-- Description Tab -->
                    <div id="description-tab" class="tab-content">
                        <div class="prose max-w-none text-gray-700">
                            <p class="text-lg">Discover the amazing features of the <strong><?php echo e($product->product_name); ?></strong>. This device is designed to provide a seamless and powerful user experience, combining elegant design with top-tier performance.</p>

                            <h3 class="text-xl font-semibold mt-6 mb-3">Key Features:</h3>
                            <ul class="list-disc pl-6 space-y-2">
                                <li><strong>Premium Build:</strong> Crafted with high-quality materials for durability and style</li>
                                <li><strong>Advanced Technology:</strong> Incorporating the latest innovations for optimal performance</li>
                                <li><strong>User-Friendly:</strong> Intuitive design that's easy to use right out of the box</li>
                                <li><strong>Eco-Conscious:</strong> Manufactured with sustainable practices and materials</li>
                            </ul>

                            <h3 class="text-xl font-semibold mt-6 mb-3">What's in the box?</h3>
                            <p>The package includes the <?php echo e($product->product_name); ?>, a charging cable, a user manual, and a warranty card. Everything you need to get started right away.</p>
                        </div>
                    </div>

                    <!-- Specifications Tab (Hidden by default) -->
                    <div id="specifications-tab" class="tab-content hidden">
                        <div class="prose max-w-none">
                            <h3 class="text-xl font-semibold mb-4">Technical Specifications</h3>
                            <div class="bg-gray-50 rounded-xl p-6 mt-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div class="flex justify-between py-3 border-b border-gray-200">
                                        <span class="font-medium text-gray-700">Model</span>
                                        <span class="text-gray-600"><?php echo e($product->product_name); ?></span>
                                    </div>
                                    <div class="flex justify-between py-3 border-b border-gray-200">
                                        <span class="font-medium text-gray-700">SKU</span>
                                        <span class="text-gray-600"><?php echo e($product->serial_no); ?></span>
                                    </div>
                                    <div class="flex justify-between py-3 border-b border-gray-200">
                                        <span class="font-medium text-gray-700">Warranty</span>
                                        <span class="text-gray-600"><?php echo e($product->warranty_period ?? '1 Year'); ?></span>
                                    </div>
                                    <div class="flex justify-between py-3 border-b border-gray-200">
                                        <span class="font-medium text-gray-700">Color</span>
                                        <span class="text-gray-600"><?php echo e($product->color); ?></span>
                                    </div>
                                    <div class="flex justify-between py-3 border-b border-gray-200">
                                        <span class="font-medium text-gray-700">Condition</span>
                                        <span class="text-gray-600"><?php echo e($product->condition); ?></span>
                                    </div>
                                    <div class="flex justify-between py-3 border-b border-gray-200">
                                        <span class="font-medium text-gray-700">Manufacture Date</span>
                                        <span class="text-gray-600"><?php echo e($product->manufacture_date ? \Carbon\Carbon::parse($product->manufacture_date)->format('F Y') : 'N/A'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Reviews Tab (Hidden by default) -->
                    <div id="reviews-tab" class="tab-content hidden">
                        <div class="prose max-w-none">
                            <h3 class="text-xl font-semibold mb-4">Customer Reviews</h3>
                            <div class="flex items-center gap-4 my-6">
                                <div class="text-center bg-gray-50 rounded-xl p-6">
                                    <div class="text-5xl font-bold text-gray-800">4.8</div>
                                    <div class="flex text-yellow-400 justify-center my-2">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <div class="text-gray-500 text-sm">Based on 15 reviews</div>
                                </div>
                                <div class="flex-1">
                                    <!-- Rating breakdown would go here -->
                                </div>
                            </div>

                            <div class="space-y-6 mt-8">
                                <!-- Sample Review -->
                                <div class="border-b border-gray-200 pb-6">
                                    <div class="flex justify-between mb-2">
                                        <div class="font-semibold">John D.</div>
                                        <div class="text-sm text-gray-500">2 weeks ago</div>
                                    </div>
                                    <div class="flex text-yellow-400 mb-3">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star text-sm"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <p class="text-gray-600">This product exceeded my expectations. The quality is outstanding and it arrived sooner than expected. Highly recommended!</p>
                                </div>

                                <!-- Another sample review -->
                                <div class="border-b border-gray-200 pb-6">
                                    <div class="flex justify-between mb-2">
                                        <div class="font-semibold">Sarah M.</div>
                                        <div class="text-sm text-gray-500">1 month ago</div>
                                    </div>
                                    <div class="flex text-yellow-400 mb-3">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star text-sm"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <p class="text-gray-600">Great value for money. The product works perfectly and looks even better in person. Will definitely purchase from this seller again.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Floating Action Buttons -->
<div class="fixed bottom-8 right-8 z-50 flex flex-col gap-3">
    <button class="floating-action-btn bg-white text-gray-700 shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-110 group">
        <i class="fas fa-share-alt"></i>
        <span class="tooltip">Share Product</span>
    </button>
    <button class="floating-action-btn bg-white text-gray-700 shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-110 group">
        <i class="far fa-heart"></i>
        <span class="tooltip">Add to Wishlist</span>
    </button>
    <button class="floating-action-btn bg-blue-600 text-white shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-110 animate-pulse group add-to-cart" data-product-id="<?php echo e($product->id); ?>">
        <i class="fas fa-shopping-cart"></i>
        <span class="tooltip">Add to Cart</span>
    </button>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function productGallery() {
        return {
            activeTab: 'images',
            mainImage: '<?php echo e($product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/600x600'); ?>',
            thumbnails: [
                '<?php echo e($product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/150x150'); ?>',
                'https://images.unsplash.com/photo-1589793463343-0a47a5b6a2b6?w=200',
                'https://images.unsplash.com/photo-1610945415242-3adea3939964?w=200',
                'https://images.unsplash.com/photo-1556656793-08538906a9f8?w=200'
            ],
            isZoomed: false,
            zoomStyle: '',

            changeMainImage(newImage) {
                this.mainImage = newImage;
                this.isZoomed = false;
                this.zoomStyle = '';
            },

            toggleZoom() {
                this.isZoomed = !this.isZoomed;
                if (!this.isZoomed) {
                    this.zoomStyle = '';
                }
            },

            handleZoom(event) {
                if (!this.isZoomed) return;

                const container = event.currentTarget;
                const img = container.querySelector('img');
                const rect = container.getBoundingClientRect();

                const x = event.clientX - rect.left;
                const y = event.clientY - rect.top;

                const xPercent = (x / rect.width) * 100;
                const yPercent = (y / rect.height) * 100;

                this.zoomStyle = `transform: scale(2); transform-origin: ${xPercent}% ${yPercent}%;`;
            },

            resetZoom() {
                if (this.isZoomed) {
                    this.zoomStyle = 'transform: scale(2); transform-origin: center center;';
                }
            }
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Tab functionality
        const tabButtons = document.querySelectorAll('[data-tab]');
        const tabContents = document.querySelectorAll('.tab-content');

        tabButtons.forEach(button => {
            button.addEventListener('click', () => {
                const tabId = button.getAttribute('data-tab');

                // Update active tab button
                tabButtons.forEach(btn => {
                    btn.classList.remove('border-blue-600', 'text-blue-600');
                    btn.classList.add('text-gray-500');
                });
                button.classList.add('border-blue-600', 'text-blue-600');
                button.classList.remove('text-gray-500');

                // Show active tab content
                tabContents.forEach(content => {
                    content.classList.add('hidden');
                });
                document.getElementById(`${tabId}-tab`).classList.remove('hidden');
            });
        });

        // Quantity selector
        const quantityInput = document.querySelector('.quantity-input');
        document.querySelector('.quantity-decrease').addEventListener('click', () => {
            let value = parseInt(quantityInput.value);
            if (value > 1) {
                value--;
                quantityInput.value = value;
            }
        });

        document.querySelector('.quantity-increase').addEventListener('click', () => {
            let value = parseInt(quantityInput.value);
            value++;
            quantityInput.value = value;
        });

        // Add to Cart functionality
        document.querySelectorAll('.add-to-cart').forEach(button => {
            button.addEventListener('click', function() {
                const productId = this.getAttribute('data-product-id');
                const quantity = parseInt(quantityInput.value);

                // Show loading state
                const originalContent = this.innerHTML;
                this.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                this.disabled = true;

                fetch(`/cart/add/${productId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({ quantity: quantity })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showNotification(`"${data.productName}" added to cart!`, 'success');
                        // Update cart count in the navbar
                        const cartCountEl = document.getElementById('cart-count');
                        if (cartCountEl) {
                            cartCountEl.textContent = data.cartCount;
                        }
                    } else {
                        showNotification(data.message || 'Could not add to cart.', 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showNotification('An error occurred.', 'error');
                })
                .finally(() => {
                    // Reset button
                    // Check if the button is a floating action button to restore correct icon
                    if (this.classList.contains('floating-action-btn')) {
                        this.innerHTML = '<i class="fas fa-shopping-cart"></i><span class="tooltip">Add to Cart</span>';
                    } else {
                        this.innerHTML = '<i class="fas fa-shopping-cart mr-2"></i> Add to Cart';
                    }
                    this.disabled = false;
                });
            });
        });

        // Notification function
        function showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = 'fixed top-5 right-5 w-full max-w-sm bg-white shadow-2xl rounded-xl p-4 border-l-4 z-50';

            const styles = {
                success: { border: 'border-green-500', icon: 'fa-check-circle', text: 'text-green-500' },
                error: { border: 'border-red-500', icon: 'fa-exclamation-circle', text: 'text-red-500' },
                info: { border: 'border-blue-500', icon: 'fa-info-circle', text: 'text-blue-500' }
            };

            const style = styles[type] || styles.info;

            notification.classList.add(style.border);
            notification.innerHTML = `
                <div class="flex items-start gap-4">
                    <i class="fas ${style.icon} ${style.text} text-2xl mt-1"></i>
                    <div class="flex-1">
                        <p class="font-bold text-gray-800">${type.charAt(0).toUpperCase() + type.slice(1)}</p>
                        <p class="text-sm text-gray-600">${message}</p>
                    </div>
                    <button class="text-gray-400 hover:text-gray-600 text-xl">&times;</button>
                </div>
            `;

            document.body.appendChild(notification);

            // Auto remove after 4 seconds
            setTimeout(() => {
                notification.remove();
            }, 4000);

            // Manual close
            notification.querySelector('button').addEventListener('click', () => {
                notification.remove();
            });
        }
    });
</script>

<style>
    .tooltip {
        position: absolute;
        right: 100%;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(0, 0, 0, 0.8);
        color: white;
        padding: 0.5rem 0.75rem;
        border-radius: 0.375rem;
        font-size: 0.875rem;
        white-space: nowrap;
        margin-right: 0.5rem;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
    }

    .group:hover .tooltip {
        opacity: 1;
    }

    .floating-action-btn {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        transition: all 0.3s ease;
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/frontend/pages/show.blade.php ENDPATH**/ ?>