<!-- Navigation -->
<nav id="main-nav" x-data="{ open: false, categoriesOpen: false }" class="bg-white shadow-sm p-4">
    <div class="flex flex-col md:flex-row justify-between items-center">
        <div class="w-full md:w-auto flex justify-between items-center">
            <div class="relative" x-data="{ phonesOpen: false }">
                <button @click="categoriesOpen = !categoriesOpen" id="categoriesBtn" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center hover:bg-blue-700 transition">
                    Categories <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div id="categoriesDropdown" x-show="categoriesOpen" @click.away="categoriesOpen = false" class="absolute bg-white border rounded mt-2 w-56 shadow-lg z-10" style="display: none;" x-transition>
                    <div @mouseenter="phonesOpen = true" @mouseleave="phonesOpen = false" class="relative">
                        <a href="<?php echo e(route('products.index', ['category' => 'mobile-phones'])); ?>" class="flex justify-between items-center px-4 py-2 text-gray-800 hover:bg-gray-200">
                            <span><i class="fas fa-mobile-alt mr-2"></i>Phones</span>
                            <i class="fas fa-chevron-right text-xs"></i>
                        </a>
                        <div x-show="phonesOpen" class="absolute left-full top-0 mt-0 w-56 bg-white border rounded shadow-lg" x-transition>
                            <a href="<?php echo e(route('products.index', ['category' => 'smart-phone'])); ?>" class="block px-4 py-2 text-gray-800 hover:bg-gray-200">Smart Phone</a>
                            <a href="<?php echo e(route('products.index', ['category' => 'feature-phone'])); ?>" class="block px-4 py-2 text-gray-800 hover:bg-gray-200">Feature Phone</a>
                        </div>
                    </div>
                    <a href="<?php echo e(route('products.index', ['category' => 'accessories'])); ?>" class="block px-4 py-2 text-gray-800 hover:bg-gray-200">
                        <i class="fas fa-headphones mr-2"></i>Phone Accessories
                    </a>
                    <a href="<?php echo e(route('products.index', ['category' => 'tablets'])); ?>" class="block px-4 py-2 text-gray-800 hover:bg-gray-200">
                        <i class="fas fa-tablet-alt mr-2"></i>Tablets
                    </a>
                </div>
            </div>
            <!-- Hamburger -->
            <div class="md:hidden">
                <button @click="open = !open" class="text-gray-600 hover:text-blue-600 focus:outline-none">
                    <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path :class="{'hidden': open, 'inline-flex': !open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': !open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
        <div :class="{'flex': open, 'hidden': !open}" class="w-full flex-col md:flex md:flex-row md:items-center md:justify-between mt-4 md:mt-0 md:w-auto">
            <ul class="flex flex-col md:flex-row md:flex-wrap justify-center md:space-x-6 space-y-2 md:space-y-0 mb-4 md:mb-0">
                <li><a href="<?php echo e(route('home')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Home</a></li>
                <li><a href="<?php echo e(route('about')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">About Us</a></li>
                <li><a href="<?php echo e(route('products.index')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Phones</a></li>
                <li><a href="<?php echo e(route('products.index', ['category' => 'accessories'])); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Accessories</a></li>
                <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Contact Us</a></li>
                <li><a href="<?php echo e(route('customer-service')); ?>" class="text-gray-700 hover:text-blue-600 font-medium">Customer Service</a></li>
                <li><a href="#" class="text-gray-700 hover:text-blue-600 font-medium">Track Order</a></li>
            </ul>
            <div class="flex items-center space-x-4">
                <a href="#" class="text-gray-600 hover:text-blue-600"><i class="fas fa-gift text-xl"></i></a>
                <a href="#" class="text-gray-600 hover:text-blue-600 relative">
                    <i class="fas fa-shopping-cart text-xl"></i>
                    <span id="cart-count" class="absolute -top-2 -right-2 bg-blue-600 text-white rounded-full w-5 h-5 flex items-center justify-center text-xs"><?php echo e(count((array) session('cart'))); ?></span>
                </a>
                <a href="#" class="text-gray-600 hover:text-blue-600"><i class="far fa-comment text-xl"></i></a>
                <form action="<?php echo e(route('products.index')); ?>" method="GET" class="flex items-center">
                    <input type="text" name="search" placeholder="Search..." class="border rounded-l py-1 px-2 text-sm">
                    <button type="submit" class="bg-blue-600 text-white py-1 px-3 rounded-r hover:bg-blue-700">
                        <i class="fas fa-search"></i>
                    </button>
                </form>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/frontend/layouts/partials/_navigation.blade.php ENDPATH**/ ?>