<?php $__env->startSection('title', 'Barcode/IMEI Scanner'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-6 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Scanner Header -->
        <div class="bg-gradient-to-r from-blue-600 to-purple-600 rounded-xl p-8 text-white mb-8 shadow-lg">
            <h1 class="text-2xl sm:text-3xl font-extrabold flex items-center">
                <i class="fas fa-qrcode mr-3"></i>Barcode/IMEI Scanner
            </h1>
            <p class="mt-2 text-blue-100 text-sm sm:text-base">Scan or manually enter product codes to add them to the database</p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Scanner Interface -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-xl shadow-md p-6">
                    <!-- Camera Scanner -->
                    <div class="mb-8">
                        <h2 class="text-lg sm:text-xl font-semibold mb-4 text-gray-800">
                            <i class="fas fa-camera mr-2"></i>Camera Scanner
                        </h2>
                        <div id="camera-scanner" class="border-2 border-dashed border-gray-300 rounded-xl p-4 text-center">
                            <div id="reader" class="w-full h-64 sm:h-80 mx-auto"></div>
                            <div class="mt-4 flex flex-wrap justify-center gap-3">
                                <button id="start-camera" class="bg-blue-600 text-white px-5 py-2.5 rounded-lg hover:bg-blue-700 transition duration-200 text-sm sm:text-base font-medium">
                                    <i class="fas fa-camera mr-2"></i>Start Camera
                                </button>
                                <button id="stop-camera" class="bg-red-600 text-white px-5 py-2.5 rounded-lg hover:bg-red-700 transition duration-200 text-sm sm:text-base font-medium hidden">
                                    <i class="fas fa-stop mr-2"></i>Stop Camera
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Manual Input -->
                    <div class="mb-8">
                        <h2 class="text-lg sm:text-xl font-semibold mb-4 text-gray-800">
                            <i class="fas fa-keyboard mr-2"></i>Manual Input
                        </h2>
                        <div class="flex flex-col sm:flex-row gap-3">
                            <input type="text" id="manual-scan" placeholder="Enter Barcode, IMEI, or Serial Number"
                                   class="flex-grow px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm sm:text-base">
                            <button id="manual-scan-btn" class="bg-green-600 text-white px-5 py-3 rounded-lg hover:bg-green-700 transition duration-200 text-sm sm:text-base font-medium">
                                <i class="fas fa-paper-plane mr-2"></i>Submit
                            </button>
                        </div>
                        <p class="text-xs sm:text-sm text-gray-600 mt-2">Press Enter or click Submit to process</p>
                    </div>

                    <!-- Hardware Scanner Simulation -->
                    <div>
                        <h2 class="text-lg sm:text-xl font-semibold mb-4 text-gray-800">
                            <i class="fas fa-barcode mr-2"></i>Test Scanner
                        </h2>
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                            <button onclick="simulateScan('imei')" class="bg-purple-600 text-white p-4 rounded-lg hover:bg-purple-700 transition duration-200 flex items-center justify-center text-sm sm:text-base font-medium">
                                <i class="fas fa-mobile-alt mr-2"></i>Scan IMEI
                            </button>
                            <button onclick="simulateScan('serial')" class="bg-indigo-600 text-white p-4 rounded-lg hover:bg-indigo-700 transition duration-200 flex items-center justify-center text-sm sm:text-base font-medium">
                                <i class="fas fa-barcode mr-2"></i>Scan Serial
                            </button>
                            <button onclick="simulateScan('barcode')" class="bg-pink-600 text-white p-4 rounded-lg hover:bg-pink-700 transition duration-200 flex items-center justify-center text-sm sm:text-base font-medium">
                                <i class="fas fa-qrcode mr-2"></i>Scan Barcode
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Scan Results -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-xl shadow-md p-6 h-full">
                    <h2 class="text-lg sm:text-xl font-semibold mb-4 text-gray-800">
                        <i class="fas fa-history mr-2"></i>Scan Results
                    </h2>
                    <div id="scan-results" class="space-y-3 max-h-[400px] overflow-y-auto">
                        <div class="text-center text-gray-500 py-8">
                            <i class="fas fa-inbox text-2xl sm:text-3xl mb-2"></i>
                            <p class="text-sm sm:text-base">No scans yet</p>
                            <p class="text-xs sm:text-sm">Scanning results will appear here</p>
                        </div>
                    </div>
                    <div class="mt-4 text-center">
                        <button id="clear-results" class="text-gray-600 hover:text-gray-800 text-sm font-medium">
                            <i class="fas fa-trash mr-1"></i>Clear All
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="mt-8 grid grid-cols-1 sm:grid-cols-3 gap-4 sm:gap-6">
            <div class="bg-white rounded-xl shadow-md p-6 text-center">
                <div class="text-2xl sm:text-3xl font-bold text-blue-600" id="total-scans">0</div>
                <div class="text-gray-600 mt-1 text-sm sm:text-base">Total Scans</div>
            </div>
            <div class="bg-white rounded-xl shadow-md p-6 text-center">
                <div class="text-2xl sm:text-3xl font-bold text-green-600" id="successful-scans">0</div>
                <div class="text-gray-600 mt-1 text-sm sm:text-base">Successful</div>
            </div>
            <div class="bg-white rounded-xl shadow-md p-6 text-center">
                <div class="text-2xl sm:text-3xl font-bold text-red-600" id="failed-scans">0</div>
                <div class="text-gray-600 mt-1 text-sm sm:text-base">Failed</div>
            </div>
        </div>
    </div>
</div>

<!-- Product Creation Modal -->
<div id="product-modal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
    <div class="relative top-10 mx-auto p-5 border w-full max-w-4xl shadow-lg rounded-md bg-white">
        <div class="flex justify-between items-center pb-3 border-b">
            <h3 class="text-2xl font-bold text-gray-800">Create New Product</h3>
            <button id="close-modal-btn" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-times fa-lg"></i>
            </button>
        </div>
        <div class="mt-5">
            <form id="product-form">
                <div id="modal-errors" class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4 hidden" role="alert"></div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Product Name -->
                    <div>
                        <label for="product_name" class="block text-sm font-medium text-gray-700">Product Name</label>
                        <input type="text" name="product_name" id="product_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Serial No -->
                    <div>
                        <label for="serial_no" class="block text-sm font-medium text-gray-700">Serial No</label>
                        <input type="text" name="serial_no" id="serial_no" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 bg-gray-100" readonly>
                    </div>
                    <!-- IMEI -->
                    <div>
                        <label for="imei" class="block text-sm font-medium text-gray-700">IMEI</label>
                        <input type="text" name="imei" id="imei" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Status -->
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                        <select name="status" id="status" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="In Warehouse" selected>In Warehouse</option>
                            <option value="Shipped">Shipped</option>
                            <option value="Delivered">Delivered</option>
                            <option value="Sold">Sold</option>
                            <option value="Returned">Returned</option>
                        </select>
                </div>
                <!-- Condition -->
                <div>
                    <label for="condition" class="block text-sm font-medium text-gray-700">Condition</label>
                    <select name="condition" id="condition" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="New" selected>New</option>
                        <option value="Used">Used</option>
                        <option value="Refurbished">Refurbished</option>
                    </select>
                    </div>
                    <!-- Quality -->
                    <div>
                        <label for="quality" class="block text-sm font-medium text-gray-700">Quality</label>
                        <select name="quality" id="quality" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="Authentic" selected>Authentic</option>
                            <option value="Premium">Premium</option>
                            <option value="Standard">Standard</option>
                        </select>
                    </div>
                    <!-- Color -->
                    <div>
                        <label for="color" class="block text-sm font-medium text-gray-700">Color</label>
                        <select name="color" id="color" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="Unknown">Unknown</option>
                            <option value="Black">Black</option>
                            <option value="White">White</option>
                            <option value="Silver">Silver</option>
                            <option value="Gray">Gray</option>
                            <option value="Blue">Blue</option>
                            <option value="Red">Red</option>
                            <option value="Gold">Gold</option>
                        </select>                    </div>
                    <!-- Distributor Name -->
                    <div>
                        <label for="distributor_name" class="block text-sm font-medium text-gray-700">Distributor Name</label>
                        <input type="text" name="distributor_name" id="distributor_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Retailer Name -->
                    <div>
                        <label for="retailer_name" class="block text-sm font-medium text-gray-700">Retailer Name</label>
                        <input type="text" name="retailer_name" id="retailer_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Image Upload -->
                    <div>
                        <label for="image" class="block text-sm font-medium text-gray-700">Product Image</label>
                        <input type="file" name="image" id="image" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                    </div>
                </div>
                <div class="mt-8 flex justify-end space-x-4">
                    <button type="button" id="cancel-modal-btn" class="bg-gray-200 text-gray-800 px-6 py-2 rounded-lg hover:bg-gray-300 transition-colors">Cancel</button>
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors flex items-center"><i class="fas fa-save mr-2"></i>Create Product</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Product Edit Modal -->
<div id="product-edit-modal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
    <div class="relative top-10 mx-auto p-5 border w-full max-w-4xl shadow-lg rounded-md bg-white">
        <div class="flex justify-between items-center pb-3 border-b">
            <h3 class="text-2xl font-bold text-gray-800">Edit Product</h3>
            <button id="close-edit-modal-btn" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-times fa-lg"></i>
            </button>
        </div>
        <div class="mt-5">
            <form id="product-edit-form">
                <?php echo method_field('PUT'); ?>
                <div id="edit-modal-errors" class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4 hidden" role="alert"></div>
                <input type="hidden" id="edit_product_id" name="product_id">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Product Name -->
                    <div>
                        <label for="edit_product_name" class="block text-sm font-medium text-gray-700">Product Name</label>
                        <input type="text" name="product_name" id="edit_product_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Serial No -->
                    <div>
                        <label for="edit_serial_no" class="block text-sm font-medium text-gray-700">Serial No</label>
                        <input type="text" name="serial_no" id="edit_serial_no" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- IMEI -->
                    <div>
                        <label for="edit_imei" class="block text-sm font-medium text-gray-700">IMEI</label>
                        <input type="text" name="imei" id="edit_imei" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Status -->
                    <div>
                        <label for="edit_status" class="block text-sm font-medium text-gray-700">Status</label>
                        <select name="status" id="edit_status" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="In Warehouse">In Warehouse</option>
                            <option value="Shipped">Shipped</option>
                            <option value="Delivered">Delivered</option>
                            <option value="Sold">Sold</option>
                            <option value="Returned">Returned</option>
                        </select>
                    </div>
                    <!-- Condition -->
                    <div>
                        <label for="edit_condition" class="block text-sm font-medium text-gray-700">Condition</label>
                        <select name="condition" id="edit_condition" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="New">New</option>
                            <option value="Used">Used</option>
                            <option value="Refurbished">Refurbished</option>
                        </select>
                    </div>
                    <!-- Quality -->
                    <div>
                        <label for="edit_quality" class="block text-sm font-medium text-gray-700">Quality</label>
                        <select name="quality" id="edit_quality" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="Authentic">Authentic</option>
                            <option value="Premium">Premium</option>
                            <option value="Standard">Standard</option>
                        </select>
                    </div>
                    <!-- Color -->
                    <div>
                        <label for="edit_color" class="block text-sm font-medium text-gray-700">Color</label>
                        <select name="color" id="edit_color" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="Unknown">Unknown</option>
                            <option value="Black">Black</option>
                            <option value="White">White</option>
                            <option value="Silver">Silver</option>
                            <option value="Gray">Gray</option>
                            <option value="Blue">Blue</option>
                            <option value="Red">Red</option>
                            <option value="Gold">Gold</option>
                        </select>                    </div>
                    <!-- Distributor Name -->
                    <div>
                        <label for="edit_distributor_name" class="block text-sm font-medium text-gray-700">Distributor Name</label>
                        <input type="text" name="distributor_name" id="edit_distributor_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Retailer Name -->
                    <div>
                        <label for="edit_retailer_name" class="block text-sm font-medium text-gray-700">Retailer Name</label>
                        <input type="text" name="retailer_name" id="edit_retailer_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Image Upload -->
                    <div class="md:col-span-2">
                        <label for="edit_image" class="block text-sm font-medium text-gray-700">Product Image</label>
                        <div class="mt-1 flex items-center space-x-4">
                            <img id="edit_image_preview" src="" alt="Current Image" class="h-16 w-16 object-cover rounded-md bg-gray-100">
                            <input type="file" name="image" id="edit_image" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                        </div>
                        <input type="hidden" name="_method" value="PUT">
                    </div>
                </div>
                <div class="mt-8 flex justify-end space-x-4">
                    <button type="button" id="cancel-edit-modal-btn" class="bg-gray-200 text-gray-800 px-6 py-2 rounded-lg hover:bg-gray-300 transition-colors">Cancel</button>
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors flex items-center">
                        <i class="fas fa-save mr-2"></i>Update Product
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Include HTML5 QR Code Scanner -->
<script src="https://unpkg.com/html5-qrcode/minified/html5-qrcode.min.js"></script>

<script>
let html5QrcodeScanner = null;
let stats = { total: 0, successful: 0, failed: 0 };
let isProcessing = false;
let scannedItems = new Set(); // Stores successfully scanned unique items to prevent re-processing

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('start-camera').addEventListener('click', startCameraScanner);
    document.getElementById('stop-camera').addEventListener('click', stopCameraScanner);
    document.getElementById('manual-scan-btn').addEventListener('click', processManualScan);
    document.getElementById('manual-scan').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') { e.preventDefault(); processManualScan(); }
    });
    document.getElementById('clear-results').addEventListener('click', clearResults);
    document.getElementById('manual-scan').focus();

    // Modal listeners
    const modal = document.getElementById('product-modal');
    document.getElementById('close-modal-btn').addEventListener('click', () => modal.classList.add('hidden'));
    document.getElementById('cancel-modal-btn').addEventListener('click', () => modal.classList.add('hidden'));
    document.getElementById('product-form').addEventListener('submit', submitProductForm);

    const editModal = document.getElementById('product-edit-modal');
    document.getElementById('close-edit-modal-btn').addEventListener('click', () => editModal.classList.add('hidden'));
    document.getElementById('cancel-edit-modal-btn').addEventListener('click', () => editModal.classList.add('hidden'));
    document.getElementById('product-edit-form').addEventListener('submit', submitProductEditForm);

});

function processManualScan() {
    const input = document.getElementById('manual-scan').value.trim();
    if (input) {
        processScan(input, 'manual');
        document.getElementById('manual-scan').value = '';
    }
}

function startCameraScanner() {
    if (html5QrcodeScanner) stopCameraScanner();
    html5QrcodeScanner = new Html5Qrcode("reader");
    html5QrcodeScanner.start(
        { facingMode: "environment" },
        { fps: 10, qrbox: { width: 250, height: 250 } },
        (decodedText) => { processScan(decodedText, 'camera'); },
        (errorMessage) => { if (!errorMessage.includes('No MultiFormat Readers')) console.log(errorMessage); }
    ).catch(err => { showError(err.message); });

    document.getElementById('start-camera').classList.add('hidden');
    document.getElementById('stop-camera').classList.remove('hidden');
}

function stopCameraScanner() {
    if (html5QrcodeScanner) {
        html5QrcodeScanner.stop().then(() => { html5QrcodeScanner = null; }).catch(console.error);
    }
    document.getElementById('start-camera').classList.remove('hidden');
    document.getElementById('stop-camera').classList.add('hidden');
}

function processScan(scanData, source) {
    if (isProcessing) { showMessage('Processing previous scan...', 'warning'); return; }
    if (!scanData.trim()) { showMessage('Please enter scan data', 'error'); return; }

    // Check if this item has already been successfully scanned
    if (scannedItems.has(scanData)) {
        showMessage('This item has already been processed.', 'error');
        document.getElementById('manual-scan').focus();
        return;
    }

    isProcessing = true;
    stats.total++;
    const resultId = 'scan-' + Date.now();
    addScanResult(resultId, 'loading', 'Processing scan...', scanData);

    fetch('<?php echo e(route("admin.scanner.scan")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ scan_data: scanData, source: source })
    })
    .then(res => res.ok ? res.json() : res.text().then(text => { throw new Error(text); }))
    .then(data => {
        if (data.success) {
            if (data.action === 'new') {
                updateScanResult(resultId, 'info', `📝 New product found. Please fill details.`, scanData);
                openProductModal(data.product, resultId, scanData);
            } else if (data.action === 'exists') {
                // Product already exists. Show an error and do not open the modal.
                stats.failed++;
                updateScanResult(resultId, 'error', `❌ Already exists in database.`, scanData, data.product);
                showMessage('This product already exists in the database.', 'error');
                scannedItems.add(scanData); // Add to session scanned items to prevent re-processing.
            } else {
                stats.failed++;
                updateScanResult(resultId, 'error', `❌ Unknown action: ${data.action}`, scanData);
            }
        } else {
            stats.failed++;
            updateScanResult(resultId, 'error', `❌ ${data.message}`, scanData);
            showMessage(data.message, 'error');
        }
    })
    .catch(error => {
        stats.failed++;
        updateScanResult(resultId, 'error', `❌ Scan failed: ${error.message}`, scanData);
        showMessage(error.message, 'error');
    })
    .finally(() => { isProcessing = false; updateStatistics(); document.getElementById('manual-scan').focus(); });
}

function addScanResult(resultId, type, message, scanData, product = null) {
    const resultsDiv = document.getElementById('scan-results');
    const emptyState = resultsDiv.querySelector('.text-center');
    if (emptyState) emptyState.remove();
    const timestamp = new Date().toLocaleTimeString();
    const icon = type === 'success' ? 'fa-check-circle' : type === 'error' ? 'fa-times-circle' : 'fa-spinner fa-spin';
    const color = type === 'success' ? 'text-green-500' : type === 'error' ? 'text-red-500' : 'text-blue-500';
    const borderColor = type === 'success' ? 'border-l-green-500' : type === 'error' ? 'border-l-red-500' : 'border-l-blue-500';

    const resultHtml = `
        <div id="${resultId}" class="flex items-start p-4 border-l-4 ${borderColor} bg-gray-50 rounded-r-lg scan-result">
            <i class="fas ${icon} ${color} mr-3 mt-1"></i>
            <div class="flex-grow">
                <div class="font-medium text-gray-800 text-sm sm:text-base">${message}</div>
                <div class="text-xs sm:text-sm text-gray-600 font-mono mt-1">${scanData}</div>
                ${product ? `<div class="text-xs text-gray-500 mt-2 pt-2 border-t border-gray-200 space-y-1">
                    <div><span class="font-medium text-gray-600">Product:</span> ${product.product_name}</div>
                    <div><span class="font-medium text-gray-600">Serial:</span> ${product.serial_no}</div>
                    ${product.imei ? `<div><span class="font-medium text-gray-600">IMEI:</span> ${product.imei}</div>` : ''}
                    <div>
                        <span class="font-medium text-gray-600">Status:</span> <span class="px-1.5 py-0.5 text-xs font-semibold rounded-full ${getStatusColor(product.status)}">${product.status}</span> |
                        <span class="font-medium text-gray-600">Quality:</span> ${product.quality}
                        ${product.distributor_name ? `<div><span class="font-medium text-gray-600">Distributor:</span> ${product.distributor_name}</div>` : ''}
                        ${product.retailer_name ? `<div><span class="font-medium text-gray-600">Retailer:</span> ${product.retailer_name}</div>` : ''}
                    </div>
                </div>` : ''}
                <div class="text-xs text-gray-400 mt-1">${timestamp}</div>
            </div>
            <button onclick="removeResult('${resultId}')" class="text-gray-400 hover:text-gray-600 ml-2">
                <i class="fas fa-times"></i>
            </button>
        </div>
    `;
    resultsDiv.insertAdjacentHTML('afterbegin', resultHtml);
}

function updateScanResult(resultId, type, message, scanData, product = null) {
    const element = document.getElementById(resultId);
    if (element) element.remove();
    addScanResult(resultId, type, message, scanData, product);
}

function openProductModal(productData, resultId, scanData) {
    const form = document.getElementById('product-form');
    form.reset();
    document.getElementById('modal-errors').classList.add('hidden');

    // Store temporary data on the form
    form.dataset.resultId = resultId;
    form.dataset.scanData = scanData;

    // Populate form fields
    form.querySelector('#product_name').value = productData.product_name || `Scanned Product - ${new Date().toLocaleTimeString()}`;
    form.querySelector('#serial_no').value = productData.serial_no || '';
    const imeiInput = form.querySelector('#imei');
    imeiInput.value = productData.imei || '';
    form.querySelector('#status').value = productData.status || 'In Warehouse';
    form.querySelector('#quality').value = productData.quality || 'Authentic';
    // Set default condition
    const conditionSelect = form.querySelector('#condition');
    if (conditionSelect) conditionSelect.value = productData.condition || 'New';

    // Make IMEI readonly only if the original scan was an IMEI
    const isImeiScan = /^\d{15}$/.test(scanData);
    imeiInput.readOnly = isImeiScan;
    imeiInput.classList.toggle('bg-gray-100', isImeiScan);

    form.querySelector('#color').value = productData.color || 'Unknown';
    // Populate distributor and retailer names
    form.querySelector('#distributor_name').value = productData.distributor_name || '';
    form.querySelector('#retailer_name').value = productData.retailer_name || '';


    document.getElementById('product-modal').classList.remove('hidden');
    form.querySelector('#product_name').focus();
}

function openProductEditModal(productData, resultId, scanData) {
    const form = document.getElementById('product-edit-form');
    form.reset();
    document.getElementById('edit-modal-errors').classList.add('hidden');

    form.dataset.resultId = resultId;
    form.dataset.scanData = scanData;

    // Populate form fields with existing data
    form.querySelector('#edit_product_id').value = productData.id;
    form.querySelector('#edit_product_name').value = productData.product_name;
    form.querySelector('#edit_serial_no').value = productData.serial_no;
    form.querySelector('#edit_imei').value = productData.imei;
    form.querySelector('#edit_status').value = productData.status;
    form.querySelector('#edit_condition').value = productData.condition;
    form.querySelector('#edit_quality').value = productData.quality;
    form.querySelector('#edit_color').value = productData.color;
    form.querySelector('#edit_distributor_name').value = productData.distributor_name;
    form.querySelector('#edit_retailer_name').value = productData.retailer_name;
    const imagePreview = form.querySelector('#edit_image_preview');
    imagePreview.src = productData.image ? `<?php echo e(asset('storage')); ?>/${productData.image}` : 'https://via.placeholder.com/150';


    document.getElementById('product-edit-modal').classList.remove('hidden');
    form.querySelector('#edit_product_name').focus();
}

function submitProductForm(event) {
    event.preventDefault();
    const form = event.target;
    const formData = new FormData(form);
    const resultId = form.dataset.resultId;
    const scanData = form.dataset.scanData;

    fetch('<?php echo e(route("admin.products.store")); ?>', {
        method: 'POST',
        headers: {
            // 'Content-Type': 'application/json', // Remove this for FormData
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(response => response.json().then(body => ({ ok: response.ok, body })))
    .then(({ ok, body }) => {
        if (ok && body.success) {
            stats.successful++;
            updateScanResult(resultId, 'success', `✅ New product created`, scanData, body.product);
            showMessage(body.message, 'success');            scannedItems.add(scanData); // Mark as processed
            document.getElementById('product-modal').classList.add('hidden');
        } else {
            const errorContainer = document.getElementById('modal-errors');
            let errorHtml = '<p class="font-bold">Please correct the following errors:</p><ul class="list-disc list-inside">';
            if (body.errors) {
                for (const field in body.errors) {
                    errorHtml += `<li>${body.errors[field][0]}</li>`;
                }
            } else {
                errorHtml += `<li>${body.message || 'An unknown error occurred.'}</li>`;
            }
            errorHtml += '</ul>';
            errorContainer.innerHTML = errorHtml;
            errorContainer.classList.remove('hidden');
        }
    })
    .catch(console.error)
    .finally(() => updateStatistics());
}

function submitProductEditForm(event) {
    event.preventDefault();
    const form = event.target;
    const formData = new FormData(form);
    const productId = formData.get('product_id');
    const resultId = form.dataset.resultId;
    const scanData = form.dataset.scanData;

    // The form method is spoofed to PUT by the hidden input, so we use POST here.
    fetch(`/admin/products/${productId}`, {
        method: 'POST', // FormData with files requires POST
        headers: {
            // 'Content-Type': 'multipart/form-data' is set automatically by the browser with FormData
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(response => response.json().then(body => ({ ok: response.ok, body })))
    .then(({ ok, body }) => {
        if (ok && body.success) {
            stats.successful++;
            updateScanResult(resultId, 'success', `✅ Product updated successfully`, scanData, body.product);
            showMessage(body.message, 'success');            scannedItems.add(scanData); // Mark as processed
            document.getElementById('product-edit-modal').classList.add('hidden');
        } else {
            const errorContainer = document.getElementById('edit-modal-errors');
            let errorHtml = '<p class="font-bold">Please correct the following errors:</p><ul class="list-disc list-inside">';
            if (body.errors) {
                for (const field in body.errors) {
                    errorHtml += `<li>${body.errors[field][0]}</li>`;
                }
            } else {
                errorHtml += `<li>${body.message || 'An unknown error occurred.'}</li>`;
            }
            errorHtml += '</ul>';
            errorContainer.innerHTML = errorHtml;
            errorContainer.classList.remove('hidden');
        }
    })
    .catch(console.error)
    .finally(() => updateStatistics());
}

function removeResult(resultId) {
    const element = document.getElementById(resultId);
    if (element) element.remove();
    const resultsDiv = document.getElementById('scan-results');
    if (resultsDiv.children.length === 0) {
        resultsDiv.innerHTML = `<div class="text-center text-gray-500 py-8">
            <i class="fas fa-inbox text-2xl sm:text-3xl mb-2"></i>
            <p class="text-sm sm:text-base">No scans yet</p>
            <p class="text-xs sm:text-sm">Scanning results will appear here</p>
        </div>`;
    }
}

function clearResults() {
    document.getElementById('scan-results').innerHTML = `<div class="text-center text-gray-500 py-8">
        <i class="fas fa-inbox text-2xl sm:text-3xl mb-2"></i>
        <p class="text-sm sm:text-base">No scans yet</p>
        <p class="text-xs sm:text-sm">Scanning results will appear here</p>
    </div>`; // Clear the UI
    scannedItems.clear(); // Clear the set of scanned items
}

function simulateScan(type) {
    let testData = type === 'imei' ? generateIMEI() :
                   type === 'serial' ? 'SN' + Date.now().toString().slice(-8) :
                   'BC' + Date.now().toString().slice(-8);
    processScan(testData, 'simulation');
}

function generateIMEI() {
    let imei = '35';
    for (let i = 0; i < 13; i++) imei += Math.floor(Math.random() * 10);
    return imei;
}

function updateStatistics() {
    document.getElementById('total-scans').textContent = stats.total;
    document.getElementById('successful-scans').textContent = stats.successful;
    document.getElementById('failed-scans').textContent = stats.failed;
}

function getStatusColor(status) {
    const colors = {
        'In Warehouse': 'bg-blue-100 text-blue-800',
        'Shipped': 'bg-yellow-100 text-yellow-800',
        'Delivered': 'bg-green-100 text-green-800',
        'Sold': 'bg-purple-100 text-purple-800',
        'Returned': 'bg-red-100 text-red-800'
    };
    return colors[status] || 'bg-gray-100 text-gray-800';
}

function showMessage(message, type) {
    const toast = document.createElement('div');
    toast.className = `fixed top-4 right-4 p-4 rounded-lg shadow-lg z-50 flex items-center text-sm sm:text-base
        ${type === 'success' ? 'bg-green-500 text-white' : type === 'error' ? 'bg-red-500 text-white' : 'bg-blue-500 text-white'}`;
    toast.innerHTML = `
        <i class="fas ${type === 'success' ? 'fa-check-circle' : type === 'error' ? 'fa-exclamation-circle' : 'fa-info-circle'} mr-2"></i> <!-- Changed to fa-info-circle for 'info' type -->
        <span>${message}</span>
        <button onclick="this.parentElement.remove()" class="ml-4 text-white hover:text-gray-200">
            <i class="fas fa-times"></i>
        </button>`;
    document.body.appendChild(toast);
    setTimeout(() => { if (toast.parentElement) toast.remove(); }, 5000);
}

function showError(message) {
    showMessage(message, 'error');
}

window.addEventListener('beforeunload', stopCameraScanner);
</script>

<style>
#reader {
    min-height: 300px;
    position: relative;
}
#reader video {
    width: 100% !important;
    border-radius: 8px;
    object-fit: cover;
}
.scan-result {
    animation: slideIn 0.3s ease-out;
}
@keyframes slideIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}
#scan-results::-webkit-scrollbar {
    width: 6px;
}
#scan-results::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}
#scan-results::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 3px;
}
#scan-results::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/admin/scanner/index.blade.php ENDPATH**/ ?>