<?php $__env->startSection('title', 'All Products - NewTech'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title -->
    <div class="bg-gray-200 py-8 px-4">
        <div class="container mx-auto max-w-6xl">
            <h1 class="text-3xl font-bold text-gray-800">
                <?php echo e(request('category') ? Str::title(str_replace('-', ' ', request('category'))) : 'All Products'); ?>

            </h1>
            <p class="text-gray-600 mt-2">Browse our collection of premium devices and accessories.</p>
        </div>
    </div>

    <!-- Products Grid -->
    <section class="py-12 px-4">
        <div class="container mx-auto max-w-6xl">
            <?php if($products->count() > 0): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-xl transition-shadow duration-300 group">
                            <div class="h-48 bg-gray-200 flex items-center justify-center">
                                <i class="fas fa-mobile-alt text-6xl text-gray-400"></i>
                            </div>
                            <div class="p-4">
                                <h3 class="font-bold text-lg mb-2 truncate group-hover:text-red-600"><?php echo e($product->product_name); ?></h3>
                                <p class="text-gray-600 text-sm mb-4 h-10"><?php echo e(Str::limit($product->description, 50)); ?></p>
                                <div class="flex justify-between items-center">
                                    <span class="font-bold text-xl text-red-600">৳<?php echo e(number_format($product->price)); ?></span>
                                    <button class="bg-red-600 text-white py-2 px-4 rounded-lg hover:bg-red-700 transition duration-300 text-sm">Add to Cart</button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="mt-12">
                    <?php echo e($products->links()); ?>

                </div>
            <?php else: ?>
                <p class="text-center text-gray-600 text-lg">No products found matching your criteria.</p>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\product-authentication-system2\resources\views/frontend/pages/products.blade.php ENDPATH**/ ?>