<?php $__env->startSection('title', 'Edit Product'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-4xl mx-auto bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-gradient-to-r from-indigo-600 to-blue-700 px-6 py-4">
            <h1 class="text-2xl font-bold text-white flex items-center"><i class="fas fa-pencil-alt mr-3"></i>Edit Product</h1>
            <p class="text-indigo-100 mt-1">Update details for: <?php echo e($product->product_name); ?> (<?php echo e($product->serial_no); ?>)</p>
        </div>

        <form action="<?php echo e(route('admin.products.update', $product->id)); ?>" method="POST" enctype="multipart/form-data" class="p-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <?php if($errors->any()): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
                    <p class="font-bold">Please correct the errors below:</p>
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Product Name -->
                <div>
                    <label for="product_name" class="block text-sm font-medium text-gray-700">Product Name</label>
                    <input type="text" name="product_name" id="product_name" value="<?php echo e(old('product_name', $product->product_name)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- Serial No -->
                <div>
                    <label for="serial_no" class="block text-sm font-medium text-gray-700">Serial No</label>
                    <input type="text" name="serial_no" id="serial_no" value="<?php echo e(old('serial_no', $product->serial_no)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- IMEI -->
                <div>
                    <label for="imei" class="block text-sm font-medium text-gray-700">IMEI</label>
                    <input type="text" name="imei" id="imei" value="<?php echo e(old('imei', $product->imei)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- Status -->
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" id="status" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="In Warehouse" <?php echo e(old('status', $product->status) == 'In Warehouse' ? 'selected' : ''); ?>>In Warehouse</option>
                        <option value="Shipped" <?php echo e(old('status', $product->status) == 'Shipped' ? 'selected' : ''); ?>>Shipped</option>
                        <option value="Delivered" <?php echo e(old('status', $product->status) == 'Delivered' ? 'selected' : ''); ?>>Delivered</option>
                        <option value="Sold" <?php echo e(old('status', $product->status) == 'Sold' ? 'selected' : ''); ?>>Sold</option>
                        <option value="Returned" <?php echo e(old('status', $product->status) == 'Returned' ? 'selected' : ''); ?>>Returned</option>
                    </select>
                </div>

                <!-- Quality -->
                <div>
                    <label for="quality" class="block text-sm font-medium text-gray-700">Quality</label>
                    <select name="quality" id="quality" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="Authentic" <?php echo e(old('quality', $product->quality) == 'Authentic' ? 'selected' : ''); ?>>Authentic</option>
                        <option value="Premium" <?php echo e(old('quality', $product->quality) == 'Premium' ? 'selected' : ''); ?>>Premium</option>
                        <option value="Standard" <?php echo e(old('quality', $product->quality) == 'Standard' ? 'selected' : ''); ?>>Standard</option>
                        <option value="Economy" <?php echo e(old('quality', $product->quality) == 'Economy' ? 'selected' : ''); ?>>Economy</option>
                    </select>
                </div>

                <!-- Color -->
                <div>
                    <label for="color" class="block text-sm font-medium text-gray-700">Color</label>
                    <select name="color" id="color" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="Blue Ae" <?php echo e(old('color', $product->color) == 'Blue Ae' ? 'selected' : ''); ?>>Blue Ae</option>
                        <option value="White" <?php echo e(old('color', $product->color) == 'White' ? 'selected' : ''); ?>>White</option>
                        <option value="Black" <?php echo e(old('color', $product->color) == 'Black' ? 'selected' : ''); ?>>Black</option>
                        <option value="Red" <?php echo e(old('color', $product->color) == 'Red' ? 'selected' : ''); ?>>Red</option>
                    </select>
                </div>

                <!-- Distributor Name -->
                <div>
                    <label for="distributor_name" class="block text-sm font-medium text-gray-700">Distributor Name</label>
                    <input type="text" name="distributor_name" id="distributor_name" value="<?php echo e(old('distributor_name', $product->distributor_name)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- Retailer Name -->
                <div>
                    <label for="retailer_name" class="block text-sm font-medium text-gray-700">Retailer Name</label>
                    <input type="text" name="retailer_name" id="retailer_name" value="<?php echo e(old('retailer_name', $product->retailer_name)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- Client Name -->
                <div class="md:col-span-2">
                    <label for="client_name" class="block text-sm font-medium text-gray-700">Client Name</label>
                    <input type="text" name="client_name" id="client_name" value="<?php echo e(old('client_name', $product->client_name)); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- Image Upload -->
                <div class="md:col-span-2">
                    <label for="image" class="block text-sm font-medium text-gray-700">Product Image</label>
                    <div class="mt-2 flex items-center space-x-6">
                        <div class="shrink-0">
                            <img id="image_preview" class="h-20 w-20 object-cover rounded-md" src="<?php echo e($product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/150'); ?>" alt="Current product image">
                        </div>
                        <input type="file" name="image" id="image" onchange="document.getElementById('image_preview').src = window.URL.createObjectURL(this.files[0])" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                    </div>
                </div>

            </div>

            <div class="mt-8 flex justify-end space-x-4">
                <a href="<?php echo e(route('admin.products')); ?>" class="bg-gray-200 text-gray-800 px-6 py-2 rounded-lg hover:bg-gray-300 transition-colors">
                    Cancel
                </a>
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors flex items-center">
                    <i class="fas fa-save mr-2"></i>Update Product
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/products/edit.blade.php ENDPATH**/ ?>